/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class RestSuggestAction
extends BaseRestHandler {
    private final SearchRequestParsers searchRequestParsers;

    @Inject
    public RestSuggestAction(Settings settings, RestController controller, SearchRequestParsers searchRequestParsers) {
        super(settings);
        this.searchRequestParsers = searchRequestParsers;
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_suggest", this, "[POST /_suggest] is deprecated! Use [POST /_search] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_suggest", this, "[GET /_suggest] is deprecated! Use [GET /_search] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/{index}/_suggest", this, "[POST /{index}/_suggest] is deprecated! Use [POST /{index}/_search] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/{index}/_suggest", this, "[GET /{index}/_suggest] is deprecated! Use [GET /{index}/_search] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest(Strings.splitStringByCommaToArray(request.param("index")), new SearchSourceBuilder());
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            QueryParseContext context = new QueryParseContext(parser, this.parseFieldMatcher);
            searchRequest.source().suggest(SuggestBuilder.fromXContent(context, this.searchRequestParsers.suggesters));
        }
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        return channel -> client.search(searchRequest, (ActionListener<SearchResponse>)new RestBuilderListener<SearchResponse>(channel){

            @Override
            public RestResponse buildResponse(SearchResponse response, XContentBuilder builder) throws Exception {
                RestStatus restStatus = RestStatus.status(response.getSuccessfulShards(), response.getTotalShards(), response.getShardFailures());
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), response.getShardFailures());
                Suggest suggest = response.getSuggest();
                if (suggest != null) {
                    suggest.toInnerXContent(builder, request);
                }
                builder.endObject();
                return new BytesRestResponse(restStatus, builder);
            }
        });
    }
}

