/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class I18N {
    private ResourceBundle stdMessages = null;
    private Locale locale = null;
    private Map<String, ResourceBundle> addonMessages = new HashMap<String, ResourceBundle>();
    private static final Logger logger = Logger.getLogger(I18N.class);

    public I18N(Locale locale) {
        this.setLocale(locale);
    }

    public void addMessageBundle(String string, ResourceBundle resourceBundle) {
        logger.debug((Object)("Adding message bundle with prefix: " + string));
        if (this.addonMessages.containsKey(string)) {
            logger.error((Object)("Adding message bundle with duplicate prefix: " + string));
        }
        this.addonMessages.put(string, resourceBundle);
    }

    public void removeMessageBundle(String string) {
        logger.debug((Object)("Removing message bundle with prefix: " + string));
        if (this.addonMessages.containsKey(string)) {
            this.addonMessages.remove(string);
        } else {
            logger.debug((Object)("Message bundle not found, prefix: " + string));
        }
    }

    public ResourceBundle getMessageBundle(String string) {
        return this.addonMessages.get(string);
    }

    public String getString(String string) {
        String string2;
        ResourceBundle resourceBundle;
        if (string.indexOf(".") > 0 && (resourceBundle = this.addonMessages.get(string2 = string.substring(0, string.indexOf(".")))) != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string);
        }
        return this.stdMessages.getString(string);
    }

    public String getHtmlWrappedString(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return null;
        }
        return "<html><p>" + string2 + "</p></html>";
    }

    public char getChar(String string) {
        try {
            String string2 = this.getString(string);
            if (string2.length() > 0) {
                return string2.charAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\u0000';
    }

    public void setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.stdMessages = ResourceBundle.getBundle("Messages", locale, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    public Locale getLocal() {
        return this.locale;
    }

    public boolean containsKey(String string) {
        String string2;
        ResourceBundle resourceBundle;
        if (string.indexOf(".") > 0 && (resourceBundle = this.addonMessages.get(string2 = string.substring(0, string.indexOf(".")))) != null && resourceBundle.containsKey(string)) {
            return true;
        }
        return this.stdMessages.containsKey(string);
    }

    public String getString(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(this.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }
}

