/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.interop.RubyMessageResolutionAccessor;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.objects.shared.SharedObjects;

public class RubyObjectType
extends ObjectType {
    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString(DynamicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        if (RubyGuards.isRubyString(object)) {
            return RopeOperations.decodeRope(StringOperations.rope(object));
        }
        if (RubyGuards.isRubySymbol(object)) {
            return Layouts.SYMBOL.getString(object);
        }
        if (RubyGuards.isRubyException(object)) {
            return Layouts.EXCEPTION.getMessage(object).toString();
        }
        if (RubyGuards.isRubyModule(object)) {
            return Layouts.MODULE.getFields(object).getName();
        }
        String className = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(object)).getName();
        String isShared = SharedObjects.isShared(object) ? "(shared)" : "";
        return StringUtils.format("DynamicObject@%x<%s>%s", System.identityHashCode(object), className, isShared);
    }

    @Override
    public ForeignAccess getForeignAccessFactory(DynamicObject object) {
        return RubyMessageResolutionAccessor.ACCESS;
    }
}

