/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.Cookie;
import gnu.inet.http.CookieManager;
import gnu.inet.http.Request;
import gnu.inet.http.event.ConnectionEvent;
import gnu.inet.http.event.ConnectionListener;
import gnu.inet.http.event.RequestEvent;
import gnu.inet.http.event.RequestListener;
import gnu.inet.util.EmptyX509TrustManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = HTTPConnection.initUserAgent();
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List connectionListeners;
    private final List requestListeners;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    private Map nonceCounts;
    protected CookieManager cookieManager;

    private static String initUserAgent() {
        try {
            StringBuffer stringBuffer = new StringBuffer("inetlib/1.1 (");
            stringBuffer.append(System.getProperty("os.name"));
            stringBuffer.append("; ");
            stringBuffer.append(System.getProperty("os.arch"));
            stringBuffer.append("; ");
            stringBuffer.append(System.getProperty("user.language"));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        catch (SecurityException securityException) {
            return "inetlib/1.1";
        }
    }

    public HTTPConnection(String string) {
        this(string, 80, false, 0, 0);
    }

    public HTTPConnection(String string, boolean bl) {
        this(string, bl ? 443 : 80, bl, 0, 0);
    }

    public HTTPConnection(String string, boolean bl, int n, int n2) {
        this(string, bl ? 443 : 80, bl, n, n2);
    }

    public HTTPConnection(String string, int n) {
        this(string, n, false, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl) {
        this(string, n, bl, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl, int n2, int n3) {
        this.hostname = string;
        this.port = n;
        this.secure = bl;
        this.connectionTimeout = n2;
        this.timeout = n3;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.connectionListeners = Collections.synchronizedList(new ArrayList(4));
        this.requestListeners = Collections.synchronizedList(new ArrayList(4));
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int n, int n2) {
        if (n != 1) {
            throw new IllegalArgumentException("major version not supported: " + n);
        }
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("minor version not supported: " + n2);
        }
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public void setProxy(String string, int n) {
        this.proxyHostname = string;
        this.proxyPort = n;
    }

    public boolean isUsingProxy() {
        return this.proxyHostname != null && this.proxyPort > 0;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public Request newRequest(String string, String string2) {
        Cookie[] cookieArray;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        Request request = new Request(this, string, string2);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            request.setHeader("Host", this.hostname + ":" + this.port);
        } else {
            request.setHeader("Host", this.hostname);
        }
        request.setHeader("User-Agent", userAgent);
        request.setHeader("Connection", "keep-alive");
        request.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookieArray = this.cookieManager.getCookies(this.hostname, this.secure, string2)) != null && cookieArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("$Version=1");
            for (int i = 0; i < cookieArray.length; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
                stringBuffer.append(cookieArray[i].toString());
            }
            request.setHeader("Cookie", stringBuffer.toString());
        }
        this.fireRequestEvent(0, request);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.closeConnection();
        }
        finally {
            this.fireConnectionEvent(0);
        }
    }

    protected Socket getSocket() throws IOException {
        if (this.socket == null) {
            String string = this.hostname;
            int n = this.port;
            if (this.isUsingProxy()) {
                string = this.proxyHostname;
                n = this.proxyPort;
            }
            this.socket = new Socket();
            InetAddress inetAddress = InetAddress.getByName(string);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
            if (this.connectionTimeout > 0) {
                this.socket.connect(inetSocketAddress, this.connectionTimeout);
            } else {
                this.socket.connect(inetSocketAddress);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            if (this.secure) {
                try {
                    EmptyX509TrustManager emptyX509TrustManager = new EmptyX509TrustManager();
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    TrustManager[] trustManagerArray = new TrustManager[]{emptyX509TrustManager};
                    sSLContext.init(null, trustManagerArray, null);
                    SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                    SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
                    String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                    sSLSocket.setEnabledProtocols(stringArray);
                    sSLSocket.setUseClientMode(true);
                    sSLSocket.startHandshake();
                    this.socket = sSLSocket;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException(generalSecurityException.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        return this.socket;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected String getURI() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.secure ? "https://" : "http://");
        stringBuffer.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                stringBuffer.append(':');
                stringBuffer.append(this.port);
            }
        } else if (this.port != 80) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        return stringBuffer.toString();
    }

    int getNonceCount(String string) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return (Integer)this.nonceCounts.get(string);
    }

    void incrementNonce(String string) {
        int n = this.getNonceCount(string);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap();
        }
        this.nonceCounts.put(string, new Integer(n + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.add(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionEvent(int n) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, n);
        ConnectionListener[] connectionListenerArray = null;
        List list = this.connectionListeners;
        synchronized (list) {
            connectionListenerArray = new ConnectionListener[this.connectionListeners.size()];
            this.connectionListeners.toArray(connectionListenerArray);
        }
        for (int i = 0; i < connectionListenerArray.length; ++i) {
            switch (n) {
                case 0: {
                    connectionListenerArray[i].connectionClosed(connectionEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(RequestListener requestListener) {
        List list = this.requestListeners;
        synchronized (list) {
            this.requestListeners.add(requestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestListener(RequestListener requestListener) {
        List list = this.requestListeners;
        synchronized (list) {
            this.requestListeners.remove(requestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRequestEvent(int n, Request request) {
        RequestEvent requestEvent = new RequestEvent(this, n, request);
        RequestListener[] requestListenerArray = null;
        List list = this.requestListeners;
        synchronized (list) {
            requestListenerArray = new RequestListener[this.requestListeners.size()];
            this.requestListeners.toArray(requestListenerArray);
        }
        block8: for (int i = 0; i < requestListenerArray.length; ++i) {
            switch (n) {
                case 0: {
                    requestListenerArray[i].requestCreated(requestEvent);
                    continue block8;
                }
                case 1: {
                    requestListenerArray[i].requestSent(requestEvent);
                    continue block8;
                }
                case 2: {
                    requestListenerArray[i].requestSent(requestEvent);
                }
            }
        }
    }
}

