/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.internal.crypto.dk.DkCrypto;

public class Des3DkCrypto
extends DkCrypto {
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    protected int getKeySeedLength() {
        return 168;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] stringToKey(char[] salt) throws GeneralSecurityException {
        byte[] saltUtf8 = null;
        try {
            saltUtf8 = Des3DkCrypto.charToUtf8(salt);
            byte[] byArray = this.stringToKey(saltUtf8, null);
            return byArray;
        }
        finally {
            if (saltUtf8 != null) {
                Arrays.fill(saltUtf8, (byte)0);
            }
        }
    }

    private byte[] stringToKey(byte[] secretAndSalt, byte[] opaque) throws GeneralSecurityException {
        if (opaque != null && opaque.length > 0) {
            throw new RuntimeException("Invalid parameter to stringToKey");
        }
        byte[] tmpKey = this.randomToKey(Des3DkCrypto.nfold(secretAndSalt, this.getKeySeedLength()));
        return this.dk(tmpKey, KERBEROS_CONSTANT);
    }

    public byte[] parityFix(byte[] value) throws GeneralSecurityException {
        Des3DkCrypto.setParityBit(value);
        return value;
    }

    @Override
    protected byte[] randomToKey(byte[] in) {
        if (in.length != 21) {
            throw new IllegalArgumentException("input must be 168 bits");
        }
        byte[] one = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(in, 0, 7));
        byte[] two = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(in, 7, 14));
        byte[] three = Des3DkCrypto.keyCorrection(Des3DkCrypto.des3Expand(in, 14, 21));
        byte[] key = new byte[24];
        System.arraycopy(one, 0, key, 0, 8);
        System.arraycopy(two, 0, key, 8, 8);
        System.arraycopy(three, 0, key, 16, 8);
        return key;
    }

    private static byte[] keyCorrection(byte[] key) {
        try {
            if (DESKeySpec.isWeak(key, 0)) {
                key[7] = (byte)(key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return key;
    }

    private static byte[] des3Expand(byte[] input, int start, int end) {
        if (end - start != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + start + "," + end);
        }
        byte[] result = new byte[8];
        byte last = 0;
        System.arraycopy(input, start, result, 0, 7);
        int posn = 0;
        for (int i = start; i < end; ++i) {
            byte bit = (byte)(input[i] & 1);
            posn = (byte)(posn + 1);
            if (bit == 0) continue;
            last = (byte)(last | bit << posn);
        }
        result[7] = last;
        Des3DkCrypto.setParityBit(result);
        return result;
    }

    private static void setParityBit(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int b = key[i] & 0xFE;
            b |= Integer.bitCount(b) & 1 ^ 1;
            key[i] = (byte)b;
        }
    }

    @Override
    protected Cipher getCipher(byte[] key, byte[] ivec, int mode) throws GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("desede");
        DESedeKeySpec spec = new DESedeKeySpec(key, 0);
        SecretKey secretKey = factory.generateSecret(spec);
        if (ivec == null) {
            ivec = ZERO_IV;
        }
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
        cipher.init(mode, (Key)secretKey, encIv);
        return cipher;
    }

    @Override
    public int getChecksumLength() {
        return 20;
    }

    @Override
    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HmacSHA1");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(keyKi);
        return m.doFinal(msg);
    }
}

