/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public class ModelPrinter {
    private static final Log logger = LogFactory.getLog(ModelPrinter.class);

    private ModelPrinter() {
    }

    public static void printParents(RenderNode renderNode) {
        while (renderNode != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(renderNode.getClass().getName());
            stringBuffer.append('[');
            stringBuffer.append(Integer.toHexString(System.identityHashCode(renderNode)));
            stringBuffer.append(']');
            logger.debug((Object)stringBuffer);
            renderNode = renderNode.getParent();
        }
    }

    public static void print(RenderBox renderBox) {
        ModelPrinter.printBox(renderBox, 0);
    }

    public static void printBox(RenderBox renderBox, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(renderBox.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append(Integer.toHexString(System.identityHashCode(renderBox)));
        stringBuffer.append(']');
        stringBuffer.append("={x=");
        stringBuffer.append(renderBox.getX());
        stringBuffer.append(", y=");
        stringBuffer.append(renderBox.getY());
        stringBuffer.append(", width=");
        stringBuffer.append(renderBox.getWidth());
        stringBuffer.append(", height=");
        stringBuffer.append(renderBox.getHeight());
        stringBuffer.append('}');
        logger.debug((Object)stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("- nodeLayoutProperties=");
        stringBuffer.append(renderBox.getNodeLayoutProperties());
        logger.debug((Object)stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("- boxLayoutProperties=");
        stringBuffer.append(renderBox.getBoxLayoutProperties());
        logger.debug((Object)stringBuffer.toString());
        if (renderBox instanceof TableRowRenderBox) {
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderBox;
            TableRowInfoStructure tableRowInfoStructure = tableRowRenderBox.getRowInfoStructure();
            for (int i = 0; i < tableRowInfoStructure.getCellCount(); ++i) {
                TableCell tableCell = tableRowInfoStructure.getCellAt(i);
                logger.debug((Object)("CELL: " + i + " = " + tableCell.getRowSpan() + ' ' + tableCell.getColSpan() + ' ' + tableCell));
            }
        } else if (renderBox instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)renderBox;
            TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                logger.debug((Object)("COLUMN: EffectiveSize: " + tableColumn.getEffectiveSize() + " Computed Max Width: " + tableColumn.getComputedMaximumWidth() + " Computed ChunkSize: " + tableColumn.getComputedMinChunkSize()));
            }
        } else if (renderBox instanceof TableCellRenderBox) {
            TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)renderBox;
            logger.debug((Object)("CELL: Position: " + tableCellRenderBox.getColumnIndex()));
        } else if (renderBox instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
            logger.debug((Object)"-----------------------------------------------------");
            ModelPrinter.printBox(paragraphRenderBox.getLineboxContainer(), n + 1);
            logger.debug((Object)"-----------------------------------------------------");
        }
        ModelPrinter.printChilds(renderBox, n);
    }

    private static void printChilds(RenderBox renderBox, int n) {
        for (RenderNode renderNode = renderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode instanceof RenderBox) {
                ModelPrinter.printBox((RenderBox)renderNode, n + 1);
                continue;
            }
            if (renderNode instanceof RenderableText) {
                ModelPrinter.printText((RenderableText)renderNode, n + 1);
                continue;
            }
            ModelPrinter.printNode(renderNode, n + 1);
        }
    }

    private static void printNode(RenderNode renderNode, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(renderNode.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append(Integer.toHexString(System.identityHashCode(renderNode)));
        stringBuffer.append(']');
        stringBuffer.append("={x=");
        stringBuffer.append(renderNode.getX());
        stringBuffer.append(", y=");
        stringBuffer.append(renderNode.getY());
        stringBuffer.append(", width=");
        stringBuffer.append(renderNode.getWidth());
        stringBuffer.append(", height=");
        stringBuffer.append(renderNode.getHeight());
        stringBuffer.append('}');
        logger.debug((Object)stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("- nodeLayoutProperties=");
        stringBuffer.append(renderNode.getNodeLayoutProperties());
        logger.debug((Object)stringBuffer.toString());
    }

    private static void printText(RenderableText renderableText, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("Text");
        stringBuffer.append('[');
        stringBuffer.append(Integer.toHexString(System.identityHashCode(renderableText)));
        stringBuffer.append(']');
        stringBuffer.append("={x=");
        stringBuffer.append(renderableText.getX());
        stringBuffer.append(", y=");
        stringBuffer.append(renderableText.getY());
        stringBuffer.append(", width=");
        stringBuffer.append(renderableText.getWidth());
        stringBuffer.append(", height=");
        stringBuffer.append(renderableText.getHeight());
        stringBuffer.append(", text='");
        stringBuffer.append(renderableText.getRawText());
        stringBuffer.append("'}");
        logger.debug((Object)stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("- nodeLayoutProperties=");
        stringBuffer.append(renderableText.getNodeLayoutProperties());
        logger.debug((Object)stringBuffer.toString());
    }
}

