#ifndef _ELM_INTERFACE_FILESELECTOR_EO_H_
#define _ELM_INTERFACE_FILESELECTOR_EO_H_

#ifndef _ELM_INTERFACE_FILESELECTOR_EO_CLASS_TYPE
#define _ELM_INTERFACE_FILESELECTOR_EO_CLASS_TYPE

typedef Eo Elm_Interface_Fileselector;

#endif

#ifndef _ELM_INTERFACE_FILESELECTOR_EO_TYPES
#define _ELM_INTERFACE_FILESELECTOR_EO_TYPES

/** Defines how a file selector widget is to layout its contents (file system
 * entries).
 *
 * @ingroup Elm_Fileselector
 */
typedef enum
{
  ELM_FILESELECTOR_LIST = 0, /** Layout as a list. */
  ELM_FILESELECTOR_GRID, /** Layout as a grid. */
  ELM_FILESELECTOR_LAST /** Sentinel (helper) value, not used. */
} Elm_Fileselector_Mode;

typedef enum
{
  ELM_FILESELECTOR_SORT_BY_FILENAME_ASC = 0,
  ELM_FILESELECTOR_SORT_BY_FILENAME_DESC,
  ELM_FILESELECTOR_SORT_BY_TYPE_ASC,
  ELM_FILESELECTOR_SORT_BY_TYPE_DESC,
  ELM_FILESELECTOR_SORT_BY_SIZE_ASC,
  ELM_FILESELECTOR_SORT_BY_SIZE_DESC,
  ELM_FILESELECTOR_SORT_BY_MODIFIED_ASC,
  ELM_FILESELECTOR_SORT_BY_MODIFIED_DESC,
  ELM_FILESELECTOR_SORT_LAST /** Sentinel (helper) value, not used. */
} Elm_Fileselector_Sort;


#endif
#define ELM_INTERFACE_FILESELECTOR_INTERFACE elm_interface_fileselector_interface_get()

EWAPI const Eo_Class *elm_interface_fileselector_interface_get(void);

/** Get whether folder-only view is set for a given file selector
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_folder_only_get(const Eo *obj);

/**
 * @brief Enable/disable folder-only view for a given file selector widget
 *
 * @param[in] only
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_folder_only_set(Eo *obj, Eina_Bool only);

/**
 * @brief Get the size for the thumbnail of a given file selector widget
 *
 * @param[out] w
 * @param[out] h
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_thumbnail_size_get(const Eo *obj, Evas_Coord *w, Evas_Coord *h);

/**
 * @brief Set the size for the thumbnail of the file selector widget's view.
 *
 * @param[in] w
 * @param[in] h
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_thumbnail_size_set(Eo *obj, Evas_Coord w, Evas_Coord h);

/** Get if hiden files/directories in the file selector are visible or not.
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_hidden_visible_get(const Eo *obj);

/**
 * @brief Enable or disable visibility of hidden files/directories in the file
 * selector widget.
 *
 * @param[in] multi
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_hidden_visible_set(Eo *obj, Eina_Bool multi);

/** Get the sort method of the file selector widget.
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Elm_Fileselector_Sort elm_interface_fileselector_sort_method_get(const Eo *obj);

/**
 * @brief Set the sort method of the file selector widget.
 *
 * @param[in] sort
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_sort_method_set(Eo *obj, Elm_Fileselector_Sort sort);

/** Gets if multi-selection in fileselector is enabled or disabled.
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_multi_select_get(const Eo *obj);

/**
 * @brief Enable or disable multi-selection in the fileselector
 *
 * @param[in] multi
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_multi_select_set(Eo *obj, Eina_Bool multi);

/** Get whether tree view is enabled for the given file selector
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_expandable_get(const Eo *obj);

/**
 * @brief Enable/disable a tree view in the given file selector widget, <b>if
 * it's in
 *
 * @param[in] expand
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_expandable_set(Eo *obj, Eina_Bool expand);

/** Get the directory's model that a given file selector selector widget
 * display contents from
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Efl_Model *elm_interface_fileselector_model_get(const Eo *obj);

/**
 * @brief Set, programmatically, the directory that a given file selector
 * widget will display contents from
 *
 * @param[in] model
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_model_set(Eo *obj, Efl_Model *model);

/** Get the mode in which a given file selector widget is displaying
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Elm_Fileselector_Mode elm_interface_fileselector_mode_get(const Eo *obj);

/**
 * @brief Set the mode in which a given file selector widget will display
 * (layout) file system entries in its view
 *
 * @param[in] mode
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_mode_set(Eo *obj, Elm_Fileselector_Mode mode);

/** Get whether the given file selector is in "saving dialog" mode
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_is_save_get(const Eo *obj);

/**
 * @brief Enable/disable the file name entry box where the user can type in a
 * name for a file, in a given file selector widget
 *
 * @param[in] is_save
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_is_save_set(Eo *obj, Eina_Bool is_save);

/** Get a list of models selected in the fileselector.
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI const Eina_List *elm_interface_fileselector_selected_models_get(const Eo *obj);

EOAPI const char *elm_interface_fileselector_current_name_get(const Eo *obj);

EOAPI void elm_interface_fileselector_current_name_set(Eo *obj, const char *name);

/**
 * @brief Set, programmatically, the currently selected file/directory in the
 * given file selector widget
 *
 * @param[in] model Model to be set
 * @param[in,out] promise Promise returning the recorded selected model or
 * error
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_selected_model_set(Eo *obj, Efl_Model *model, Eina_Promise **promise);

/** Get the currently selected item's model, in the given file the given file
 * selector widget
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Efl_Model *elm_interface_fileselector_selected_model_get(Eo *obj);

/**
 * @brief Append custom filter into filter list
 *
 * @param[in] func function
 * @param[in] data
 * @param[in] filter_name
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_custom_filter_append(Eo *obj, Elm_Fileselector_Filter_Func func, void *data, const char *filter_name);

/** Clear all filters registered
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI void elm_interface_fileselector_filters_clear(Eo *obj);

/**
 * @brief Append mime type based filter into filter list
 *
 * @param[in] mime_types
 * @param[in] filter_name
 *
 * @ingroup Elm_Interface_Fileselector
 */
EOAPI Eina_Bool elm_interface_fileselector_mime_types_filter_append(Eo *obj, const char *mime_types, const char *filter_name);


#endif
