/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;

public class BackgroundImageResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        if (!layoutProcess.getOutputMetaData().isFeatureSupported(OutputProcessorFeature.BACKGROUND_IMAGE)) {
            return;
        }
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (cSSValue == null) {
            return;
        }
        if (!(cSSValue instanceof CSSValueList)) {
            return;
        }
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        int n = cSSValueList.getLength();
        if (n == 0) {
            return;
        }
        BackgroundSpecification backgroundSpecification = layoutContext.getBackgroundSpecification();
        ResourceKey resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
        for (int i = 0; i < n; ++i) {
            CSSValue cSSValue2 = cSSValueList.getItem(i);
            if (!CSSValueResolverUtility.isURI(cSSValue2)) continue;
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue2;
            try {
                ResourceKey resourceKey2 = layoutProcess.getResourceManager().deriveKey(resourceKey, cSSStringValue.getValue());
                continue;
            }
            catch (ResourceKeyCreationException resourceKeyCreationException) {
                resourceKeyCreationException.printStackTrace();
            }
        }
    }
}

