/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import javajs.util.Lst;
import org.jmol.util.Logger;
import org.openscience.jmol.app.nbo.NBOJob;
import org.openscience.jmol.app.nbo.NBOService;

class NBOJobQueueManager {
    private static final int QUEUE_MAX = 10;
    protected Lst<NBOJob> list = new Lst();
    private Object lock = "NBOQueueManagerLock";
    boolean running;
    boolean busy;
    protected NBOJob thisJob;
    protected NBOQueueThread queueThread;

    NBOJobQueueManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJob(NBOService nboService, String name, String statusInfo, Runnable process) {
        Object object = this.lock;
        synchronized (object) {
            if (this.list.size() > 10 && this.thisJob != null) {
                Logger.info("NBOJobQueneManager: max queue reached -- canceling jobs and clearing the queue");
                this.cancelJob();
                this.clearQueue();
            }
            if (name.equals("clear")) {
                this.cancelJob();
            } else {
                System.out.println("adding job " + this.list.size() + ": " + name + "; " + statusInfo);
                this.list.addLast(new NBOJob(nboService, name, statusInfo, process));
                this.dumpList();
            }
        }
        if (this.queueThread == null || !this.running) {
            this.queueThread = new NBOQueueThread();
            this.running = true;
            this.queueThread.start();
        }
    }

    private void dumpList() {
        try {
            for (int i = 0; i < this.list.size(); ++i) {
                System.out.println("QUEUE " + i + " " + ((NBOJob)this.list.get((int)i)).name + " " + ((NBOJob)this.list.get((int)i)).statusInfo);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void cancelJob() {
        this.busy = false;
        if (this.thisJob != null) {
            Logger.info("Canceling job " + this.thisJob);
            this.thisJob.service.isWorking = false;
            this.thisJob.service.jobCanceled = true;
        }
    }

    void clearQueue() {
        this.list.clear();
    }

    class NBOQueueThread
    extends Thread {
        NBOQueueThread() {
        }

        @Override
        public void run() {
            try {
                while (NBOJobQueueManager.this.running && NBOJobQueueManager.this.list.size() > 0) {
                    while (NBOJobQueueManager.this.busy) {
                        Thread.sleep(20L);
                    }
                    if (NBOJobQueueManager.this.running && !NBOQueueThread.interrupted()) {
                        NBOJobQueueManager.this.busy = true;
                        NBOJobQueueManager.this.thisJob = NBOJobQueueManager.this.list.removeItemAt(0);
                        NBOJobQueueManager.this.thisJob.service.jobCanceled = false;
                        NBOJobQueueManager.this.thisJob.run();
                        NBOJobQueueManager.this.busy = false;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            NBOJobQueueManager.this.running = false;
            NBOJobQueueManager.this.list.clear();
            NBOJobQueueManager.this.queueThread = null;
        }
    }
}

