/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.nodes.GraphPrintVisitor;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.object.DebugShapeVisitor;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.debug.GraphvizShapeVisitor;
import com.oracle.truffle.object.debug.IGVShapeVisitor;
import com.oracle.truffle.object.debug.JSONShapeVisitor;
import com.oracle.truffle.object.debug.ShapeProfiler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

class Debug {
    private static Collection<ShapeImpl> allShapes;

    Debug() {
    }

    static void trackShape(ShapeImpl newShape) {
        allShapes.add(newShape);
    }

    static void trackObject(DynamicObject obj) {
        ShapeProfiler.getInstance().track(obj);
    }

    static Iterable<ShapeImpl> getAllShapes() {
        return allShapes;
    }

    static String dumpObject(DynamicObject object, int level, int levelStop) {
        List<Property> properties = object.getShape().getPropertyListInternal(true);
        StringBuilder sb = new StringBuilder(properties.size() * 10);
        sb.append("{\n");
        for (Property property : properties) {
            Debug.indent(sb, level + 1);
            sb.append(property.getKey());
            sb.append('[').append(property.getLocation()).append(']');
            Object value = property.get(object, false);
            if (value instanceof DynamicObject) {
                value = level < levelStop ? Debug.dumpObject((DynamicObject)value, level + 1, levelStop) : value.toString();
            }
            sb.append(": ");
            sb.append(value);
            if (property != properties.get(properties.size() - 1)) {
                sb.append(",");
            }
            sb.append("\n");
        }
        Debug.indent(sb, level);
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    static {
        if (ObjectStorageOptions.DumpShapes) {
            allShapes = new ConcurrentLinkedQueue<ShapeImpl>();
        }
        if (ObjectStorageOptions.DumpShapes) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ObjectStorageOptions.DumpShapesDOT) {
                            this.dumpDOT();
                        }
                        if (ObjectStorageOptions.DumpShapesJSON) {
                            this.dumpJSON();
                        }
                        if (ObjectStorageOptions.DumpShapesIGV) {
                            this.dumpIGV();
                        }
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }

                private void dumpDOT() throws FileNotFoundException, UnsupportedEncodingException {
                    try (PrintWriter out = new PrintWriter(this.getOutputFile("dot"), "UTF-8");){
                        GraphvizShapeVisitor visitor = new GraphvizShapeVisitor();
                        for (ShapeImpl shape : Debug.getAllShapes()) {
                            shape.accept(visitor);
                        }
                        out.println(visitor);
                    }
                }

                private void dumpJSON() throws FileNotFoundException, UnsupportedEncodingException {
                    try (PrintWriter out = new PrintWriter(this.getOutputFile("json"), "UTF-8");){
                        out.println("{\"shapes\": [");
                        boolean first = true;
                        for (ShapeImpl shape : Debug.getAllShapes()) {
                            if (!first) {
                                out.println(",");
                            }
                            first = false;
                            out.print(shape.accept(new JSONShapeVisitor()));
                        }
                        if (!first) {
                            out.println();
                        }
                        out.println("]}");
                    }
                }

                private void dumpIGV() {
                    GraphPrintVisitor printer = new GraphPrintVisitor();
                    printer.beginGroup("shapes");
                    IGVShapeVisitor visitor = new IGVShapeVisitor(printer);
                    for (ShapeImpl shape : Debug.getAllShapes()) {
                        if (!this.isRootShape(shape)) continue;
                        printer.beginGraph(DebugShapeVisitor.getId(shape));
                        shape.accept(visitor);
                        printer.endGraph();
                    }
                    printer.beginGraph("all shapes");
                    for (ShapeImpl shape : Debug.getAllShapes()) {
                        if (!this.isRootShape(shape)) continue;
                        shape.accept(visitor);
                    }
                    printer.endGraph();
                    printer.endGroup();
                    printer.printToNetwork(false);
                }

                private boolean isRootShape(ShapeImpl shape) {
                    return shape.getParent() == null;
                }

                private File getOutputFile(String extension) {
                    return Paths.get(ObjectStorageOptions.DumpShapesPath, "shapes." + extension).toFile();
                }
            }));
        }
    }
}

