/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.ZapSizeNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsDatabasePanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final String NAME = Constant.messages.getString("database.optionspanel.name");
    private static final String COMPACT_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.compact.label");
    private static final String REQUEST_BODY_SIZE_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.request.body.size.label");
    private static final String RESPONSE_BODY_SIZE_DATABASE_LABEL = Constant.messages.getString("database.optionspanel.option.response.body.size.label");
    private static final String RECOVERY_LOG_LABEL = Constant.messages.getString("database.optionspanel.option.recoveryLog.label");
    private static final String RECOVERY_LOG_TOOL_TIP = Constant.messages.getString("database.optionspanel.option.recoveryLog.tooltip");
    private JCheckBox checkBoxCompactDatabase = null;
    private ZapSizeNumberSpinner spinnerRequestBodySize = null;
    private ZapSizeNumberSpinner spinnerResponseBodySize = null;
    private JCheckBox checkBoxNewSessionPrompt = null;
    private JComboBox<String> comboNewSessionOption = null;
    private JCheckBox checkBoxRecoveryLog = null;

    public OptionsDatabasePanel() {
        this.setName(NAME);
        this.setLayout(new FlowLayout(3, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.ipadx = 50;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 0.5;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.weightx = 0.5;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.ipadx = 50;
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setText(REQUEST_BODY_SIZE_DATABASE_LABEL);
        jLabel2.setText(RESPONSE_BODY_SIZE_DATABASE_LABEL);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints5.anchor = 17;
        jPanel.add((Component)this.getCheckBoxCompactDatabase(), gridBagConstraints5);
        jPanel.add((Component)this.getCheckRecoveryLog(), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.getRequestBodySize(), gridBagConstraints2);
        jPanel.add((Component)jLabel2, gridBagConstraints3);
        jPanel.add((Component)this.getResponseBodySize(), gridBagConstraints4);
        jPanel.add((Component)this.getCheckBoxNewSessionPrompt(), LayoutHelper.getGBC(0, 4, 2, 1.0, new Insets(2, 2, 2, 2)));
        jPanel.add((Component)new JLabel(Constant.messages.getString("database.optionspanel.option.newsessionopt.label")), LayoutHelper.getGBC(0, 5, 1, 0.5, new Insets(2, 2, 2, 2)));
        jPanel.add(this.comboNewSessionOption(), LayoutHelper.getGBC(1, 5, 1, 1.0, new Insets(2, 2, 2, 2)));
        this.add(jPanel);
    }

    private JCheckBox getCheckBoxCompactDatabase() {
        if (this.checkBoxCompactDatabase == null) {
            this.checkBoxCompactDatabase = new JCheckBox(COMPACT_DATABASE_LABEL);
        }
        return this.checkBoxCompactDatabase;
    }

    private JCheckBox getCheckRecoveryLog() {
        if (this.checkBoxRecoveryLog == null) {
            this.checkBoxRecoveryLog = new JCheckBox(RECOVERY_LOG_LABEL);
            this.checkBoxRecoveryLog.setToolTipText(RECOVERY_LOG_TOOL_TIP);
        }
        return this.checkBoxRecoveryLog;
    }

    private ZapSizeNumberSpinner getRequestBodySize() {
        if (this.spinnerRequestBodySize == null) {
            this.spinnerRequestBodySize = new ZapSizeNumberSpinner(0x1000000);
        }
        return this.spinnerRequestBodySize;
    }

    private JCheckBox getCheckBoxNewSessionPrompt() {
        if (this.checkBoxNewSessionPrompt == null) {
            this.checkBoxNewSessionPrompt = new JCheckBox(Constant.messages.getString("database.optionspanel.option.newsessionprompt.label"));
        }
        return this.checkBoxNewSessionPrompt;
    }

    private JComboBox<String> comboNewSessionOption() {
        if (this.comboNewSessionOption == null) {
            this.comboNewSessionOption = new JComboBox();
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.unspecified"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.timestamped"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.userspec"));
            this.comboNewSessionOption.addItem(Constant.messages.getString("database.optionspanel.option.newsessionopt.temporary"));
        }
        return this.comboNewSessionOption;
    }

    private ZapSizeNumberSpinner getResponseBodySize() {
        if (this.spinnerResponseBodySize == null) {
            this.spinnerResponseBodySize = new ZapSizeNumberSpinner(0x1000000);
        }
        return this.spinnerResponseBodySize;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        DatabaseParam databaseParam = optionsParam.getDatabaseParam();
        this.checkBoxCompactDatabase.setSelected(databaseParam.isCompactDatabase());
        this.spinnerRequestBodySize.setValue(databaseParam.getRequestBodySize());
        this.spinnerResponseBodySize.setValue(databaseParam.getResponseBodySize());
        this.checkBoxNewSessionPrompt.setSelected(databaseParam.isNewSessionPrompt());
        this.comboNewSessionOption.setSelectedIndex(databaseParam.getNewSessionOption());
        this.checkBoxRecoveryLog.setSelected(databaseParam.isRecoveryLogEnabled());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        DatabaseParam databaseParam = optionsParam.getDatabaseParam();
        databaseParam.setCompactDatabase(this.checkBoxCompactDatabase.isSelected());
        databaseParam.setRequestBodySize(this.spinnerRequestBodySize.getValue());
        databaseParam.setResponseBodySize(this.spinnerResponseBodySize.getValue());
        databaseParam.setNewSessionPrompt(this.checkBoxNewSessionPrompt.isSelected());
        databaseParam.setNewSessionOption(this.comboNewSessionOption.getSelectedIndex());
        databaseParam.setRecoveryLogEnabled(this.checkBoxRecoveryLog.isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.database";
    }
}

