/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.tk.quantum.AbstractPainter;
import com.sun.javafx.tk.quantum.EmbeddedScene;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.paint.Color;
import java.nio.IntBuffer;

public class EmbeddedPainter
extends AbstractPainter
implements Runnable {
    private RTTexture texture;
    private EmbeddedScene escene;

    protected EmbeddedPainter(EmbeddedScene embeddedScene) {
        super(embeddedScene);
        this.setRoot(this.scene.root);
        this.escene = embeddedScene;
    }

    @Override
    protected boolean validateStageGraphics() {
        boolean bl = super.validateStageGraphics();
        if (!bl) {
            return false;
        }
        if (this.escene.host == null) {
            return false;
        }
        Screen screen = Screen.getMainScreen();
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
        this.factory = graphicsPipeline.getResourceFactory(screen);
        if (!this.factory.isDeviceReady()) {
            return false;
        }
        if (this.escene.width <= 0 || this.escene.height <= 0) {
            return false;
        }
        this.setPaintBounds(this.escene.width, this.escene.height);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.validateStageGraphics()) {
            return;
        }
        this.context = this.factory.createRenderingContext(null);
        this.escene.sizeLock.lock();
        try {
            Graphics graphics;
            this.context.begin();
            if (this.texture == null || this.escene.textureBits == null || this.escene.needsReset) {
                this.texture = this.factory.createRTTexture(this.escene.width, this.escene.height);
                if (this.texture == null) {
                    return;
                }
                this.escene.textureBits = IntBuffer.allocate(this.escene.width * this.escene.height);
                if (this.escene.textureBits == null) {
                    return;
                }
                this.escene.needsReset = false;
            }
            if ((graphics = this.texture.createGraphics()) == null) {
                this.escene.needsReset = true;
                this.scene.entireSceneNeedsRepaint();
                return;
            }
            this.paintImpl(graphics);
            this.escene.textureBits.rewind();
            this.texture.readPixels(this.escene.textureBits);
            this.escene.host.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            Disposer.cleanUp();
            this.context.end();
            this.escene.sizeLock.unlock();
        }
    }

    @Override
    protected void doPaint(Graphics graphics) {
        this.scene.clearEntireSceneDirty();
        graphics.setDepthBuffer(this.scene.hasDepthBuffer());
        graphics.clear(Color.TRANSPARENT);
        if (this.scene.fillPaint != null) {
            graphics.getRenderTarget().setOpaque(this.scene.fillPaint.isOpaque());
            graphics.setPaint(this.scene.fillPaint);
            graphics.fillQuad(0.0f, 0.0f, this.escene.width, this.escene.height);
        }
        graphics.setCamera(this.scene.camera);
        this.scene.root.render(graphics);
    }

    @Override
    protected CameraImpl getCamera() {
        if (this.escene != null) {
            return this.escene.camera;
        }
        return null;
    }
}

