/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.lsof;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.glsof.common.lsof.LsofExecutor;
import net.sourceforge.glsof.common.lsof.LsofExecutorObserver;

public class LsofExecutorImpl
implements LsofExecutor {
    private static final Map<Character, Integer> LSOF_IDS;
    private boolean _running;
    private final LsofExecutorObserver _observer;

    public LsofExecutorImpl(LsofExecutorObserver observer) {
        this._observer = observer;
    }

    @Override
    public void fetch(InputStream is) {
        this._running = true;
        this.parse(new BufferedReader(new InputStreamReader(is)));
        this._running = false;
    }

    private void parse(BufferedReader bufferedReader) {
        boolean parsedFD = false;
        String tmpFD = "";
        String[] buffer = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", ""};
        try {
            String line;
            block7: while (this._running && (line = bufferedReader.readLine()) != null) {
                char id = line.charAt(0);
                switch (id) {
                    case 'p': {
                        if (parsedFD) {
                            buffer[6] = tmpFD;
                            this.flush(buffer);
                        }
                        buffer = new String[]{"", line.substring(1), "", "", "", "", "", "", "", "", "", "", ""};
                        parsedFD = false;
                        continue block7;
                    }
                    case 'f': {
                        if (parsedFD) {
                            buffer[6] = tmpFD;
                            this.flush(buffer);
                            buffer = new String[]{buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5], "", "", "", "", "", "", ""};
                        }
                        tmpFD = line.substring(1);
                        parsedFD = true;
                        continue block7;
                    }
                    case 'T': {
                        buffer[12] = buffer[12] + " (" + line.substring(1) + ")";
                        continue block7;
                    }
                }
                Integer index = LSOF_IDS.get(Character.valueOf(id));
                if (index == null) continue;
                if (index == 6) {
                    tmpFD = tmpFD + line.substring(1);
                    continue;
                }
                buffer[index.intValue()] = line.substring(1);
            }
            buffer[6] = tmpFD;
            if (parsedFD) {
                this.flush(buffer);
            }
            if (this._running) {
                this._observer.finished();
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void flush(String[] buffer) {
        if (this._running) {
            try {
                this._observer.flush(buffer);
            }
            catch (RemoteException e) {
                this._running = false;
                System.out.println("Connection Error >>> Please Check The Connection Between Client And Server.");
            }
        }
    }

    @Override
    public String parseErrors(InputStream errorStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream));
        String message = null;
        try {
            String line;
            StringBuffer sb = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith("lsof: ")) continue;
                sb.append(line.substring(6)).append("\n");
            }
            bufferedReader.close();
            message = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return message;
    }

    @Override
    public void stop() {
        this._running = false;
    }

    static {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        map.put(Character.valueOf('c'), 0);
        map.put(Character.valueOf('p'), 1);
        map.put(Character.valueOf('K'), 2);
        map.put(Character.valueOf('g'), 3);
        map.put(Character.valueOf('R'), 4);
        map.put(Character.valueOf('u'), 5);
        map.put(Character.valueOf('L'), 5);
        map.put(Character.valueOf('f'), 6);
        map.put(Character.valueOf('a'), 6);
        map.put(Character.valueOf('l'), 6);
        map.put(Character.valueOf('t'), 7);
        map.put(Character.valueOf('d'), 8);
        map.put(Character.valueOf('D'), 8);
        map.put(Character.valueOf('o'), 9);
        map.put(Character.valueOf('s'), 9);
        map.put(Character.valueOf('k'), 10);
        map.put(Character.valueOf('i'), 11);
        map.put(Character.valueOf('P'), 11);
        map.put(Character.valueOf('S'), 12);
        map.put(Character.valueOf('n'), 12);
        LSOF_IDS = Collections.unmodifiableMap(map);
    }
}

