/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportWriteAction<Request extends ReplicatedWriteRequest<Request>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, Request, Response> {
    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, String executor) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, request, request, executor);
    }

    protected abstract WriteResult<Response> onPrimaryShard(Request var1, IndexShard var2) throws Exception;

    protected abstract Translog.Location onReplicaShard(Request var1, IndexShard var2);

    @Override
    protected final WritePrimaryResult shardOperationOnPrimary(Request request, IndexShard primary) throws Exception {
        WriteResult<Response> result = this.onPrimaryShard(request, primary);
        return new WritePrimaryResult(this, request, result.getResponse(), result.getLocation(), primary);
    }

    protected final WriteReplicaResult shardOperationOnReplica(Request request, IndexShard replica) {
        Translog.Location location = this.onReplicaShard(request, replica);
        return new WriteReplicaResult(replica, (ReplicatedWriteRequest<?>)request, location);
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    protected ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean waitUntilRefresh;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;
        private final WriteRequest<?> request;
        private final Logger logger;

        AsyncAfterWriteAction(IndexShard indexShard, WriteRequest<?> request, @Nullable Translog.Location location, RespondingWriteResult respond, Logger logger) {
            this.indexShard = indexShard;
            this.request = request;
            boolean waitUntilRefresh = false;
            switch (request.getRefreshPolicy()) {
                case IMMEDIATE: {
                    indexShard.refresh("refresh_flag_index");
                    this.refreshed.set(true);
                    break;
                }
                case WAIT_UNTIL: {
                    if (location == null) break;
                    waitUntilRefresh = true;
                    this.pendingOps.incrementAndGet();
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown refresh policy: " + request.getRefreshPolicy());
                }
            }
            this.waitUntilRefresh = waitUntilRefresh;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            this.logger = logger;
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.maybeFlush();
            this.maybeFinish();
            if (this.waitUntilRefresh) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.addRefreshListener(this.location, forcedRefresh -> {
                    if (forcedRefresh.booleanValue()) {
                        this.logger.warn("block_until_refresh request ran out of slots and forced a refresh: [{}]", this.request);
                    }
                    this.refreshed.set((boolean)forcedRefresh);
                    this.maybeFinish();
                });
            }
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    private static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    class WriteReplicaResult
    extends TransportReplicationAction.ReplicaResult
    implements RespondingWriteResult {
        boolean finishedAsyncActions;
        private ActionListener<TransportResponse.Empty> listener;

        public WriteReplicaResult(IndexShard indexShard, ReplicatedWriteRequest<?> request, Translog.Location location) {
            new AsyncAfterWriteAction(indexShard, request, location, this, TransportWriteAction.this.logger).run();
        }

        @Override
        public void respond(ActionListener<TransportResponse.Empty> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public void onFailure(Exception ex) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(ex);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }

    static class WritePrimaryResult
    extends TransportReplicationAction.PrimaryResult
    implements RespondingWriteResult {
        boolean finishedAsyncActions;
        ActionListener<Response> listener;
        final /* synthetic */ TransportWriteAction this$0;

        public WritePrimaryResult(Request request, @Nullable Response finalResponse, Translog.Location location, IndexShard indexShard) {
            this.this$0 = this$0;
            super((TransportReplicationAction)this$0, request, finalResponse);
            this.listener = null;
            new AsyncAfterWriteAction(indexShard, (WriteRequest<?>)request, location, this, ((TransportWriteAction)this$0).logger).run();
        }

        @Override
        public synchronized void respond(ActionListener<Response> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public synchronized void onFailure(Exception exception) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(exception);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            ((WriteResponse)((Object)this.finalResponse)).setForcedRefresh(forcedRefresh);
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }

    public static class WriteResult<Response extends ReplicationResponse> {
        private final Response response;
        private final Translog.Location location;

        public WriteResult(Response response, @Nullable Translog.Location location) {
            this.response = response;
            this.location = location;
        }

        public Response getResponse() {
            return this.response;
        }

        public Translog.Location getLocation() {
            return this.location;
        }
    }
}

