/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateReplicaAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommandRegistry;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.tasks.RawTaskStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.local.LocalTransport;

public final class NetworkModule {
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String HTTP_TYPE_KEY = "http.type";
    public static final String LOCAL_TRANSPORT = "local";
    public static final String HTTP_TYPE_DEFAULT_KEY = "http.type.default";
    public static final String TRANSPORT_TYPE_DEFAULT_KEY = "transport.type.default";
    public static final Setting<String> TRANSPORT_DEFAULT_TYPE_SETTING = Setting.simpleString("transport.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_DEFAULT_TYPE_SETTING = Setting.simpleString("http.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_TYPE_SETTING = Setting.simpleString("http.type", Setting.Property.NodeScope);
    public static final Setting<Boolean> HTTP_ENABLED = Setting.boolSetting("http.enabled", true, Setting.Property.NodeScope);
    public static final Setting<String> TRANSPORT_TYPE_SETTING = Setting.simpleString("transport.type", Setting.Property.NodeScope);
    private final Settings settings;
    private final boolean transportClient;
    private static final AllocationCommandRegistry allocationCommandRegistry = new AllocationCommandRegistry();
    private static final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final Map<String, Supplier<Transport>> transportFactories = new HashMap<String, Supplier<Transport>>();
    private final Map<String, Supplier<HttpServerTransport>> transportHttpFactories = new HashMap<String, Supplier<HttpServerTransport>>();
    private final List<TransportInterceptor> transportIntercetors = new ArrayList<TransportInterceptor>();

    public NetworkModule(Settings settings, boolean transportClient, List<NetworkPlugin> plugins, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService) {
        this.settings = settings;
        this.transportClient = transportClient;
        this.registerTransport(LOCAL_TRANSPORT, () -> new LocalTransport(settings, threadPool, namedWriteableRegistry, circuitBreakerService));
        for (NetworkPlugin plugin : plugins) {
            Map<String, Supplier<LifecycleComponent>> httpTransportFactory;
            if (!transportClient && HTTP_ENABLED.get(settings).booleanValue()) {
                httpTransportFactory = plugin.getHttpTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService);
                for (Map.Entry<String, Supplier<LifecycleComponent>> entry : httpTransportFactory.entrySet()) {
                    this.registerHttpTransport(entry.getKey(), entry.getValue());
                }
            }
            httpTransportFactory = plugin.getTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
            for (Map.Entry<String, Supplier<Transport>> entry : httpTransportFactory.entrySet()) {
                this.registerTransport(entry.getKey(), entry.getValue());
            }
            List<TransportInterceptor> transportInterceptors = plugin.getTransportInterceptors(threadPool.getThreadContext());
            for (TransportInterceptor interceptor : transportInterceptors) {
                this.registerTransportInterceptor(interceptor);
            }
        }
    }

    public boolean isTransportClient() {
        return this.transportClient;
    }

    private void registerTransport(String key, Supplier<Transport> factory) {
        if (this.transportFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private void registerHttpTransport(String key, Supplier<HttpServerTransport> factory) {
        if (this.transportClient) {
            throw new IllegalArgumentException("Cannot register http transport " + key + " for transport client");
        }
        if (this.transportHttpFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private static <T extends AllocationCommand> void registerAllocationCommand(Writeable.Reader<T> reader, AllocationCommand.Parser<T> parser, ParseField commandName) {
        allocationCommandRegistry.register(parser, commandName);
        namedWriteables.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, commandName.getPreferredName(), reader));
    }

    public static AllocationCommandRegistry getAllocationCommandRegistry() {
        return allocationCommandRegistry;
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.unmodifiableList(namedWriteables);
    }

    public Supplier<HttpServerTransport> getHttpServerTransportSupplier() {
        String name = HTTP_TYPE_SETTING.exists(this.settings) ? HTTP_TYPE_SETTING.get(this.settings) : HTTP_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<HttpServerTransport> factory = this.transportHttpFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported http.type [" + name + "]");
        }
        return factory;
    }

    public boolean isHttpEnabled() {
        return !this.transportClient && HTTP_ENABLED.get(this.settings) != false;
    }

    public Supplier<Transport> getTransportSupplier() {
        String name = TRANSPORT_TYPE_SETTING.exists(this.settings) ? TRANSPORT_TYPE_SETTING.get(this.settings) : TRANSPORT_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<Transport> factory = this.transportFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported transport.type [" + name + "]");
        }
        return factory;
    }

    private void registerTransportInterceptor(TransportInterceptor interceptor) {
        this.transportIntercetors.add(Objects.requireNonNull(interceptor, "interceptor must not be null"));
    }

    public TransportInterceptor getTransportInterceptor() {
        return new CompositeTransportInterceptor(this.transportIntercetors);
    }

    static {
        NetworkModule.registerAllocationCommand(CancelAllocationCommand::new, CancelAllocationCommand::fromXContent, CancelAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(MoveAllocationCommand::new, MoveAllocationCommand::fromXContent, MoveAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateReplicaAllocationCommand::new, AllocateReplicaAllocationCommand::fromXContent, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateEmptyPrimaryAllocationCommand::new, AllocateEmptyPrimaryAllocationCommand::fromXContent, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateStalePrimaryAllocationCommand::new, AllocateStalePrimaryAllocationCommand::fromXContent, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD);
        namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "replication", ReplicationTask.Status::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Task.Status.class, "raw", RawTaskStatus::new));
    }

    static final class CompositeTransportInterceptor
    implements TransportInterceptor {
        final List<TransportInterceptor> transportInterceptors;

        private CompositeTransportInterceptor(List<TransportInterceptor> transportInterceptors) {
            this.transportInterceptors = new ArrayList<TransportInterceptor>(transportInterceptors);
        }

        @Override
        public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                actualHandler = interceptor.interceptHandler(action, executor, forceExecution, actualHandler);
            }
            return actualHandler;
        }

        @Override
        public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
            for (TransportInterceptor interceptor : this.transportInterceptors) {
                sender = interceptor.interceptSender(sender);
            }
            return sender;
        }
    }
}

