/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.recycler.DequeRecycler;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class ConcurrentDequeRecycler<T>
extends DequeRecycler<T> {
    final AtomicInteger size = new AtomicInteger();

    public ConcurrentDequeRecycler(Recycler.C<T> c, int maxSize) {
        super(c, ConcurrentCollections.newDeque(), maxSize);
    }

    @Override
    public void close() {
        assert (this.deque.size() == this.size.get());
        super.close();
        this.size.set(0);
    }

    @Override
    public Recycler.V<T> obtain(int sizing) {
        Recycler.V v = super.obtain(sizing);
        if (v.isRecycled()) {
            this.size.decrementAndGet();
        }
        return v;
    }

    @Override
    protected boolean beforeRelease() {
        return this.size.incrementAndGet() <= this.maxSize;
    }

    @Override
    protected void afterRelease(boolean recycled) {
        if (!recycled) {
            this.size.decrementAndGet();
        }
    }
}

