/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class IndicesRequestCache
extends AbstractComponent
implements RemovalListener<Key, BytesReference>,
Closeable {
    public static final Setting<Boolean> INDEX_CACHE_REQUEST_ENABLED_SETTING = Setting.boolSetting("index.requests.cache.enable", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE = Setting.memorySizeSetting("indices.requests.cache.size", "1%", Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_CACHE_QUERY_EXPIRE = Setting.positiveTimeSetting("indices.requests.cache.expire", new TimeValue(0L), Setting.Property.NodeScope);
    private final ConcurrentMap<CleanupKey, Boolean> registeredClosedListeners = ConcurrentCollections.newConcurrentMap();
    private final Set<CleanupKey> keysToClean = ConcurrentCollections.newConcurrentSet();
    private final ByteSizeValue size;
    private final TimeValue expire;
    private final Cache<Key, BytesReference> cache;

    IndicesRequestCache(Settings settings) {
        super(settings);
        this.size = INDICES_CACHE_QUERY_SIZE.get(settings);
        this.expire = INDICES_CACHE_QUERY_EXPIRE.exists(settings) ? INDICES_CACHE_QUERY_EXPIRE.get(settings) : null;
        long sizeInBytes = this.size.getBytes();
        CacheBuilder<Key, BytesReference> cacheBuilder = CacheBuilder.builder().setMaximumWeight(sizeInBytes).weigher((k, v) -> k.ramBytesUsed() + v.ramBytesUsed()).removalListener(this);
        if (this.expire != null) {
            cacheBuilder.setExpireAfterAccess(this.expire);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }

    void clear(CacheEntity entity) {
        this.keysToClean.add(new CleanupKey(entity, -1L));
        this.cleanCache();
    }

    @Override
    public void onRemoval(RemovalNotification<Key, BytesReference> notification) {
        notification.getKey().entity.onRemoval(notification);
    }

    BytesReference getOrCompute(CacheEntity cacheEntity, Supplier<BytesReference> loader, DirectoryReader reader, BytesReference cacheKey) throws Exception {
        Key key = new Key(cacheEntity, reader.getVersion(), cacheKey);
        Loader cacheLoader = new Loader(cacheEntity, loader);
        BytesReference value = this.cache.computeIfAbsent(key, cacheLoader);
        if (cacheLoader.isLoaded()) {
            Boolean previous;
            key.entity.onMiss();
            CleanupKey cleanupKey = new CleanupKey(cacheEntity, reader.getVersion());
            if (!this.registeredClosedListeners.containsKey(cleanupKey) && (previous = this.registeredClosedListeners.putIfAbsent(cleanupKey, Boolean.TRUE)) == null) {
                ElasticsearchDirectoryReader.addReaderCloseListener(reader, cleanupKey);
            }
        } else {
            key.entity.onHit();
        }
        return value;
    }

    synchronized void cleanCache() {
        ObjectHashSet currentKeysToClean = new ObjectHashSet();
        ObjectHashSet currentFullClean = new ObjectHashSet();
        currentKeysToClean.clear();
        currentFullClean.clear();
        Iterator<Object> iterator = this.keysToClean.iterator();
        while (iterator.hasNext()) {
            CleanupKey cleanupKey = iterator.next();
            iterator.remove();
            if (cleanupKey.readerVersion == -1L || !cleanupKey.entity.isOpen()) {
                currentFullClean.add(cleanupKey.entity.getCacheIdentity());
                continue;
            }
            currentKeysToClean.add((Object)cleanupKey);
        }
        if (!currentKeysToClean.isEmpty() || !currentFullClean.isEmpty()) {
            iterator = this.cache.keys().iterator();
            while (iterator.hasNext()) {
                Key key = (Key)iterator.next();
                if (currentFullClean.contains(key.entity.getCacheIdentity())) {
                    iterator.remove();
                    continue;
                }
                if (!currentKeysToClean.contains((Object)new CleanupKey(key.entity, key.readerVersion))) continue;
                iterator.remove();
            }
        }
        this.cache.refresh();
    }

    int count() {
        return this.cache.count();
    }

    int numRegisteredCloseListeners() {
        return this.registeredClosedListeners.size();
    }

    private class CleanupKey
    implements IndexReader.ReaderClosedListener {
        final CacheEntity entity;
        final long readerVersion;

        private CleanupKey(CacheEntity entity, long readerVersion) {
            this.entity = entity;
            this.readerVersion = readerVersion;
        }

        public void onClose(IndexReader reader) {
            Boolean remove = (Boolean)IndicesRequestCache.this.registeredClosedListeners.remove(this);
            if (remove != null) {
                IndicesRequestCache.this.keysToClean.add(this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            CleanupKey that = (CleanupKey)o;
            if (this.readerVersion != that.readerVersion) {
                return false;
            }
            return this.entity.getCacheIdentity().equals(that.entity.getCacheIdentity());
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Long.hashCode(this.readerVersion);
            return result;
        }
    }

    static class Key
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Key.class);
        public final CacheEntity entity;
        public final long readerVersion;
        public final BytesReference value;

        Key(CacheEntity entity, long readerVersion, BytesReference value) {
            this.entity = entity;
            this.readerVersion = readerVersion;
            this.value = value;
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.entity.ramBytesUsed() + (long)this.value.length();
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            if (this.readerVersion != key.readerVersion) {
                return false;
            }
            if (!this.entity.getCacheIdentity().equals(key.entity.getCacheIdentity())) {
                return false;
            }
            return this.value.equals(key.value);
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Long.hashCode(this.readerVersion);
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    static interface CacheEntity
    extends Accountable {
        public void onCached(Key var1, BytesReference var2);

        public boolean isOpen();

        public Object getCacheIdentity();

        public void onHit();

        public void onMiss();

        public void onRemoval(RemovalNotification<Key, BytesReference> var1);
    }

    private static class Loader
    implements CacheLoader<Key, BytesReference> {
        private final CacheEntity entity;
        private final Supplier<BytesReference> loader;
        private boolean loaded;

        Loader(CacheEntity entity, Supplier<BytesReference> loader) {
            this.entity = entity;
            this.loader = loader;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public BytesReference load(Key key) throws Exception {
            BytesReference value = this.loader.get();
            this.entity.onCached(key, value);
            this.loaded = true;
            return value;
        }
    }
}

