/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHeuristic
extends SignificanceHeuristic {
    public static final String NAME = "script_heuristic";
    private final Script script;

    public ScriptHeuristic(Script script) {
        this.script = script;
    }

    public ScriptHeuristic(StreamInput in) throws IOException {
        this(new Script(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    @Override
    public SignificanceHeuristic rewrite(InternalAggregation.ReduceContext context) {
        return new ExecutableScriptHeuristic(this.script, context.scriptService().executable(this.script, ScriptContext.Standard.AGGS));
    }

    @Override
    public SignificanceHeuristic rewrite(SearchContext context) {
        return new ExecutableScriptHeuristic(this.script, context.getQueryShardContext().getExecutableScript(this.script, ScriptContext.Standard.AGGS));
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        throw new UnsupportedOperationException("This scoring heuristic must have 'rewrite' called on it to provide a version ready for use");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject(NAME);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName());
        this.script.toXContent(builder, builderParams);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.script);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptHeuristic other = (ScriptHeuristic)obj;
        return Objects.equals(this.script, other.script);
    }

    public static SignificanceHeuristic parse(QueryParseContext context) throws IOException, QueryShardException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String heuristicName = parser.currentName();
        Script script = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token.equals((Object)XContentParser.Token.FIELD_NAME)) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName)) {
                script = Script.parse(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
                continue;
            }
            throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown object [{}]", heuristicName, currentFieldName);
        }
        if (script == null) {
            throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. no script found in script_heuristic", heuristicName);
        }
        return new ScriptHeuristic(script);
    }

    public final class LongAccessor
    extends Number {
        public long value;

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    static class ExecutableScriptHeuristic
    extends ScriptHeuristic {
        private final LongAccessor subsetSizeHolder = new LongAccessor();
        private final LongAccessor supersetSizeHolder = new LongAccessor();
        private final LongAccessor subsetDfHolder = new LongAccessor();
        private final LongAccessor supersetDfHolder = new LongAccessor();
        private final ExecutableScript executableScript;

        ExecutableScriptHeuristic(Script script, ExecutableScript executableScript) {
            super(script);
            this.executableScript = executableScript;
            executableScript.setNextVar("_subset_freq", this.subsetDfHolder);
            executableScript.setNextVar("_subset_size", this.subsetSizeHolder);
            executableScript.setNextVar("_superset_freq", this.supersetDfHolder);
            executableScript.setNextVar("_superset_size", this.supersetSizeHolder);
        }

        @Override
        public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
            this.subsetSizeHolder.value = subsetSize;
            this.supersetSizeHolder.value = supersetSize;
            this.subsetDfHolder.value = subsetFreq;
            this.supersetDfHolder.value = supersetFreq;
            return ((Number)this.executableScript.run()).doubleValue();
        }
    }
}

