/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.instrumentation.EventContext;

abstract class SteppingStrategy {
    private boolean consumed;

    SteppingStrategy() {
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    abstract boolean step(DebuggerSession var1, EventContext var2, DebuggerSession.SteppingLocation var3);

    abstract void initialize();

    public boolean isDone() {
        return false;
    }

    public boolean isKill() {
        return false;
    }

    public static SteppingStrategy createKill() {
        return new Kill();
    }

    public static SteppingStrategy createAlwaysHalt() {
        return new AlwaysHalt();
    }

    public static SteppingStrategy createContinue() {
        return new Continue();
    }

    public static SteppingStrategy createStepInto(int stepCount) {
        return new StepInto(stepCount);
    }

    public static SteppingStrategy createStepOut() {
        return new StepOut();
    }

    public static SteppingStrategy createStepOver(int stepCount) {
        return new StepOver(stepCount);
    }

    @CompilerDirectives.TruffleBoundary
    private static int computeStackDepth() {
        FrameInstanceCounter counter = new FrameInstanceCounter();
        Truffle.getRuntime().iterateFrames(counter);
        return counter.getCount() + 1;
    }

    private static final class StepOver
    extends SteppingStrategy {
        private int startStackDepth;
        private int unfinishedStepCount;

        StepOver(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        void initialize() {
            this.startStackDepth = SteppingStrategy.computeStackDepth();
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return location == DebuggerSession.SteppingLocation.BEFORE_STATEMENT ? SteppingStrategy.computeStackDepth() <= this.startStackDepth && --this.unfinishedStepCount <= 0 : location == DebuggerSession.SteppingLocation.AFTER_CALL && SteppingStrategy.computeStackDepth() < this.startStackDepth && --this.unfinishedStepCount <= 0;
        }

        public String toString() {
            return String.format("STEP_OVER(startStackDepth=%s, stepCount=%s)", this.startStackDepth, this.unfinishedStepCount);
        }
    }

    private static final class StepOut
    extends SteppingStrategy {
        private int unfinishedStepCount;
        private int startStackDepth;

        StepOut() {
            this(1);
        }

        StepOut(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        void initialize() {
            this.startStackDepth = SteppingStrategy.computeStackDepth();
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return location == DebuggerSession.SteppingLocation.AFTER_CALL && SteppingStrategy.computeStackDepth() < this.startStackDepth && --this.unfinishedStepCount <= 0;
        }

        public String toString() {
            return String.format("STEP_OUT(startStackDepth=%s, stepCount=%s)", this.startStackDepth, this.unfinishedStepCount);
        }
    }

    private static final class StepInto
    extends SteppingStrategy {
        private int startStackDepth;
        private int unfinishedStepCount;

        StepInto(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        void initialize() {
            this.startStackDepth = SteppingStrategy.computeStackDepth();
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return location == DebuggerSession.SteppingLocation.BEFORE_STATEMENT ? --this.unfinishedStepCount <= 0 : location == DebuggerSession.SteppingLocation.AFTER_CALL && SteppingStrategy.computeStackDepth() < this.startStackDepth && --this.unfinishedStepCount <= 0;
        }

        public String toString() {
            return String.format("STEP_INTO(startStackDepth=%s, stepCount=%s)", this.startStackDepth, this.unfinishedStepCount);
        }
    }

    private static final class Continue
    extends SteppingStrategy {
        private Continue() {
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return false;
        }

        @Override
        void initialize() {
        }

        @Override
        public boolean isDone() {
            return true;
        }

        public String toString() {
            return "CONTINUE";
        }
    }

    private static final class AlwaysHalt
    extends SteppingStrategy {
        private AlwaysHalt() {
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return true;
        }

        @Override
        void initialize() {
        }

        public String toString() {
            return "HALT";
        }
    }

    private static final class Kill
    extends SteppingStrategy {
        private Kill() {
        }

        @Override
        boolean step(DebuggerSession steppingSession, EventContext context, DebuggerSession.SteppingLocation location) {
            return true;
        }

        @Override
        void initialize() {
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isKill() {
            return true;
        }

        public String toString() {
            return "KILL";
        }
    }

    private static class FrameInstanceCounter
    implements FrameInstanceVisitor<Void> {
        private int count;

        private FrameInstanceCounter() {
        }

        @Override
        public Void visitFrame(FrameInstance frameInstance) {
            ++this.count;
            return null;
        }

        public int getCount() {
            return this.count;
        }
    }
}

