/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.extra;

import com.kenai.jffi.Platform;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.sun.security.auth.module.UnixSystem;
import jnr.constants.platform.Fcntl;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.time.GetTimeZoneNode;
import org.jruby.truffle.extra.ffi.PointerPrimitiveNodes;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.platform.signal.Signal;

@CoreClass(value="Truffle::POSIX")
public abstract class TrufflePosixNodes {
    @CompilerDirectives.TruffleBoundary
    private static void invalidateENV(String name) {
        if (name.equals("TZ")) {
            GetTimeZoneNode.invalidateTZ();
        }
    }

    @CoreMethod(names={"kill"}, isModuleFunction=true, required=3, lowerFixnum={1, 2}, unsafe={UnsafeGroup.PROCESSES, UnsafeGroup.SIGNALS})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(signalName)"})
        public int kill(int pid, int signalNumber, DynamicObject signalName) {
            int self = this.posix().getpid();
            if (self == pid) {
                Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(StringOperations.decodeUTF8(signalName));
                return this.raise(signal);
            }
            return this.posix().kill(pid, signalNumber);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        private int raise(Signal signal) {
            try {
                this.getContext().getNativePlatform().getSignalManager().raise(signal);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), (Node)this));
            }
            return 1;
        }
    }

    @CoreMethod(names={"close"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class CloseNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int close(int file) {
            return this.posix().close(file);
        }
    }

    @CoreMethod(names={"_getsockopt"}, isModuleFunction=true, required=5, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class GetSockOptNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(optval)", "isRubyPointer(optlen)"})
        public int getSockOptions(int sockfd, int level, int optname, DynamicObject optval, DynamicObject optlen) {
            return this.nativeSockets().getsockopt(sockfd, level, optname, Layouts.POINTER.getPointer(optval), Layouts.POINTER.getPointer(optlen));
        }

        @Specialization(guards={"isRubySymbol(level)", "isRubySymbol(optname)", "isRubyPointer(optval)", "isRubyPointer(optlen)"})
        public int getSockOptionsSymbols(VirtualFrame frame, int sockfd, DynamicObject level, DynamicObject optname, DynamicObject optval, DynamicObject optlen, @Cached(value="new()") SnippetNode snippetNode) {
            int levelInt = (Integer)snippetNode.execute(frame, "Socket.const_get('SOL_' + name)", "name", Layouts.SYMBOL.getString(level));
            int optnameInt = (Integer)snippetNode.execute(frame, "Socket.const_get('SOL_' + name)", "name", Layouts.SYMBOL.getString(optname));
            return this.getSockOptions(sockfd, levelInt, optnameInt, optval, optlen);
        }
    }

    @CoreMethod(names={"_getsockname"}, isModuleFunction=true, required=3, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class GetSockNameNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)", "isRubyPointer(addressLength)"})
        public int getSockName(int socket, DynamicObject address, DynamicObject addressLength) {
            return this.nativeSockets().getsockname(socket, Layouts.POINTER.getPointer(address), Layouts.POINTER.getPointer(addressLength));
        }
    }

    @CoreMethod(names={"_getpeername"}, isModuleFunction=true, required=3, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class GetPeerNameNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)", "isRubyPointer(addressLength)"})
        public int getPeerName(int socket, DynamicObject address, DynamicObject addressLength) {
            return this.nativeSockets().getpeername(socket, Layouts.POINTER.getPointer(address), Layouts.POINTER.getPointer(addressLength));
        }
    }

    @CoreMethod(names={"gethostname"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class GetHostNameNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(name)"})
        public int getHostName(DynamicObject name, int nameLength) {
            return this.nativeSockets().gethostname(Layouts.POINTER.getPointer(name), nameLength);
        }
    }

    @CoreMethod(names={"listen"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class ListenNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int listen(int socket, int backlog) {
            return this.nativeSockets().listen(socket, backlog);
        }
    }

    @CoreMethod(names={"_bind"}, isModuleFunction=true, required=3, lowerFixnum={1, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class BindNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)"})
        public int bind(int socket, DynamicObject address, int addressLength) {
            return this.nativeSockets().bind(socket, Layouts.POINTER.getPointer(address), addressLength);
        }
    }

    @CoreMethod(names={"setsockopt"}, isModuleFunction=true, required=5, lowerFixnum={1, 2, 3, 5}, unsafe={UnsafeGroup.IO})
    public static abstract class SetSockOptNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(optionValue)"})
        public int setsockopt(int socket, int level, int optionName, DynamicObject optionValue, int optionLength) {
            return this.nativeSockets().setsockopt(socket, level, optionName, Layouts.POINTER.getPointer(optionValue), optionLength);
        }
    }

    @CoreMethod(names={"socket"}, isModuleFunction=true, required=3, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class SocketNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getnameinfo(int domain, int type, int protocol) {
            return this.nativeSockets().socket(domain, type, protocol);
        }
    }

    @CoreMethod(names={"shutdown"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class ShutdownNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int shutdown(int socket, int how) {
            return this.nativeSockets().shutdown(socket, how);
        }
    }

    @CoreMethod(names={"_getnameinfo"}, isModuleFunction=true, required=7, lowerFixnum={2, 4, 6, 7}, unsafe={UnsafeGroup.IO})
    public static abstract class GetNameInfoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isRubyPointer(host)", "isRubyPointer(serv)"})
        public int getnameinfo(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen > 0);
            assert (servlen > 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, Layouts.POINTER.getPointer(host), hostlen, Layouts.POINTER.getPointer(serv), servlen, flags);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isNil(host)", "isRubyPointer(serv)"})
        public int getnameinfoNullHost(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen == 0);
            assert (servlen > 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, PointerPrimitiveNodes.NULL_POINTER, hostlen, Layouts.POINTER.getPointer(serv), servlen, flags);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(sa)", "isRubyPointer(host)", "isNil(serv)"})
        public int getnameinfoNullService(DynamicObject sa, int salen, DynamicObject host, int hostlen, DynamicObject serv, int servlen, int flags) {
            assert (hostlen > 0);
            assert (servlen == 0);
            return this.nativeSockets().getnameinfo(Layouts.POINTER.getPointer(sa), salen, Layouts.POINTER.getPointer(host), hostlen, PointerPrimitiveNodes.NULL_POINTER, servlen, flags);
        }
    }

    @CoreMethod(names={"freeaddrinfo"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class FreeAddrInfoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(addrInfo)"})
        public DynamicObject freeaddrinfo(DynamicObject addrInfo) {
            this.nativeSockets().freeaddrinfo(Layouts.POINTER.getPointer(addrInfo));
            return this.nil();
        }
    }

    @CoreMethod(names={"_connect"}, isModuleFunction=true, required=3, lowerFixnum={1, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class ConnectNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(address)"})
        public int connect(int socket, DynamicObject address, int address_len) {
            return this.nativeSockets().connect(socket, Layouts.POINTER.getPointer(address), address_len);
        }
    }

    @CoreMethod(names={"_getaddrinfo"}, isModuleFunction=true, required=4, unsafe={UnsafeGroup.IO})
    public static abstract class GetAddrInfoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(hostName)", "isRubyString(serviceName)"})
        public int getaddrinfoNil(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.getaddrinfoString(this.create7BitString("0.0.0.0", UTF8Encoding.INSTANCE), serviceName, hintsPointer, resultsPointer);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(hostName)", "isRubyString(serviceName)", "isRubyPointer(hintsPointer)", "isRubyPointer(resultsPointer)"})
        public int getaddrinfoString(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.nativeSockets().getaddrinfo(StringOperations.decodeUTF8(hostName), StringOperations.decodeUTF8(serviceName), Layouts.POINTER.getPointer(hintsPointer), Layouts.POINTER.getPointer(resultsPointer));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(hostName)", "isNil(serviceName)", "isRubyPointer(hintsPointer)", "isRubyPointer(resultsPointer)"})
        public int getaddrinfo(DynamicObject hostName, DynamicObject serviceName, DynamicObject hintsPointer, DynamicObject resultsPointer) {
            return this.nativeSockets().getaddrinfo(StringOperations.decodeUTF8(hostName), null, Layouts.POINTER.getPointer(hintsPointer), Layouts.POINTER.getPointer(resultsPointer));
        }
    }

    @CoreMethod(names={"symlink"}, isModuleFunction=true, required=2, unsafe={UnsafeGroup.IO})
    public static abstract class SymlinkNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyString(second)"})
        public int symlink(DynamicObject first, DynamicObject second) {
            return this.posix().symlink(StringOperations.decodeUTF8(first), StringOperations.decodeUTF8(second));
        }
    }

    @CoreMethod(names={"send"}, isModuleFunction=true, required=4, lowerFixnum={1, 3, 4}, unsafe={UnsafeGroup.IO})
    public static abstract class SendNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(buffer)"})
        public int send(int descriptor, DynamicObject buffer, int bytes, int flags) {
            return this.nativeSockets().send(descriptor, Layouts.POINTER.getPointer(buffer), bytes, flags);
        }
    }

    @CoreMethod(names={"getppid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetppidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getppid() {
            return this.posix().getppid();
        }
    }

    @CoreMethod(names={"isatty"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class IsATTYNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int isATTY(int fd) {
            return this.posix().isatty(fd);
        }
    }

    @CoreMethod(names={"getpgrp"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetpgrpNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getpgrp() {
            return this.posix().getpgrp();
        }
    }

    @CoreMethod(names={"getpgid"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetpgidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getpgid(int pid) {
            return this.posix().getpgid(pid);
        }
    }

    @CoreMethod(names={"fcntl"}, isModuleFunction=true, required=3, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class FcntlNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(nil)"})
        public int fcntl(int fd, int fcntl, Object nil) {
            return this.posix().fcntl(fd, Fcntl.valueOf(fcntl));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fcntl(int fd, int fcntl, int arg) {
            return this.posix().fcntlInt(fd, Fcntl.valueOf(fcntl), arg);
        }
    }

    @CoreMethod(names={"errno="}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class ErrnoAssignNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int errno(int errno) {
            this.posix().errno(errno);
            return 0;
        }
    }

    @CoreMethod(names={"errno"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class ErrnoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int errno() {
            return this.posix().errno();
        }
    }

    @CoreMethod(names={"getcwd"}, isModuleFunction=true, unsafe={UnsafeGroup.IO})
    public static abstract class GetcwdNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject getcwd() {
            String cwd = this.posix().getcwd();
            String path = this.getContext().getCurrentDirectory();
            assert (path.equals(cwd));
            return StringOperations.createString(this.getContext(), this.getContext().getRopeTable().getRope(path));
        }
    }

    @CoreMethod(names={"rmdir"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class RmdirNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int rmdir(DynamicObject path) {
            return this.posix().rmdir(StringOperations.decodeUTF8(path));
        }
    }

    @CoreMethod(names={"rename"}, isModuleFunction=true, required=2, unsafe={UnsafeGroup.IO})
    public static abstract class RenameNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyString(other)"})
        public int rename(DynamicObject path, DynamicObject other) {
            return this.posix().rename(StringOperations.decodeUTF8(path), StringOperations.decodeUTF8(other));
        }
    }

    @CoreMethod(names={"minor"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class MinorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int minor(long dev) {
            if (Platform.getPlatform().getOS() == Platform.OS.SOLARIS) {
                return (int)dev;
            }
            return (int)(dev & 0xFFFFFFL);
        }
    }

    @CoreMethod(names={"major"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class MajorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int major(long dev) {
            if (Platform.getPlatform().getOS() == Platform.OS.SOLARIS) {
                return (int)(dev >> 32);
            }
            return (int)(dev >> 24 & 0xFFL);
        }
    }

    @CoreMethod(names={"flock"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class FlockNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int flock(int fd, int constant) {
            return this.posix().flock(fd, constant);
        }
    }

    @CoreMethod(names={"setsid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetSidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setsid() {
            return this.posix().setsid();
        }
    }

    @CoreMethod(names={"setuid"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetUidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setuid(int uid) {
            return this.posix().setuid(uid);
        }
    }

    @CoreMethod(names={"setruid"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetRuidNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int setruid(int uid) {
            throw new RaiseException(this.coreExceptions().notImplementedError("setruid", this));
        }
    }

    @CoreMethod(names={"setrlimit"}, isModuleFunction=true, required=2, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetRLimitNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyPointer(pointer)"})
        public int setrlimit(int resource, DynamicObject pointer, @Cached(value="create()") BranchProfile errorProfile) {
            int result = this.posix().setrlimit(resource, Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"setreuid"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetReuidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setreuid(int uid, int id) {
            throw new RaiseException(this.coreExceptions().notImplementedError("setreuid", this));
        }
    }

    @CoreMethod(names={"seteuid"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetEuidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int seteuid(int uid) {
            return this.posix().seteuid(uid);
        }
    }

    @CoreMethod(names={"setresuid"}, isModuleFunction=true, required=3, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetResuidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setresuid(int uid, int id, int priority) {
            throw new RaiseException(this.coreExceptions().notImplementedError("setresuid", this));
        }
    }

    @CoreMethod(names={"setpriority"}, isModuleFunction=true, required=3, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetPriorityNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setpriority(int kind, int id, int priority) {
            return this.posix().setpriority(kind, id, priority);
        }
    }

    @CoreMethod(names={"setpgid"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetpgidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setpgid(int pid, int pgid) {
            return this.posix().setpgid(pid, pgid);
        }
    }

    @CoreMethod(names={"setgid"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetgidNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setgid(int gid) {
            return this.posix().setgid(gid);
        }
    }

    @CoreMethod(names={"getpriority"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetPriorityNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getpriority(int kind, int id) {
            return this.posix().getpriority(kind, id);
        }
    }

    @CoreMethod(names={"chdir"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class ChdirNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chdir(DynamicObject path) {
            String pathString = StringOperations.decodeUTF8(path);
            int result = this.posix().chdir(pathString);
            if (result == 0) {
                String cwd = this.posix().getcwd();
                this.getContext().setCurrentDirectory(cwd);
            }
            return result;
        }
    }

    @CoreMethod(names={"mkdir"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class MkdirNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int mkdir(DynamicObject path, int mode) {
            return this.posix().mkdir(StringOperations.decodeUTF8(path), mode);
        }
    }

    @CoreMethod(names={"utimes"}, isModuleFunction=true, required=2, unsafe={UnsafeGroup.PROCESSES, UnsafeGroup.MEMORY})
    public static abstract class UtimesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(path)", "isRubyPointer(pointer)"})
        public int utimes(DynamicObject path, DynamicObject pointer) {
            int result = this.posix().utimes(StringOperations.decodeUTF8(path), Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"unsetenv"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class UnsetenvNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public int unsetenv(DynamicObject name) {
            String nameString = StringOperations.decodeUTF8(name);
            TrufflePosixNodes.invalidateENV(nameString);
            return this.posix().unsetenv(nameString);
        }
    }

    @CoreMethod(names={"umask"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class UmaskNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int umask(int mask) {
            return this.posix().umask(mask);
        }
    }

    @CoreMethod(names={"unlink"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class UnlinkNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int unlink(DynamicObject path) {
            return this.posix().unlink(StringOperations.decodeUTF8(path));
        }
    }

    @CoreMethod(names={"link"}, isModuleFunction=true, required=2, unsafe={UnsafeGroup.IO})
    public static abstract class LinkNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyString(other)"})
        public int link(DynamicObject path, DynamicObject other) {
            return this.posix().link(StringOperations.decodeUTF8(path), StringOperations.decodeUTF8(other));
        }
    }

    @CoreMethod(names={"lchmod"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class LchmodNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int lchmod(DynamicObject path, int mode) {
            return this.posix().lchmod(StringOperations.decodeUTF8(path), mode);
        }
    }

    @CoreMethod(names={"setenv"}, isModuleFunction=true, required=3, lowerFixnum={3}, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SetenvNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)", "isRubyString(value)"})
        public int setenv(DynamicObject name, DynamicObject value, int overwrite) {
            String nameString = StringOperations.decodeUTF8(name);
            TrufflePosixNodes.invalidateENV(nameString);
            return this.posix().setenv(nameString, StringOperations.decodeUTF8(value), overwrite);
        }
    }

    @CoreMethod(names={"readlink"}, isModuleFunction=true, required=3, lowerFixnum={3}, unsafe={UnsafeGroup.IO})
    public static abstract class ReadlinkNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(path)", "isRubyPointer(pointer)"})
        public int readlink(DynamicObject path, DynamicObject pointer, int bufsize) {
            int result = this.posix().readlink(StringOperations.decodeUTF8(path), Layouts.POINTER.getPointer(pointer), bufsize);
            if (result == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"mkfifo"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class MkfifoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int mkfifo(DynamicObject path, int mode) {
            return this.posix().mkfifo(StringOperations.decodeUTF8(path), mode);
        }
    }

    @CoreMethod(names={"memset"}, isModuleFunction=true, required=3, lowerFixnum={2}, unsafe={UnsafeGroup.MEMORY})
    public static abstract class MemsetNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyPointer(pointer)"})
        public DynamicObject memset(DynamicObject pointer, int c, long length) {
            Layouts.POINTER.getPointer(pointer).setMemory(0L, length, (byte)c);
            return pointer;
        }
    }

    @CoreMethod(names={"getuid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetUIDNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getUID() {
            return this.posix().getuid();
        }
    }

    @CoreMethod(names={"getrlimit"}, isModuleFunction=true, required=2, lowerFixnum={1}, unsafe={UnsafeGroup.PROCESSES, UnsafeGroup.MEMORY})
    public static abstract class GetRLimitNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyPointer(pointer)"})
        public int getrlimit(int resource, DynamicObject pointer) {
            int result = this.posix().getrlimit(resource, Layouts.POINTER.getPointer(pointer));
            if (result == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @CoreMethod(names={"getgroups"}, isModuleFunction=true, unsafe={UnsafeGroup.MEMORY, UnsafeGroup.PROCESSES})
    public static abstract class GetGroupsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject getgroups() {
            long[] groups = GetGroupsNode.getGroups();
            return this.createArray(groups, groups.length);
        }

        @CompilerDirectives.TruffleBoundary
        private static long[] getGroups() {
            if (TruffleOptions.AOT) {
                throw new UnsupportedOperationException("UnixSystem is not supported with AOT.");
            }
            return new UnixSystem().getGroups();
        }
    }

    @CoreMethod(names={"getgid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetGIDNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getGID() {
            return this.posix().getgid();
        }
    }

    @CoreMethod(names={"geteuid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetEUIDNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getEUID() {
            return this.posix().geteuid();
        }
    }

    @CoreMethod(names={"getenv"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.MEMORY, UnsafeGroup.PROCESSES})
    public static abstract class GetenvNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public DynamicObject getenv(DynamicObject name) {
            String result = this.posix().getenv(StringOperations.decodeUTF8(name));
            if (result == null) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeRope(result, UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"getegid"}, isModuleFunction=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class GetEGIDNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int getEGID() {
            return this.posix().getegid();
        }
    }

    @CoreMethod(names={"fchown"}, isModuleFunction=true, required=3, lowerFixnum={1, 2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class FchownNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fchown(int descriptor, int owner, int group) {
            return this.posix().fchown(descriptor, owner, group);
        }
    }

    @CoreMethod(names={"fsync"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class FsyncNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fsync(int descriptor) {
            return this.posix().fsync(descriptor);
        }
    }

    @CoreMethod(names={"fchmod"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class FchmodNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fchmod(int one, int mode) {
            return this.posix().fchmod(one, mode);
        }
    }

    @CoreMethod(names={"dup2"}, isModuleFunction=true, required=2, lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class Dup2Node
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int dup2(int oldFd, int newFd) {
            return this.posix().dup2(oldFd, newFd);
        }
    }

    @CoreMethod(names={"dup"}, isModuleFunction=true, required=1, lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int dup(int descriptor) {
            return this.posix().dup(descriptor);
        }
    }

    @CoreMethod(names={"chown"}, isModuleFunction=true, required=3, lowerFixnum={2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class ChownNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chown(DynamicObject path, int owner, int group) {
            return this.posix().chown(StringOperations.decodeUTF8(path), owner, group);
        }
    }

    @CoreMethod(names={"chmod"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class ChmodNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int chmod(DynamicObject path, int mode) {
            return this.posix().chmod(StringOperations.decodeUTF8(path), mode);
        }
    }

    @CoreMethod(names={"access"}, isModuleFunction=true, required=2, lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class AccessNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int access(DynamicObject path, int mode) {
            String pathString = StringOperations.decodeUTF8(path);
            return this.posix().access(pathString, mode);
        }
    }
}

