/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.TaintNode;

public class PropagateTaintNode
extends Node {
    @Node.Child
    private IsTaintedNode isTaintedNode = IsTaintedNode.create();
    @Node.Child
    private TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createBinaryProfile();

    public static PropagateTaintNode create() {
        return new PropagateTaintNode();
    }

    public void propagate(DynamicObject source, Object target) {
        if (this.taintProfile.profile(this.isTaintedNode.executeIsTainted(source))) {
            this.taint(target);
        }
    }

    private void taint(Object target) {
        if (this.taintNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.taintNode = this.insert(TaintNode.create());
        }
        this.taintNode.executeTaint(target);
    }
}

