/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.IterParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.scope.StaticScope;

public class ForParseNode
extends IterParseNode {
    private ParseNode iterNode;

    public ForParseNode(SourceIndexLength position, ParseNode varNode, ParseNode bodyNode, ParseNode iterNode, StaticScope scope) {
        super(position, varNode, scope, bodyNode);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    @Override
    public ArgsParseNode getArgsNode() {
        throw new IllegalArgumentException("For nodes are not technically def nodes so they do not have args");
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public ParseNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }
}

