/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import java.nio.IntBuffer;

public class UploadingPainter
extends ViewPainter
implements Runnable {
    private Application app = Application.GetApplication();
    private Pixels pix;
    private Pixels pixRefCopy;
    private View viewRefCopy;
    private IntBuffer textureBits;
    private RTTexture rttexture;
    private final Runnable upload = new Runnable(){

        @Override
        public void run() {
            if (!UploadingPainter.this.viewRefCopy.isClosed()) {
                UploadingPainter.this.viewRefCopy.uploadPixels(UploadingPainter.this.pixRefCopy);
            }
        }
    };

    protected UploadingPainter(ViewScene viewScene, PrismPen prismPen) {
        super(viewScene, prismPen);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int[] nArray;
            Graphics graphics;
            boolean bl;
            if (PrismSettings.threadCheck) {
                assert (!renderLock.isHeldByCurrentThread());
                renderLock.lock();
            }
            this.valid = this.validateStageGraphics();
            if (!this.valid) {
                if (verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                return;
            }
            if (this.view != null) {
                this.pen.begin();
            }
            boolean bl2 = bl = this.rttexture == null || this.viewWidth != this.penWidth || this.viewHeight != this.penHeight;
            if (bl) {
                this.context = this.factory.createRenderingContext(null);
            }
            this.context.begin();
            if (bl) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(this.viewWidth, this.viewHeight);
                if (this.rttexture == null) {
                    this.context.end();
                    return;
                }
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.textureBits = null;
            }
            if ((graphics = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.scene.entireSceneNeedsRepaint();
                return;
            }
            this.paintImpl(graphics);
            if (!this.liveRepaint.get()) {
                collector.releaseScene(this.scene);
            }
            if ((nArray = this.rttexture.getPixels()) != null) {
                this.pix = this.app.createPixels(this.viewWidth, this.viewHeight, IntBuffer.wrap(nArray));
            } else {
                if (this.textureBits == null) {
                    this.textureBits = BufferUtil.newIntBuffer(this.viewWidth * this.viewHeight);
                }
                if (this.textureBits != null) {
                    if (this.rttexture.readPixels(this.textureBits)) {
                        this.pix = this.app.createPixels(this.viewWidth, this.viewHeight, this.textureBits);
                    } else {
                        this.scene.entireSceneNeedsRepaint();
                        this.disposeRTTexture();
                        this.pix = null;
                    }
                }
            }
            if (this.pix != null) {
                this.pixRefCopy = this.pix;
                this.viewRefCopy = this.view;
                Application.postOnEventQueue(this.upload);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.valid && this.context != null) {
                Disposer.cleanUp();
                this.context.end();
            }
            if (this.valid && this.view != null && !this.view.isClosed()) {
                this.pen.end();
            }
            this.pen.getPainting().set(false);
            if (PrismSettings.threadCheck) {
                renderLock.unlock();
            }
        }
    }
}

