/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.DefaultNameValuePair;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;

public class StandardParameterParser
implements ParameterParser {
    private static final String CONFIG_KV_PAIR_SEPARATORS = "kvps";
    private static final String CONFIG_KV_SEPARATORS = "kvs";
    private static final String CONFIG_STRUCTURAL_PARAMS = "struct";
    private Context context;
    private Pattern keyValuePairSeparatorPattern;
    private Pattern keyValueSeparatorPattern;
    private String keyValuePairSeparators;
    private String keyValueSeparators;
    private List<String> structuralParameters = new ArrayList<String>();
    private static Logger log = Logger.getLogger(StandardParameterParser.class);

    public StandardParameterParser(String string, String string2) throws PatternSyntaxException {
        this.setKeyValuePairSeparators(string);
        this.setKeyValueSeparators(string2);
    }

    public StandardParameterParser() {
        this("&", "=");
    }

    private Pattern getKeyValuePairSeparatorPattern() {
        return this.keyValuePairSeparatorPattern;
    }

    private Pattern getKeyValueSeparatorPattern() {
        return this.keyValueSeparatorPattern;
    }

    @Override
    public void init(String string) {
        try {
            JSONObject jSONObject = JSONObject.fromObject((Object)string);
            this.setKeyValuePairSeparators(jSONObject.getString(CONFIG_KV_PAIR_SEPARATORS));
            this.setKeyValueSeparators(jSONObject.getString(CONFIG_KV_SEPARATORS));
            JSONArray jSONArray = jSONObject.getJSONArray(CONFIG_STRUCTURAL_PARAMS);
            for (Object object : jSONArray.toArray()) {
                this.structuralParameters.add(object.toString());
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public String getConfig() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)CONFIG_KV_PAIR_SEPARATORS, (Object)this.getKeyValuePairSeparators());
        jSONObject.put((Object)CONFIG_KV_SEPARATORS, (Object)this.getKeyValueSeparators());
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll(this.structuralParameters);
        jSONObject.put((Object)CONFIG_STRUCTURAL_PARAMS, (Object)jSONArray);
        return jSONObject.toString();
    }

    @Override
    public Map<String, String> getParams(HttpMessage httpMessage, HtmlParameter.Type type) {
        if (httpMessage == null) {
            return new HashMap<String, String>();
        }
        switch (type) {
            case form: {
                return this.parse(httpMessage.getRequestBody().toString());
            }
            case url: {
                return StandardParameterParser.convertParametersList(this.parseParameters(httpMessage.getRequestHeader().getURI().getEscapedQuery()));
            }
        }
        throw new InvalidParameterException("Type not supported: " + (Object)((Object)type));
    }

    private static Map<String, String> convertParametersList(List<NameValuePair> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (NameValuePair nameValuePair : list) {
            String string = nameValuePair.getValue();
            if (string == null) {
                string = "";
            }
            hashMap.put(nameValuePair.getName(), string);
        }
        return hashMap;
    }

    @Override
    public List<NameValuePair> getParameters(HttpMessage httpMessage, HtmlParameter.Type type) {
        if (httpMessage == null) {
            throw new IllegalArgumentException("Parameter msg must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type must not be null.");
        }
        switch (type) {
            case form: {
                return this.parseParameters(httpMessage.getRequestBody().toString());
            }
            case url: {
                String string = httpMessage.getRequestHeader().getURI().getEscapedQuery();
                if (string == null) {
                    return new ArrayList<NameValuePair>(0);
                }
                return this.parseParameters(string);
            }
        }
        throw new IllegalArgumentException("The provided type is not supported: " + (Object)((Object)type));
    }

    private void setKeyValueSeparatorPattern(Pattern pattern) {
        this.keyValueSeparatorPattern = pattern;
    }

    private void setKeyValuePairSeparatorPattern(Pattern pattern) {
        this.keyValuePairSeparatorPattern = pattern;
    }

    public String getKeyValuePairSeparators() {
        return this.keyValuePairSeparators;
    }

    public void setKeyValuePairSeparators(String string) throws PatternSyntaxException {
        this.setKeyValuePairSeparatorPattern(Pattern.compile("[" + string + "]"));
        this.keyValuePairSeparators = string;
    }

    public String getKeyValueSeparators() {
        return this.keyValueSeparators;
    }

    public void setKeyValueSeparators(String string) throws PatternSyntaxException {
        this.setKeyValueSeparatorPattern(Pattern.compile("[" + string + "]"));
        this.keyValueSeparators = string;
    }

    @Override
    public String getDefaultKeyValuePairSeparator() {
        if (this.keyValuePairSeparators != null && this.keyValuePairSeparators.length() > 0) {
            return this.keyValuePairSeparators.substring(0, 1);
        }
        return "&";
    }

    @Override
    public String getDefaultKeyValueSeparator() {
        if (this.keyValueSeparators != null && this.keyValueSeparators.length() > 0) {
            return this.keyValueSeparators.substring(0, 1);
        }
        return "=";
    }

    public List<String> getStructuralParameters() {
        return Collections.unmodifiableList(this.structuralParameters);
    }

    public void setStructuralParameters(List<String> list) {
        this.structuralParameters.clear();
        this.structuralParameters.addAll(list);
    }

    @Override
    public Map<String, String> parse(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            String[] stringArray = this.getKeyValuePairSeparatorPattern().split(string);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String[] stringArray2 = this.getKeyValueSeparatorPattern().split(stringArray[i]);
                    if (stringArray2.length == 1) {
                        hashMap.put(stringArray2[0], "");
                        continue;
                    }
                    if (stringArray2.length <= 1) continue;
                    hashMap.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return hashMap;
    }

    @Override
    public List<NameValuePair> parseParameters(String string) {
        if (string == null) {
            return new ArrayList<NameValuePair>(0);
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        String[] stringArray = this.getKeyValuePairSeparatorPattern().split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getKeyValueSeparatorPattern().split(stringArray[i], 2);
            if (stringArray2.length == 1) {
                arrayList.add(new DefaultNameValuePair(StandardParameterParser.urlDecode(stringArray2[0])));
                continue;
            }
            arrayList.add(new DefaultNameValuePair(StandardParameterParser.urlDecode(stringArray2[0]), StandardParameterParser.urlDecode(stringArray2[1])));
        }
        return arrayList;
    }

    private static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    @Override
    public StandardParameterParser clone() {
        StandardParameterParser standardParameterParser = new StandardParameterParser(this.getKeyValuePairSeparators(), this.getKeyValueSeparators());
        standardParameterParser.setStructuralParameters(this.getStructuralParameters());
        return standardParameterParser;
    }

    @Override
    public List<String> getTreePath(URI uRI) throws URIException {
        return this.getTreePath(uRI, true);
    }

    private List<String> getTreePath(URI uRI, boolean bl) throws URIException {
        Object object;
        Object object2;
        String string = uRI.getPath();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            int n;
            object2 = this.getContext();
            if (object2 != null) {
                object = uRI.toString();
                n = 0;
                for (StructuralNodeModifier structuralNodeModifier : ((Context)object2).getDataDrivenNodes()) {
                    Matcher matcher = structuralNodeModifier.getPattern().matcher((CharSequence)object);
                    if (!matcher.find()) continue;
                    if (matcher.groupCount() == 3) {
                        string = matcher.group(1) + "\u00ab" + structuralNodeModifier.getName() + "\u00bb" + matcher.group(3);
                        if (!string.startsWith("/")) {
                            string = "/" + string;
                        }
                        n = 1;
                        continue;
                    }
                    if (matcher.groupCount() != 2) continue;
                    string = matcher.group(1) + "\u00ab" + structuralNodeModifier.getName() + "\u00bb";
                    if (!string.startsWith("/")) {
                        string = "/" + string;
                    }
                    n = 1;
                }
                if (n != 0) {
                    log.debug((Object)("Changed path from " + uRI.getPath() + " to " + string));
                }
            }
            object = string.split("/");
            for (n = 1; n < ((String[])object).length; ++n) {
                arrayList.add((String)object[n]);
            }
        }
        if (bl) {
            object2 = StandardParameterParser.convertParametersList(this.parseParameters(uRI.getEscapedQuery()));
            object = new ArrayList(object2.keySet());
            Collections.sort(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.structuralParameters.contains(string2)) continue;
                arrayList.add((String)object2.get(string2));
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getTreePath(HttpMessage httpMessage) throws URIException {
        URI uRI = httpMessage.getRequestHeader().getURI();
        List<String> list = this.getTreePath(uRI);
        Map<String, String> map = this.parse(httpMessage.getRequestBody().toString());
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            if (!this.structuralParameters.contains(string)) continue;
            list.add(map.get(string));
        }
        return list;
    }

    @Override
    public String getAncestorPath(URI uRI, int n) throws URIException {
        Object object;
        int n2;
        String string = uRI.getPath();
        if (n == 0 || string == null) {
            return "";
        }
        List<String> list = this.getTreePath(uRI, false);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (n2 = 0; n2 < list.size() && n > 0; ++n2, --n) {
            object = list.get(n2);
            stringBuilder.append('/');
            if (((String)object).startsWith("\u00ab")) {
                stringBuilder.append("(.+?)");
                continue;
            }
            stringBuilder.append((String)object);
        }
        if (n == 0 || this.structuralParameters.isEmpty()) {
            return stringBuilder.toString();
        }
        n2 = 1;
        object = StandardParameterParser.convertParametersList(this.parseParameters(uRI.getEscapedQuery()));
        for (Map.Entry entry : object.entrySet()) {
            if (!this.structuralParameters.contains(entry.getKey())) continue;
            if (n2 != 0) {
                n2 = 0;
                stringBuilder.append('?');
            } else {
                stringBuilder.append(this.keyValuePairSeparators);
            }
            stringBuilder.append((String)entry.getKey()).append(this.keyValueSeparators).append((String)entry.getValue());
            if (--n != 0) continue;
            break;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

