/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainAction;
import org.elasticsearch.action.admin.cluster.allocation.TransportClusterAllocationExplainAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsAction;
import org.elasticsearch.action.admin.cluster.node.hotthreads.TransportNodesHotThreadsAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.liveness.TransportLivenessAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.TransportCancelTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.get.TransportGetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.TransportDeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.repositories.get.TransportGetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.TransportPutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.verify.TransportVerifyRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryAction;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.reroute.TransportClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.TransportClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsAction;
import org.elasticsearch.action.admin.cluster.shards.TransportClusterSearchShardsAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.TransportCreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.TransportDeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TransportRestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusAction;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportSnapshotsStatusAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.TransportClusterStateAction;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsAction;
import org.elasticsearch.action.admin.cluster.stats.TransportClusterStatsAction;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.TransportDeleteStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.TransportGetStoredScriptAction;
import org.elasticsearch.action.admin.cluster.storedscripts.TransportPutStoredScriptAction;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.elasticsearch.action.admin.cluster.tasks.TransportPendingClusterTasksAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.TransportIndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistAction;
import org.elasticsearch.action.admin.indices.alias.exists.TransportAliasesExistAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.TransportGetAliasesAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.analyze.TransportAnalyzeAction;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.cache.clear.TransportClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.close.CloseIndexAction;
import org.elasticsearch.action.admin.indices.close.TransportCloseIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.indices.TransportIndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.types.TransportTypesExistsAction;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsAction;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushAction;
import org.elasticsearch.action.admin.indices.flush.TransportFlushAction;
import org.elasticsearch.action.admin.indices.flush.TransportSyncedFlushAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.forcemerge.TransportForceMergeAction;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.TransportGetIndexAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.TransportGetFieldMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.TransportGetFieldMappingsIndexAction;
import org.elasticsearch.action.admin.indices.mapping.get.TransportGetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.TransportOpenIndexAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.recovery.TransportRecoveryAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.TransportRefreshAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.TransportRolloverAction;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsAction;
import org.elasticsearch.action.admin.indices.segments.TransportIndicesSegmentsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.TransportGetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresAction;
import org.elasticsearch.action.admin.indices.shards.TransportIndicesShardStoresAction;
import org.elasticsearch.action.admin.indices.shrink.ShrinkAction;
import org.elasticsearch.action.admin.indices.shrink.TransportShrinkAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStatsAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.TransportGetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.TransportPutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.upgrade.get.TransportUpgradeStatusAction;
import org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusAction;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.validate.query.TransportValidateQueryAction;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.explain.ExplainAction;
import org.elasticsearch.action.explain.TransportExplainAction;
import org.elasticsearch.action.fieldstats.FieldStatsAction;
import org.elasticsearch.action.fieldstats.TransportFieldStatsAction;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.MultiGetAction;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.get.TransportMultiGetAction;
import org.elasticsearch.action.get.TransportShardMultiGetAction;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.ingest.DeletePipelineAction;
import org.elasticsearch.action.ingest.DeletePipelineTransportAction;
import org.elasticsearch.action.ingest.GetPipelineAction;
import org.elasticsearch.action.ingest.GetPipelineTransportAction;
import org.elasticsearch.action.ingest.PutPipelineAction;
import org.elasticsearch.action.ingest.PutPipelineTransportAction;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineTransportAction;
import org.elasticsearch.action.main.MainAction;
import org.elasticsearch.action.main.TransportMainAction;
import org.elasticsearch.action.search.ClearScrollAction;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.action.search.TransportClearScrollAction;
import org.elasticsearch.action.search.TransportMultiSearchAction;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.termvectors.MultiTermVectorsAction;
import org.elasticsearch.action.termvectors.TermVectorsAction;
import org.elasticsearch.action.termvectors.TransportMultiTermVectorsAction;
import org.elasticsearch.action.termvectors.TransportShardMultiTermsVectorAction;
import org.elasticsearch.action.termvectors.TransportTermVectorsAction;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.NamedRegistry;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.action.RestFieldStatsAction;
import org.elasticsearch.rest.action.RestMainAction;
import org.elasticsearch.rest.action.admin.cluster.RestCancelTasksAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterAllocationExplainAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterGetSettingsAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterHealthAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterRerouteAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterSearchShardsAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterStateAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterStatsAction;
import org.elasticsearch.rest.action.admin.cluster.RestClusterUpdateSettingsAction;
import org.elasticsearch.rest.action.admin.cluster.RestCreateSnapshotAction;
import org.elasticsearch.rest.action.admin.cluster.RestDeleteRepositoryAction;
import org.elasticsearch.rest.action.admin.cluster.RestDeleteSnapshotAction;
import org.elasticsearch.rest.action.admin.cluster.RestDeleteStoredScriptAction;
import org.elasticsearch.rest.action.admin.cluster.RestGetRepositoriesAction;
import org.elasticsearch.rest.action.admin.cluster.RestGetSnapshotsAction;
import org.elasticsearch.rest.action.admin.cluster.RestGetStoredScriptAction;
import org.elasticsearch.rest.action.admin.cluster.RestGetTaskAction;
import org.elasticsearch.rest.action.admin.cluster.RestListTasksAction;
import org.elasticsearch.rest.action.admin.cluster.RestNodesHotThreadsAction;
import org.elasticsearch.rest.action.admin.cluster.RestNodesInfoAction;
import org.elasticsearch.rest.action.admin.cluster.RestNodesStatsAction;
import org.elasticsearch.rest.action.admin.cluster.RestPutRepositoryAction;
import org.elasticsearch.rest.action.admin.cluster.RestPutStoredScriptAction;
import org.elasticsearch.rest.action.admin.cluster.RestRestoreSnapshotAction;
import org.elasticsearch.rest.action.admin.cluster.RestSnapshotsStatusAction;
import org.elasticsearch.rest.action.admin.cluster.RestVerifyRepositoryAction;
import org.elasticsearch.rest.action.admin.indices.RestAliasesExistAction;
import org.elasticsearch.rest.action.admin.indices.RestAnalyzeAction;
import org.elasticsearch.rest.action.admin.indices.RestClearIndicesCacheAction;
import org.elasticsearch.rest.action.admin.indices.RestCloseIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestCreateIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestDeleteIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestDeleteIndexTemplateAction;
import org.elasticsearch.rest.action.admin.indices.RestFlushAction;
import org.elasticsearch.rest.action.admin.indices.RestForceMergeAction;
import org.elasticsearch.rest.action.admin.indices.RestGetAliasesAction;
import org.elasticsearch.rest.action.admin.indices.RestGetFieldMappingAction;
import org.elasticsearch.rest.action.admin.indices.RestGetIndexTemplateAction;
import org.elasticsearch.rest.action.admin.indices.RestGetIndicesAction;
import org.elasticsearch.rest.action.admin.indices.RestGetMappingAction;
import org.elasticsearch.rest.action.admin.indices.RestGetSettingsAction;
import org.elasticsearch.rest.action.admin.indices.RestHeadIndexTemplateAction;
import org.elasticsearch.rest.action.admin.indices.RestIndexDeleteAliasesAction;
import org.elasticsearch.rest.action.admin.indices.RestIndexPutAliasAction;
import org.elasticsearch.rest.action.admin.indices.RestIndicesAliasesAction;
import org.elasticsearch.rest.action.admin.indices.RestIndicesExistsAction;
import org.elasticsearch.rest.action.admin.indices.RestIndicesSegmentsAction;
import org.elasticsearch.rest.action.admin.indices.RestIndicesShardStoresAction;
import org.elasticsearch.rest.action.admin.indices.RestIndicesStatsAction;
import org.elasticsearch.rest.action.admin.indices.RestOpenIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestPutIndexTemplateAction;
import org.elasticsearch.rest.action.admin.indices.RestPutMappingAction;
import org.elasticsearch.rest.action.admin.indices.RestRefreshAction;
import org.elasticsearch.rest.action.admin.indices.RestRolloverIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestShrinkIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestSyncedFlushAction;
import org.elasticsearch.rest.action.admin.indices.RestTypesExistsAction;
import org.elasticsearch.rest.action.admin.indices.RestUpdateSettingsAction;
import org.elasticsearch.rest.action.admin.indices.RestUpgradeAction;
import org.elasticsearch.rest.action.admin.indices.RestValidateQueryAction;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestAliasAction;
import org.elasticsearch.rest.action.cat.RestAllocationAction;
import org.elasticsearch.rest.action.cat.RestCatAction;
import org.elasticsearch.rest.action.cat.RestFielddataAction;
import org.elasticsearch.rest.action.cat.RestHealthAction;
import org.elasticsearch.rest.action.cat.RestIndicesAction;
import org.elasticsearch.rest.action.cat.RestMasterAction;
import org.elasticsearch.rest.action.cat.RestNodeAttrsAction;
import org.elasticsearch.rest.action.cat.RestNodesAction;
import org.elasticsearch.rest.action.cat.RestPendingClusterTasksAction;
import org.elasticsearch.rest.action.cat.RestPluginsAction;
import org.elasticsearch.rest.action.cat.RestRecoveryAction;
import org.elasticsearch.rest.action.cat.RestRepositoriesAction;
import org.elasticsearch.rest.action.cat.RestSegmentsAction;
import org.elasticsearch.rest.action.cat.RestShardsAction;
import org.elasticsearch.rest.action.cat.RestSnapshotAction;
import org.elasticsearch.rest.action.cat.RestTasksAction;
import org.elasticsearch.rest.action.cat.RestTemplatesAction;
import org.elasticsearch.rest.action.cat.RestThreadPoolAction;
import org.elasticsearch.rest.action.document.RestBulkAction;
import org.elasticsearch.rest.action.document.RestCountAction;
import org.elasticsearch.rest.action.document.RestDeleteAction;
import org.elasticsearch.rest.action.document.RestGetAction;
import org.elasticsearch.rest.action.document.RestGetSourceAction;
import org.elasticsearch.rest.action.document.RestHeadAction;
import org.elasticsearch.rest.action.document.RestIndexAction;
import org.elasticsearch.rest.action.document.RestMultiGetAction;
import org.elasticsearch.rest.action.document.RestMultiTermVectorsAction;
import org.elasticsearch.rest.action.document.RestTermVectorsAction;
import org.elasticsearch.rest.action.document.RestUpdateAction;
import org.elasticsearch.rest.action.ingest.RestDeletePipelineAction;
import org.elasticsearch.rest.action.ingest.RestGetPipelineAction;
import org.elasticsearch.rest.action.ingest.RestPutPipelineAction;
import org.elasticsearch.rest.action.ingest.RestSimulatePipelineAction;
import org.elasticsearch.rest.action.search.RestClearScrollAction;
import org.elasticsearch.rest.action.search.RestExplainAction;
import org.elasticsearch.rest.action.search.RestMultiSearchAction;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.search.RestSearchScrollAction;
import org.elasticsearch.rest.action.search.RestSuggestAction;
import org.elasticsearch.threadpool.ThreadPool;

public class ActionModule
extends AbstractModule {
    private static final Logger logger = ESLoggerFactory.getLogger(ActionModule.class);
    private final boolean transportClient;
    private final Settings settings;
    private final List<ActionPlugin> actionPlugins;
    private final Map<String, ActionPlugin.ActionHandler<?, ?>> actions;
    private final List<Class<? extends ActionFilter>> actionFilters;
    private final AutoCreateIndex autoCreateIndex;
    private final DestructiveOperations destructiveOperations;
    private final RestController restController;

    public ActionModule(boolean transportClient, Settings settings, IndexNameExpressionResolver resolver, ClusterSettings clusterSettings, ThreadPool threadPool, List<ActionPlugin> actionPlugins) {
        this.transportClient = transportClient;
        this.settings = settings;
        this.actionPlugins = actionPlugins;
        this.actions = ActionModule.setupActions(actionPlugins);
        this.actionFilters = this.setupActionFilters(actionPlugins);
        this.autoCreateIndex = transportClient ? null : new AutoCreateIndex(settings, clusterSettings, resolver);
        this.destructiveOperations = new DestructiveOperations(settings, clusterSettings);
        Set<String> headers = actionPlugins.stream().flatMap(p -> p.getRestHeaders().stream()).collect(Collectors.toSet());
        UnaryOperator<RestHandler> restWrapper = null;
        for (ActionPlugin plugin : actionPlugins) {
            UnaryOperator<RestHandler> newRestWrapper = plugin.getRestHandlerWrapper(threadPool.getThreadContext());
            if (newRestWrapper == null) continue;
            logger.debug("Using REST wrapper from plugin " + plugin.getClass().getName());
            if (restWrapper != null) {
                throw new IllegalArgumentException("Cannot have more than one plugin implementing a REST wrapper");
            }
            restWrapper = newRestWrapper;
        }
        this.restController = new RestController(settings, headers, restWrapper);
    }

    public Map<String, ActionPlugin.ActionHandler<?, ?>> getActions() {
        return this.actions;
    }

    static Map<String, ActionPlugin.ActionHandler<?, ?>> setupActions(List<ActionPlugin> actionPlugins) {
        class ActionRegistry
        extends NamedRegistry<ActionPlugin.ActionHandler<?, ?>> {
            public ActionRegistry() {
                super("action");
            }

            public void register(ActionPlugin.ActionHandler<?, ?> handler) {
                this.register(handler.getAction().name(), handler);
            }

            public <Request extends ActionRequest, Response extends ActionResponse> void register(GenericAction<Request, Response> action, Class<? extends TransportAction<Request, Response>> transportAction, Class<?> ... supportTransportActions) {
                this.register(new ActionPlugin.ActionHandler<Request, Response>(action, transportAction, supportTransportActions));
            }
        }
        ActionRegistry actions = new ActionRegistry();
        actions.register(MainAction.INSTANCE, TransportMainAction.class, new Class[0]);
        actions.register(NodesInfoAction.INSTANCE, TransportNodesInfoAction.class, new Class[0]);
        actions.register(NodesStatsAction.INSTANCE, TransportNodesStatsAction.class, new Class[0]);
        actions.register(NodesHotThreadsAction.INSTANCE, TransportNodesHotThreadsAction.class, new Class[0]);
        actions.register(ListTasksAction.INSTANCE, TransportListTasksAction.class, new Class[0]);
        actions.register(GetTaskAction.INSTANCE, TransportGetTaskAction.class, new Class[0]);
        actions.register(CancelTasksAction.INSTANCE, TransportCancelTasksAction.class, new Class[0]);
        actions.register(ClusterAllocationExplainAction.INSTANCE, TransportClusterAllocationExplainAction.class, new Class[0]);
        actions.register(ClusterStatsAction.INSTANCE, TransportClusterStatsAction.class, new Class[0]);
        actions.register(ClusterStateAction.INSTANCE, TransportClusterStateAction.class, new Class[0]);
        actions.register(ClusterHealthAction.INSTANCE, TransportClusterHealthAction.class, new Class[0]);
        actions.register(ClusterUpdateSettingsAction.INSTANCE, TransportClusterUpdateSettingsAction.class, new Class[0]);
        actions.register(ClusterRerouteAction.INSTANCE, TransportClusterRerouteAction.class, new Class[0]);
        actions.register(ClusterSearchShardsAction.INSTANCE, TransportClusterSearchShardsAction.class, new Class[0]);
        actions.register(PendingClusterTasksAction.INSTANCE, TransportPendingClusterTasksAction.class, new Class[0]);
        actions.register(PutRepositoryAction.INSTANCE, TransportPutRepositoryAction.class, new Class[0]);
        actions.register(GetRepositoriesAction.INSTANCE, TransportGetRepositoriesAction.class, new Class[0]);
        actions.register(DeleteRepositoryAction.INSTANCE, TransportDeleteRepositoryAction.class, new Class[0]);
        actions.register(VerifyRepositoryAction.INSTANCE, TransportVerifyRepositoryAction.class, new Class[0]);
        actions.register(GetSnapshotsAction.INSTANCE, TransportGetSnapshotsAction.class, new Class[0]);
        actions.register(DeleteSnapshotAction.INSTANCE, TransportDeleteSnapshotAction.class, new Class[0]);
        actions.register(CreateSnapshotAction.INSTANCE, TransportCreateSnapshotAction.class, new Class[0]);
        actions.register(RestoreSnapshotAction.INSTANCE, TransportRestoreSnapshotAction.class, new Class[0]);
        actions.register(SnapshotsStatusAction.INSTANCE, TransportSnapshotsStatusAction.class, new Class[0]);
        actions.register(IndicesStatsAction.INSTANCE, TransportIndicesStatsAction.class, new Class[0]);
        actions.register(IndicesSegmentsAction.INSTANCE, TransportIndicesSegmentsAction.class, new Class[0]);
        actions.register(IndicesShardStoresAction.INSTANCE, TransportIndicesShardStoresAction.class, new Class[0]);
        actions.register(CreateIndexAction.INSTANCE, TransportCreateIndexAction.class, new Class[0]);
        actions.register(ShrinkAction.INSTANCE, TransportShrinkAction.class, new Class[0]);
        actions.register(RolloverAction.INSTANCE, TransportRolloverAction.class, new Class[0]);
        actions.register(DeleteIndexAction.INSTANCE, TransportDeleteIndexAction.class, new Class[0]);
        actions.register(GetIndexAction.INSTANCE, TransportGetIndexAction.class, new Class[0]);
        actions.register(OpenIndexAction.INSTANCE, TransportOpenIndexAction.class, new Class[0]);
        actions.register(CloseIndexAction.INSTANCE, TransportCloseIndexAction.class, new Class[0]);
        actions.register(IndicesExistsAction.INSTANCE, TransportIndicesExistsAction.class, new Class[0]);
        actions.register(TypesExistsAction.INSTANCE, TransportTypesExistsAction.class, new Class[0]);
        actions.register(GetMappingsAction.INSTANCE, TransportGetMappingsAction.class, new Class[0]);
        actions.register(GetFieldMappingsAction.INSTANCE, TransportGetFieldMappingsAction.class, TransportGetFieldMappingsIndexAction.class);
        actions.register(PutMappingAction.INSTANCE, TransportPutMappingAction.class, new Class[0]);
        actions.register(IndicesAliasesAction.INSTANCE, TransportIndicesAliasesAction.class, new Class[0]);
        actions.register(UpdateSettingsAction.INSTANCE, TransportUpdateSettingsAction.class, new Class[0]);
        actions.register(AnalyzeAction.INSTANCE, TransportAnalyzeAction.class, new Class[0]);
        actions.register(PutIndexTemplateAction.INSTANCE, TransportPutIndexTemplateAction.class, new Class[0]);
        actions.register(GetIndexTemplatesAction.INSTANCE, TransportGetIndexTemplatesAction.class, new Class[0]);
        actions.register(DeleteIndexTemplateAction.INSTANCE, TransportDeleteIndexTemplateAction.class, new Class[0]);
        actions.register(ValidateQueryAction.INSTANCE, TransportValidateQueryAction.class, new Class[0]);
        actions.register(RefreshAction.INSTANCE, TransportRefreshAction.class, new Class[0]);
        actions.register(FlushAction.INSTANCE, TransportFlushAction.class, new Class[0]);
        actions.register(SyncedFlushAction.INSTANCE, TransportSyncedFlushAction.class, new Class[0]);
        actions.register(ForceMergeAction.INSTANCE, TransportForceMergeAction.class, new Class[0]);
        actions.register(UpgradeAction.INSTANCE, TransportUpgradeAction.class, new Class[0]);
        actions.register(UpgradeStatusAction.INSTANCE, TransportUpgradeStatusAction.class, new Class[0]);
        actions.register(UpgradeSettingsAction.INSTANCE, TransportUpgradeSettingsAction.class, new Class[0]);
        actions.register(ClearIndicesCacheAction.INSTANCE, TransportClearIndicesCacheAction.class, new Class[0]);
        actions.register(GetAliasesAction.INSTANCE, TransportGetAliasesAction.class, new Class[0]);
        actions.register(AliasesExistAction.INSTANCE, TransportAliasesExistAction.class, new Class[0]);
        actions.register(GetSettingsAction.INSTANCE, TransportGetSettingsAction.class, new Class[0]);
        actions.register(IndexAction.INSTANCE, TransportIndexAction.class, new Class[0]);
        actions.register(GetAction.INSTANCE, TransportGetAction.class, new Class[0]);
        actions.register(TermVectorsAction.INSTANCE, TransportTermVectorsAction.class, new Class[0]);
        actions.register(MultiTermVectorsAction.INSTANCE, TransportMultiTermVectorsAction.class, TransportShardMultiTermsVectorAction.class);
        actions.register(DeleteAction.INSTANCE, TransportDeleteAction.class, new Class[0]);
        actions.register(UpdateAction.INSTANCE, TransportUpdateAction.class, new Class[0]);
        actions.register(MultiGetAction.INSTANCE, TransportMultiGetAction.class, TransportShardMultiGetAction.class);
        actions.register(BulkAction.INSTANCE, TransportBulkAction.class, TransportShardBulkAction.class);
        actions.register(SearchAction.INSTANCE, TransportSearchAction.class, new Class[0]);
        actions.register(SearchScrollAction.INSTANCE, TransportSearchScrollAction.class, new Class[0]);
        actions.register(MultiSearchAction.INSTANCE, TransportMultiSearchAction.class, new Class[0]);
        actions.register(ExplainAction.INSTANCE, TransportExplainAction.class, new Class[0]);
        actions.register(ClearScrollAction.INSTANCE, TransportClearScrollAction.class, new Class[0]);
        actions.register(RecoveryAction.INSTANCE, TransportRecoveryAction.class, new Class[0]);
        actions.register(PutStoredScriptAction.INSTANCE, TransportPutStoredScriptAction.class, new Class[0]);
        actions.register(GetStoredScriptAction.INSTANCE, TransportGetStoredScriptAction.class, new Class[0]);
        actions.register(DeleteStoredScriptAction.INSTANCE, TransportDeleteStoredScriptAction.class, new Class[0]);
        actions.register(FieldStatsAction.INSTANCE, TransportFieldStatsAction.class, new Class[0]);
        actions.register(PutPipelineAction.INSTANCE, PutPipelineTransportAction.class, new Class[0]);
        actions.register(GetPipelineAction.INSTANCE, GetPipelineTransportAction.class, new Class[0]);
        actions.register(DeletePipelineAction.INSTANCE, DeletePipelineTransportAction.class, new Class[0]);
        actions.register(SimulatePipelineAction.INSTANCE, SimulatePipelineTransportAction.class, new Class[0]);
        actionPlugins.stream().flatMap(p -> p.getActions().stream()).forEach(actions::register);
        return Collections.unmodifiableMap(actions.getRegistry());
    }

    private List<Class<? extends ActionFilter>> setupActionFilters(List<ActionPlugin> actionPlugins) {
        return Collections.unmodifiableList(actionPlugins.stream().flatMap(p -> p.getActionFilters().stream()).collect(Collectors.toList()));
    }

    static Set<Class<? extends RestHandler>> setupRestHandlers(List<ActionPlugin> actionPlugins) {
        HashSet<Class<? extends RestHandler>> handlers = new HashSet<Class<? extends RestHandler>>();
        ActionModule.registerRestHandler(handlers, RestMainAction.class);
        ActionModule.registerRestHandler(handlers, RestNodesInfoAction.class);
        ActionModule.registerRestHandler(handlers, RestNodesStatsAction.class);
        ActionModule.registerRestHandler(handlers, RestNodesHotThreadsAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterAllocationExplainAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterStatsAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterStateAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterHealthAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterUpdateSettingsAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterGetSettingsAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterRerouteAction.class);
        ActionModule.registerRestHandler(handlers, RestClusterSearchShardsAction.class);
        ActionModule.registerRestHandler(handlers, org.elasticsearch.rest.action.admin.cluster.RestPendingClusterTasksAction.class);
        ActionModule.registerRestHandler(handlers, RestPutRepositoryAction.class);
        ActionModule.registerRestHandler(handlers, RestGetRepositoriesAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteRepositoryAction.class);
        ActionModule.registerRestHandler(handlers, RestVerifyRepositoryAction.class);
        ActionModule.registerRestHandler(handlers, RestGetSnapshotsAction.class);
        ActionModule.registerRestHandler(handlers, RestCreateSnapshotAction.class);
        ActionModule.registerRestHandler(handlers, RestRestoreSnapshotAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteSnapshotAction.class);
        ActionModule.registerRestHandler(handlers, RestSnapshotsStatusAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesExistsAction.class);
        ActionModule.registerRestHandler(handlers, RestTypesExistsAction.class);
        ActionModule.registerRestHandler(handlers, RestGetIndicesAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesStatsAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesSegmentsAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesShardStoresAction.class);
        ActionModule.registerRestHandler(handlers, RestGetAliasesAction.class);
        ActionModule.registerRestHandler(handlers, RestAliasesExistAction.class);
        ActionModule.registerRestHandler(handlers, RestIndexDeleteAliasesAction.class);
        ActionModule.registerRestHandler(handlers, RestIndexPutAliasAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesAliasesAction.class);
        ActionModule.registerRestHandler(handlers, RestCreateIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestShrinkIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestRolloverIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestCloseIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestOpenIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestUpdateSettingsAction.class);
        ActionModule.registerRestHandler(handlers, RestGetSettingsAction.class);
        ActionModule.registerRestHandler(handlers, RestAnalyzeAction.class);
        ActionModule.registerRestHandler(handlers, RestGetIndexTemplateAction.class);
        ActionModule.registerRestHandler(handlers, RestPutIndexTemplateAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteIndexTemplateAction.class);
        ActionModule.registerRestHandler(handlers, RestHeadIndexTemplateAction.class);
        ActionModule.registerRestHandler(handlers, RestPutMappingAction.class);
        ActionModule.registerRestHandler(handlers, RestGetMappingAction.class);
        ActionModule.registerRestHandler(handlers, RestGetFieldMappingAction.class);
        ActionModule.registerRestHandler(handlers, RestRefreshAction.class);
        ActionModule.registerRestHandler(handlers, RestFlushAction.class);
        ActionModule.registerRestHandler(handlers, RestSyncedFlushAction.class);
        ActionModule.registerRestHandler(handlers, RestForceMergeAction.class);
        ActionModule.registerRestHandler(handlers, RestUpgradeAction.class);
        ActionModule.registerRestHandler(handlers, RestClearIndicesCacheAction.class);
        ActionModule.registerRestHandler(handlers, RestIndexAction.class);
        ActionModule.registerRestHandler(handlers, RestGetAction.class);
        ActionModule.registerRestHandler(handlers, RestGetSourceAction.class);
        ActionModule.registerRestHandler(handlers, RestHeadAction.Document.class);
        ActionModule.registerRestHandler(handlers, RestHeadAction.Source.class);
        ActionModule.registerRestHandler(handlers, RestMultiGetAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteAction.class);
        ActionModule.registerRestHandler(handlers, RestCountAction.class);
        ActionModule.registerRestHandler(handlers, RestSuggestAction.class);
        ActionModule.registerRestHandler(handlers, RestTermVectorsAction.class);
        ActionModule.registerRestHandler(handlers, RestMultiTermVectorsAction.class);
        ActionModule.registerRestHandler(handlers, RestBulkAction.class);
        ActionModule.registerRestHandler(handlers, RestUpdateAction.class);
        ActionModule.registerRestHandler(handlers, RestSearchAction.class);
        ActionModule.registerRestHandler(handlers, RestSearchScrollAction.class);
        ActionModule.registerRestHandler(handlers, RestClearScrollAction.class);
        ActionModule.registerRestHandler(handlers, RestMultiSearchAction.class);
        ActionModule.registerRestHandler(handlers, RestValidateQueryAction.class);
        ActionModule.registerRestHandler(handlers, RestExplainAction.class);
        ActionModule.registerRestHandler(handlers, org.elasticsearch.rest.action.admin.indices.RestRecoveryAction.class);
        ActionModule.registerRestHandler(handlers, RestGetStoredScriptAction.class);
        ActionModule.registerRestHandler(handlers, RestPutStoredScriptAction.class);
        ActionModule.registerRestHandler(handlers, RestDeleteStoredScriptAction.class);
        ActionModule.registerRestHandler(handlers, RestFieldStatsAction.class);
        ActionModule.registerRestHandler(handlers, RestListTasksAction.class);
        ActionModule.registerRestHandler(handlers, RestGetTaskAction.class);
        ActionModule.registerRestHandler(handlers, RestCancelTasksAction.class);
        ActionModule.registerRestHandler(handlers, RestPutPipelineAction.class);
        ActionModule.registerRestHandler(handlers, RestGetPipelineAction.class);
        ActionModule.registerRestHandler(handlers, RestDeletePipelineAction.class);
        ActionModule.registerRestHandler(handlers, RestSimulatePipelineAction.class);
        ActionModule.registerRestHandler(handlers, RestCatAction.class);
        ActionModule.registerRestHandler(handlers, RestAllocationAction.class);
        ActionModule.registerRestHandler(handlers, RestShardsAction.class);
        ActionModule.registerRestHandler(handlers, RestMasterAction.class);
        ActionModule.registerRestHandler(handlers, RestNodesAction.class);
        ActionModule.registerRestHandler(handlers, RestTasksAction.class);
        ActionModule.registerRestHandler(handlers, RestIndicesAction.class);
        ActionModule.registerRestHandler(handlers, RestSegmentsAction.class);
        ActionModule.registerRestHandler(handlers, org.elasticsearch.rest.action.cat.RestCountAction.class);
        ActionModule.registerRestHandler(handlers, RestRecoveryAction.class);
        ActionModule.registerRestHandler(handlers, RestHealthAction.class);
        ActionModule.registerRestHandler(handlers, RestPendingClusterTasksAction.class);
        ActionModule.registerRestHandler(handlers, RestAliasAction.class);
        ActionModule.registerRestHandler(handlers, RestThreadPoolAction.class);
        ActionModule.registerRestHandler(handlers, RestPluginsAction.class);
        ActionModule.registerRestHandler(handlers, RestFielddataAction.class);
        ActionModule.registerRestHandler(handlers, RestNodeAttrsAction.class);
        ActionModule.registerRestHandler(handlers, RestRepositoriesAction.class);
        ActionModule.registerRestHandler(handlers, RestSnapshotAction.class);
        ActionModule.registerRestHandler(handlers, RestTemplatesAction.class);
        for (ActionPlugin plugin : actionPlugins) {
            for (Class<? extends RestHandler> handler : plugin.getRestHandlers()) {
                ActionModule.registerRestHandler(handlers, handler);
            }
        }
        return handlers;
    }

    private static void registerRestHandler(Set<Class<? extends RestHandler>> handlers, Class<? extends RestHandler> handler) {
        if (handlers.contains(handler)) {
            throw new IllegalArgumentException("can't register the same [rest_handler] more than once for [" + handler.getName() + "]");
        }
        handlers.add(handler);
    }

    @Override
    protected void configure() {
        Multibinder<ActionFilter> actionFilterMultibinder = Multibinder.newSetBinder(this.binder(), ActionFilter.class);
        for (Class<? extends ActionFilter> clazz : this.actionFilters) {
            actionFilterMultibinder.addBinding().to(clazz);
        }
        this.bind(ActionFilters.class).asEagerSingleton();
        this.bind(DestructiveOperations.class).toInstance(this.destructiveOperations);
        if (!this.transportClient) {
            this.bind(AutoCreateIndex.class).toInstance(this.autoCreateIndex);
            this.bind(TransportLivenessAction.class).asEagerSingleton();
            MapBinder<GenericAction, TransportAction> transportActionsBinder = MapBinder.newMapBinder(this.binder(), GenericAction.class, TransportAction.class);
            for (ActionPlugin.ActionHandler<?, ?> actionHandler : this.actions.values()) {
                this.bind(actionHandler.getTransportAction()).asEagerSingleton();
                transportActionsBinder.addBinding(actionHandler.getAction()).to(actionHandler.getTransportAction()).asEagerSingleton();
                for (Class<?> supportAction : actionHandler.getSupportTransportActions()) {
                    this.bind(supportAction).asEagerSingleton();
                }
            }
            this.bind(RestController.class).toInstance(this.restController);
            if (NetworkModule.HTTP_ENABLED.get(this.settings).booleanValue()) {
                Multibinder<RestHandler> multibinder = Multibinder.newSetBinder(this.binder(), RestHandler.class);
                Multibinder<AbstractCatAction> multibinder2 = Multibinder.newSetBinder(this.binder(), AbstractCatAction.class);
                for (Class clazz : ActionModule.setupRestHandlers(this.actionPlugins)) {
                    this.bind(clazz).asEagerSingleton();
                    if (AbstractCatAction.class.isAssignableFrom(clazz)) {
                        multibinder2.addBinding().to(clazz.asSubclass(AbstractCatAction.class));
                        continue;
                    }
                    multibinder.addBinding().to(clazz);
                }
            }
        }
    }

    public RestController getRestController() {
        return this.restController;
    }
}

