/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.ListListSetting;
import org.openstreetmap.josm.data.preferences.ListSetting;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.data.preferences.PreferencesReader;
import org.openstreetmap.josm.data.preferences.PreferencesWriter;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.data.preferences.StringSetting;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class Preferences {
    private static final String[] OBSOLETE_PREF_KEYS = new String[]{"hdop.factor"};
    private static final long MAX_AGE_DEFAULT_PREFERENCES = TimeUnit.DAYS.toSeconds(50L);
    private File preferencesDir;
    private File cacheDir;
    private File userdataDir;
    private boolean saveOnPut = true;
    protected final SortedMap<String, Setting<?>> settingsMap = new TreeMap();
    protected final SortedMap<String, Setting<?>> defaultsMap = new TreeMap();
    private final Predicate<Map.Entry<String, Setting<?>>> NO_DEFAULT_SETTINGS_ENTRY = entry -> !((Setting)entry.getValue()).equals(this.defaultsMap.get(entry.getKey()));
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    protected boolean initSuccessful;
    private final ListenerList<PreferenceChangedListener> listeners = ListenerList.create();
    private final HashMap<String, ListenerList<PreferenceChangedListener>> keyListeners = new HashMap();

    public void addPreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        if (preferenceChangedListener != null) {
            this.listeners.addListener(preferenceChangedListener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        this.listeners.removeListener(preferenceChangedListener);
    }

    public void addKeyPreferenceChangeListener(String string, PreferenceChangedListener preferenceChangedListener) {
        this.listenersForKey(string).addListener(preferenceChangedListener);
    }

    public void addWeakKeyPreferenceChangeListener(String string, PreferenceChangedListener preferenceChangedListener) {
        this.listenersForKey(string).addWeakListener(preferenceChangedListener);
    }

    private ListenerList<PreferenceChangedListener> listenersForKey(String string) {
        ListenerList<PreferenceChangedListener> listenerList = this.keyListeners.get(string);
        if (listenerList == null) {
            listenerList = ListenerList.create();
            this.keyListeners.put(string, listenerList);
        }
        return listenerList;
    }

    public void removeKeyPreferenceChangeListener(String string, PreferenceChangedListener preferenceChangedListener) {
        ListenerList<PreferenceChangedListener> listenerList = this.keyListeners.get(string);
        if (listenerList == null) {
            throw new IllegalArgumentException("There are no listeners registered for " + string);
        }
        listenerList.removeListener(preferenceChangedListener);
    }

    protected void firePreferenceChanged(String string, Setting<?> setting, Setting<?> setting2) {
        DefaultPreferenceChangeEvent defaultPreferenceChangeEvent = new DefaultPreferenceChangeEvent(string, setting, setting2);
        this.listeners.fireEvent(preferenceChangedListener -> preferenceChangedListener.preferenceChanged(defaultPreferenceChangeEvent));
        ListenerList<PreferenceChangedListener> listenerList = this.keyListeners.get(string);
        if (listenerList != null) {
            listenerList.fireEvent(preferenceChangedListener -> preferenceChangedListener.preferenceChanged(defaultPreferenceChangeEvent));
        }
    }

    public String getJOSMDirectoryBaseName() {
        String string = System.getProperty("josm.dir.name");
        if (string != null) {
            return string;
        }
        return "JOSM";
    }

    public File getPreferencesDirectory() {
        if (this.preferencesDir != null) {
            return this.preferencesDir;
        }
        String string = System.getProperty("josm.pref");
        this.preferencesDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultPrefDirectory());
        return this.preferencesDir;
    }

    public File getUserDataDirectory() {
        if (this.userdataDir != null) {
            return this.userdataDir;
        }
        String string = System.getProperty("josm.userdata");
        this.userdataDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultUserDataDirectory());
        return this.userdataDir;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirectory(), "preferences.xml");
    }

    public File getDefaultsCacheFile() {
        return new File(this.getCacheDirectory(), "default_preferences.xml");
    }

    public File getPluginsDirectory() {
        return new File(this.getUserDataDirectory(), "plugins");
    }

    public File getCacheDirectory() {
        if (this.cacheDir != null) {
            return this.cacheDir;
        }
        String string = System.getProperty("josm.cache");
        this.cacheDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string, "cache") : ((string = this.get("cache.folder", null)) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultCacheDirectory()));
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            Main.warn(I18n.tr("Failed to create missing cache directory: {0}", this.cacheDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.cacheDir;
    }

    private static void addPossibleResourceDir(Set<String> set, String string) {
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            set.add(string);
        }
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        HashSet<String> hashSet = new HashSet<String>();
        Preferences.addPossibleResourceDir(hashSet, this.getPreferencesDirectory().getPath());
        Preferences.addPossibleResourceDir(hashSet, this.getUserDataDirectory().getPath());
        Preferences.addPossibleResourceDir(hashSet, System.getenv("JOSM_RESOURCES"));
        Preferences.addPossibleResourceDir(hashSet, System.getProperty("josm.resources"));
        if (Main.isPlatformWindows()) {
            String string = System.getenv("APPDATA");
            if (string != null && System.getenv("ALLUSERSPROFILE") != null && string.lastIndexOf(File.separator) != -1) {
                string = string.substring(string.lastIndexOf(File.separator));
                hashSet.add(new File(new File(System.getenv("ALLUSERSPROFILE"), string), "JOSM").getPath());
            }
        } else {
            hashSet.add("/usr/local/share/josm/");
            hashSet.add("/usr/local/lib/josm/");
            hashSet.add("/usr/share/josm/");
            hashSet.add("/usr/lib/josm/");
        }
        return hashSet;
    }

    public synchronized String get(String string) {
        String string2 = this.get(string, null);
        return string2 == null ? "" : string2;
    }

    public synchronized String get(String string, String string2) {
        return (String)this.getSetting(string, new StringSetting(string2), StringSetting.class).getValue();
    }

    public synchronized Map<String, String> getAllPrefix(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(string) || !(entry.getValue() instanceof StringSetting)) continue;
            treeMap.put(entry.getKey(), (String)((StringSetting)entry.getValue()).getValue());
        }
        return treeMap;
    }

    public synchronized List<String> getAllPrefixCollectionKeys(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(string) || !(entry.getValue() instanceof ListSetting)) continue;
            linkedList.add(entry.getKey());
        }
        return linkedList;
    }

    public synchronized Map<String, String> getAllColors() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> entry : this.defaultsMap.entrySet()) {
            StringSetting stringSetting;
            if (!entry.getKey().startsWith("color.") || !(entry.getValue() instanceof StringSetting) || (stringSetting = (StringSetting)entry.getValue()).getValue() == null) continue;
            treeMap.put(entry.getKey().substring(6), (String)stringSetting.getValue());
        }
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith("color.") || !(entry.getValue() instanceof StringSetting)) continue;
            treeMap.put(entry.getKey().substring(6), (String)((StringSetting)entry.getValue()).getValue());
        }
        return treeMap;
    }

    public synchronized boolean getBoolean(String string) {
        String string2 = this.get(string, null);
        return string2 != null && Boolean.parseBoolean(string2);
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        return Boolean.parseBoolean(this.get(string, Boolean.toString(bl)));
    }

    public synchronized boolean getBoolean(String string, String string2, boolean bl) {
        boolean bl2 = this.getBoolean(string, bl);
        String string3 = string + '.' + string2;
        Setting setting = (Setting)this.settingsMap.get(string3);
        if (setting instanceof StringSetting) {
            return Boolean.parseBoolean((String)((StringSetting)setting).getValue());
        }
        return bl2;
    }

    public boolean put(String string, String string2) {
        return this.putSetting(string, string2 == null || string2.isEmpty() ? null : new StringSetting(string2));
    }

    public boolean put(String string, boolean bl) {
        return this.put(string, Boolean.toString(bl));
    }

    public boolean putInteger(String string, Integer n) {
        return this.put(string, Integer.toString(n));
    }

    public boolean putDouble(String string, Double d) {
        return this.put(string, Double.toString(d));
    }

    public boolean putLong(String string, Long l) {
        return this.put(string, Long.toString(l));
    }

    public synchronized void save() throws IOException {
        this.save(this.getPreferenceFile(), this.settingsMap.entrySet().stream().filter(this.NO_DEFAULT_SETTINGS_ENTRY), false);
    }

    public synchronized void saveDefaults() throws IOException {
        this.save(this.getDefaultsCacheFile(), this.defaultsMap.entrySet().stream(), true);
    }

    protected void save(File file, Stream<Map.Entry<String, Setting<?>>> stream, boolean bl) throws IOException {
        if (!bl) {
            this.putInteger("josm.version", Version.getInstance().getVersion());
            this.updateSystemProperties();
        }
        File file2 = new File(file + "_backup");
        if (this.initSuccessful && file.exists() && file.length() > 0L) {
            Utils.copyFile(file, file2);
        }
        try (Object object = new PreferencesWriter(new PrintWriter(new File(file + "_tmp"), StandardCharsets.UTF_8.name()), false, bl);){
            ((PreferencesWriter)object).write(stream);
        }
        object = new File(file + "_tmp");
        Utils.copyFile((File)object, file);
        Utils.deleteFile((File)object, I18n.marktr("Unable to delete temporary file {0}"));
        Preferences.setCorrectPermissions(file);
        Preferences.setCorrectPermissions(file2);
    }

    private static void setCorrectPermissions(File file) {
        if (!file.setReadable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-writable {0}", file.getAbsolutePath()));
        }
        if (!file.setExecutable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-executable {0}", file.getAbsolutePath()));
        }
        if (!file.setReadable(true, true) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(true, true) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file writable {0}", file.getAbsolutePath()));
        }
    }

    protected void load() throws IOException, SAXException, XMLStreamException {
        File file = this.getPreferenceFile();
        PreferencesReader.validateXML(file);
        PreferencesReader preferencesReader = new PreferencesReader(file, false);
        preferencesReader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(preferencesReader.getSettings());
        this.updateSystemProperties();
        this.removeObsolete(preferencesReader.getVersion());
    }

    protected void loadDefaults() throws IOException, XMLStreamException, SAXException {
        File file = this.getDefaultsCacheFile();
        PreferencesReader.validateXML(file);
        PreferencesReader preferencesReader = new PreferencesReader(file, true);
        preferencesReader.parse();
        this.defaultsMap.clear();
        long l = System.currentTimeMillis() / 1000L - MAX_AGE_DEFAULT_PREFERENCES;
        for (Map.Entry<String, Setting<?>> entry : preferencesReader.getSettings().entrySet()) {
            if (entry.getValue().getTime() < l) continue;
            this.defaultsMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void fromXML(Reader reader) throws XMLStreamException, IOException {
        PreferencesReader preferencesReader = new PreferencesReader(reader, false);
        preferencesReader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(preferencesReader.getSettings());
    }

    public void init(boolean bl) {
        block16: {
            File file;
            this.initSuccessful = false;
            File file2 = this.getPreferencesDirectory();
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    Main.warn(I18n.tr("Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", file2.getAbsoluteFile()));
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", file2.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                    return;
                }
            } else if (!file2.mkdirs()) {
                Main.warn(I18n.tr("Failed to initialize preferences. Failed to create missing preference directory: {0}", file2.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", file2.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            File file3 = this.getPreferenceFile();
            try {
                if (!file3.exists()) {
                    Main.info(I18n.tr("Missing preference file ''{0}''. Creating a default preference file.", file3.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                } else if (bl) {
                    file = new File(file2, "preferences.xml.bak");
                    Main.platform.rename(file3, file);
                    Main.warn(I18n.tr("Replacing existing preference file ''{0}'' with default preference file.", file3.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                }
            }
            catch (IOException iOException) {
                Main.error(iOException);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            try {
                this.load();
                this.initSuccessful = true;
            }
            catch (IOException | XMLStreamException | SAXException exception) {
                Main.error(exception);
                File file4 = new File(file2, "preferences.xml.bak");
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file4.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                Main.platform.rename(file3, file4);
                try {
                    this.resetToDefault();
                    this.save();
                }
                catch (IOException iOException) {
                    Main.error(iOException);
                    Main.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
                }
            }
            file = this.getDefaultsCacheFile();
            if (file.exists()) {
                try {
                    this.loadDefaults();
                }
                catch (IOException | XMLStreamException | SAXException exception) {
                    Main.error(exception);
                    Main.warn(I18n.tr("Failed to load defaults cache file: {0}", file));
                    this.defaultsMap.clear();
                    if (file.delete()) break block16;
                    Main.warn(I18n.tr("Failed to delete faulty defaults cache file: {0}", file));
                }
            }
        }
    }

    public void resetToInitialState() {
        this.resetToDefault();
        this.preferencesDir = null;
        this.cacheDir = null;
        this.userdataDir = null;
        this.saveOnPut = true;
        this.initSuccessful = false;
    }

    public final void resetToDefault() {
        this.settingsMap.clear();
    }

    @Deprecated
    public synchronized Color getColor(String string, Color color) {
        return this.getColor(string, null, color);
    }

    public synchronized String getColorName(String string) {
        Matcher matcher = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(string);
        if (matcher.matches()) {
            return I18n.tr("Paint style {0}: {1}", I18n.tr(I18n.escape(matcher.group(1)), new Object[0]), I18n.tr(I18n.escape(matcher.group(2)), new Object[0]));
        }
        matcher = Pattern.compile("layer (.+)").matcher(string);
        if (matcher.matches()) {
            return I18n.tr("Layer: {0}", I18n.tr(I18n.escape(matcher.group(1)), new Object[0]));
        }
        return I18n.tr(I18n.escape(this.colornames.containsKey(string) ? (String)this.colornames.get(string) : string), new Object[0]);
    }

    @Deprecated
    public synchronized Color getColor(String string, String string2, Color color) {
        String string3;
        String string4 = ColorProperty.getColorKey(string);
        this.registerColor(string4, string);
        String string5 = string3 = string2 != null ? this.get("color." + string2) : "";
        if (string3.isEmpty()) {
            string3 = this.get(string4, ColorHelper.color2html(color, true));
        }
        if (string3 != null && !string3.isEmpty()) {
            return ColorHelper.html2color(string3);
        }
        return color;
    }

    public void registerColor(String string, String string2) {
        if (!string.equals(string2)) {
            this.colornames.put(string, string2);
        }
    }

    public synchronized Color getDefaultColor(String string) {
        StringSetting stringSetting = Utils.cast(this.defaultsMap.get("color." + string), StringSetting.class);
        String string2 = stringSetting == null ? null : (String)stringSetting.getValue();
        return string2 == null || string2.isEmpty() ? null : ColorHelper.html2color(string2);
    }

    public synchronized boolean putColor(String string, Color color) {
        return this.put("color." + string, color != null ? ColorHelper.color2html(color, true) : null);
    }

    public synchronized int getInteger(String string, int n) {
        String string2 = this.get(string, Integer.toString(n));
        if (string2.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            return n;
        }
    }

    public synchronized int getInteger(String string, String string2, int n) {
        String string3 = this.get(string + '.' + string2);
        if (string3.isEmpty()) {
            string3 = this.get(string, Integer.toString(n));
        }
        if (string3.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            return n;
        }
    }

    public synchronized long getLong(String string, long l) {
        String string2 = this.get(string, Long.toString(l));
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            return l;
        }
    }

    public synchronized double getDouble(String string, double d) {
        String string2 = this.get(string, Double.toString(d));
        if (null == string2) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            return d;
        }
    }

    public Collection<String> getCollection(String string, Collection<String> collection) {
        return (Collection)this.getSetting(string, ListSetting.create(collection), ListSetting.class).getValue();
    }

    public Collection<String> getCollection(String string) {
        Collection<String> collection = this.getCollection(string, null);
        return collection == null ? Collections.emptyList() : collection;
    }

    public synchronized void removeFromCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getCollection(string, Collections.emptyList()));
        arrayList.remove(string2);
        this.putCollection(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putSetting(String string, Setting<?> setting) {
        Setting setting2;
        CheckParameterUtil.ensureParameterNotNull(string);
        if (setting != null && setting.getValue() == null) {
            throw new IllegalArgumentException("setting argument must not have null value");
        }
        Setting<?> setting3 = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (setting == null) {
                setting2 = (Setting)this.settingsMap.remove(string);
                if (setting2 == null) {
                    return false;
                }
            } else {
                setting2 = (Setting)this.settingsMap.get(string);
                if (setting.equals(setting2)) {
                    return false;
                }
                if (setting2 == null && setting.equals(this.defaultsMap.get(string))) {
                    return false;
                }
                setting3 = setting.copy();
                this.settingsMap.put(string, setting3);
            }
            if (this.saveOnPut) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    Main.warn((Throwable)iOException, I18n.tr("Failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
            }
        }
        this.firePreferenceChanged(string, setting2, setting3);
        return true;
    }

    public synchronized Setting<?> getSetting(String string, Setting<?> setting) {
        return this.getSetting(string, setting, Setting.class);
    }

    public synchronized <T extends Setting<?>> T getSetting(String string, T t, Class<T> clazz) {
        Setting setting;
        CheckParameterUtil.ensureParameterNotNull(string);
        CheckParameterUtil.ensureParameterNotNull(t);
        Setting setting2 = (Setting)this.defaultsMap.get(string);
        if (setting2 != null && setting2.isNew() && setting2.getValue() != null && t.getValue() != null && !t.equals(setting2)) {
            Main.info("Defaults for " + string + " differ: " + t + " != " + this.defaultsMap.get(string));
        }
        if (t.getValue() != null || setting2 == null) {
            setting = t.copy();
            setting.setTime(System.currentTimeMillis() / 1000L);
            setting.setNew(true);
            this.defaultsMap.put(string, setting);
        }
        if (clazz.isInstance(setting = (Setting)this.settingsMap.get(string))) {
            return (T)setting;
        }
        return t;
    }

    public boolean putCollection(String string, Collection<String> collection) {
        return this.putSetting(string, collection == null ? null : ListSetting.create(collection));
    }

    public boolean putCollectionBounded(String string, int n, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(n, collection.size()));
        for (String string2 : collection) {
            if (arrayList.size() >= n) break;
            arrayList.add(string2);
        }
        return this.putCollection(string, arrayList);
    }

    public synchronized Collection<Collection<String>> getArray(String string, Collection<Collection<String>> collection) {
        ListListSetting listListSetting = this.getSetting(string, ListListSetting.create(collection), ListListSetting.class);
        return (Collection)listListSetting.getValue();
    }

    public Collection<Collection<String>> getArray(String string) {
        Collection<Collection<String>> collection = this.getArray(string, null);
        return collection == null ? Collections.emptyList() : collection;
    }

    public boolean putArray(String string, Collection<Collection<String>> collection) {
        return this.putSetting(string, collection == null ? null : ListListSetting.create(collection));
    }

    public Collection<Map<String, String>> getListOfStructs(String string, Collection<Map<String, String>> collection) {
        return (Collection)this.getSetting(string, new MapListSetting((List<Map<String, String>>)(collection == null ? null : new ArrayList<Map<String, String>>(collection))), MapListSetting.class).getValue();
    }

    public boolean putListOfStructs(String string, Collection<Map<String, String>> collection) {
        return this.putSetting(string, collection == null ? null : new MapListSetting((List<Map<String, String>>)new ArrayList<Map<String, String>>(collection)));
    }

    public <T> List<T> getListOfStructs(String string, Class<T> clazz) {
        List<T> list = this.getListOfStructs(string, null, clazz);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> List<T> getListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        Collection<Map<String, String>> collection2 = this.getListOfStructs(string, collection == null ? null : Preferences.serializeListOfStructs(collection, clazz));
        if (collection2 == null) {
            return collection == null ? null : new ArrayList<T>(collection);
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Map<String, String> map : collection2) {
            T t = Preferences.deserializeStruct(map, clazz);
            arrayList.add(t);
        }
        return arrayList;
    }

    public <T> boolean putListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        return this.putListOfStructs(string, Preferences.serializeListOfStructs(collection, clazz));
    }

    private static <T> Collection<Map<String, String>> serializeListOfStructs(Collection<T> collection, Class<T> clazz) {
        if (collection == null) {
            return null;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (T t : collection) {
            if (t == null) continue;
            arrayList.add(Preferences.serializeStruct(t, clazz));
        }
        return arrayList;
    }

    private static String mapToJson(Map map) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = Json.createWriter(stringWriter);){
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Object v = entry2.getValue();
                jsonObjectBuilder.add(entry2.getKey().toString(), v.toString());
            }
            jsonWriter.writeObject(jsonObjectBuilder.build());
        }
        return stringWriter.toString();
    }

    private static Map mapFromJson(String string) {
        HashMap hashMap = null;
        try (JsonReader jsonReader = Json.createReader(new StringReader(string));){
            JsonObject jsonObject = jsonReader.readObject();
            hashMap = new HashMap(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue jsonValue = (JsonValue)entry.getValue();
                if (jsonValue instanceof JsonString) {
                    hashMap.put(entry.getKey(), ((JsonString)jsonValue).getString());
                    continue;
                }
                hashMap.put(entry.getKey(), ((JsonValue)entry.getValue()).toString());
            }
        }
        return hashMap;
    }

    private static String multiMapToJson(MultiMap multiMap) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = Json.createWriter(stringWriter);){
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Iterator iterator = multiMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Set set = entry2.getValue();
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                for (Object b : set) {
                    jsonArrayBuilder.add(b.toString());
                }
                jsonObjectBuilder.add(entry2.getKey().toString(), jsonArrayBuilder.build());
            }
            jsonWriter.writeObject(jsonObjectBuilder.build());
        }
        return stringWriter.toString();
    }

    private static MultiMap multiMapFromJson(String string) {
        MultiMap multiMap = null;
        try (JsonReader jsonReader = Json.createReader(new StringReader(string));){
            JsonObject jsonObject = jsonReader.readObject();
            multiMap = new MultiMap(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue jsonValue = (JsonValue)entry.getValue();
                if (jsonValue instanceof JsonArray) {
                    for (JsonString jsonString : ((JsonArray)jsonValue).getValuesAs(JsonString.class)) {
                        multiMap.put(entry.getKey(), jsonString.getString());
                    }
                    continue;
                }
                if (jsonValue instanceof JsonString) {
                    multiMap.put(entry.getKey(), ((JsonString)jsonValue).getString());
                    continue;
                }
                multiMap.put(entry.getKey(), ((JsonValue)entry.getValue()).toString());
            }
        }
        return multiMap;
    }

    public static <T> Map<String, String> serializeStruct(T t, Class<T> clazz) {
        T t2;
        try {
            t2 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(pref.class) == null) continue;
            Utils.setObjectsAccessible(field);
            try {
                Object object = field.get(t);
                Object object2 = field.get(t2);
                if (object == null || field.getAnnotation(writeExplicitly.class) == null && Objects.equals(object, object2)) continue;
                String string = field.getName().replace('_', '-');
                if (object instanceof Map) {
                    linkedHashMap.put(string, Preferences.mapToJson((Map)object));
                    continue;
                }
                if (object instanceof MultiMap) {
                    linkedHashMap.put(string, Preferences.multiMapToJson((MultiMap)object));
                    continue;
                }
                linkedHashMap.put(string, object.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JosmRuntimeException(illegalAccessException);
            }
        }
        return linkedHashMap;
    }

    public static <T> T deserializeStruct(Map<String, String> map, Class<T> clazz) {
        T t = null;
        try {
            t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Object object;
            Field field;
            block22: {
                try {
                    field = clazz.getDeclaredField(entry.getKey().replace('-', '_'));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Main.trace(noSuchFieldException);
                    continue;
                }
                if (field.getAnnotation(pref.class) == null) continue;
                Utils.setObjectsAccessible(field);
                if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    object = Boolean.valueOf(entry.getValue());
                } else {
                    if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                        try {
                            object = Integer.valueOf(entry.getValue());
                            break block22;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                        try {
                            object = Double.valueOf(entry.getValue());
                            break block22;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == String.class) {
                        object = entry.getValue();
                    } else if (field.getType().isAssignableFrom(Map.class)) {
                        object = Preferences.mapFromJson(entry.getValue());
                    } else if (field.getType().isAssignableFrom(MultiMap.class)) {
                        object = Preferences.multiMapFromJson(entry.getValue());
                    } else {
                        throw new JosmRuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                field.set(t, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JosmRuntimeException(illegalAccessException);
            }
        }
        return t;
    }

    public Map<String, Setting<?>> getAllSettings() {
        return new TreeMap(this.settingsMap);
    }

    public Map<String, Setting<?>> getAllDefaults() {
        return new TreeMap(this.defaultsMap);
    }

    public void updateSystemProperties() {
        if ("true".equals(this.get("prefer.ipv6", "auto")) && !"true".equals(Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true"))) {
            Main.info(I18n.tr("Try enabling IPv6 network, prefering IPv6 over IPv4 (only works on early startup).", new Object[0]));
        }
        Utils.updateSystemProperty("http.agent", Version.getInstance().getAgentString());
        Utils.updateSystemProperty("user.language", this.get("language"));
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                Field field = Toolkit.class.getDeclaredField("resources");
                Utils.setObjectsAccessible(field);
                field.set(null, ResourceBundle.getBundle("sun.awt.resources.awt"));
            }
            catch (ReflectiveOperationException | RuntimeException exception) {
                Main.warn(exception);
            }
        }
        if (this.getBoolean("jdk.tls.disableSNIExtension", false)) {
            Utils.updateSystemProperty("jsse.enableSNIExtension", "false");
        }
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Collections.singleton(Main.getJOSMWebsite() + "/pluginicons%<?plugins=>"));
    }

    public Collection<String> getOnlinePluginSites() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getPluginSites());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess((String)iterator.next(), Main.getJOSMWebsite());
            }
            catch (OfflineAccessException offlineAccessException) {
                Main.warn((Throwable)offlineAccessException, false);
                iterator.remove();
            }
        }
        return arrayList;
    }

    public void setPluginSites(Collection<String> collection) {
        this.putCollection("pluginmanager.sites", collection);
    }

    public String toXML(boolean bl) {
        return this.toXML(this.settingsMap.entrySet(), bl, false);
    }

    /*
     * Exception decompiling
     */
    public String toXML(Collection<Map.Entry<String, Setting<?>>> var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeObsolete(int n) {
        this.removeUrlFromEntries(n, 10063, "validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", "resource://data/validator/power.mapcss");
        if (n < 11058) {
            this.migrateOldColorKeys();
        }
        if (n < 11424) {
            this.addNewerDefaultEntry("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", "resource://data/validator/territories.mapcss");
        }
        for (String string : OBSOLETE_PREF_KEYS) {
            if (!this.settingsMap.containsKey(string)) continue;
            this.settingsMap.remove(string);
            Main.info(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }

    private void migrateOldColorKeys() {
        this.settingsMap.keySet().stream().filter(string -> string.startsWith("color.")).flatMap(string -> {
            String string2 = ColorProperty.getColorKey(string.substring("color.".length()));
            return string.equals(string2) || this.settingsMap.containsKey(string2) ? Stream.empty() : Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>((String)string, string2));
        }).collect(Collectors.toList()).forEach(simpleImmutableEntry -> {
            String string = (String)simpleImmutableEntry.getKey();
            String string2 = (String)simpleImmutableEntry.getValue();
            Main.info("Migrating old color key {0} => {1}", string, string2);
            this.put(string2, this.get(string));
            this.put(string, null);
        });
    }

    private void removeUrlFromEntries(int n, int n2, String string, String string2) {
        Setting setting;
        if (n < n2 && (setting = (Setting)this.settingsMap.get(string)) instanceof MapListSetting) {
            LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
            boolean bl = false;
            for (Map map : (List)((MapListSetting)setting).getValue()) {
                String string3 = (String)map.get("url");
                if (string3 != null && string3.contains(string2)) {
                    bl = true;
                    continue;
                }
                linkedList.add(map);
            }
            if (bl) {
                this.putListOfStructs(string, linkedList);
            }
        }
    }

    private void addNewerDefaultEntry(String string, String string2) {
        ArrayList<Map<String, String>> arrayList;
        Setting setting = (Setting)this.settingsMap.get(string);
        if (setting instanceof MapListSetting && (arrayList = new ArrayList<Map<String, String>>((Collection)((MapListSetting)setting).getValue())).stream().noneMatch(map -> map.containsValue(string2))) {
            ValidatorTagCheckerRulesPreference.RulePrefHelper rulePrefHelper = ValidatorTagCheckerRulesPreference.RulePrefHelper.INSTANCE;
            Optional<SourceEditor.ExtendedSourceEntry> optional = rulePrefHelper.getDefault().stream().filter(extendedSourceEntry -> string2.equals(extendedSourceEntry.url)).findFirst();
            if (optional.isPresent()) {
                arrayList.add(rulePrefHelper.serialize(optional.get()));
            }
            this.putListOfStructs(string, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableSaveOnPut(boolean bl) {
        Preferences preferences = this;
        synchronized (preferences) {
            this.saveOnPut = bl;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final Setting<?> oldValue;
        private final Setting<?> newValue;

        DefaultPreferenceChangeEvent(String string, Setting<?> setting, Setting<?> setting2) {
            this.key = string;
            this.oldValue = setting;
            this.newValue = setting2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Setting<?> getOldValue() {
            return this.oldValue;
        }

        @Override
        public Setting<?> getNewValue() {
            return this.newValue;
        }
    }

    @FunctionalInterface
    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static interface PreferenceChangeEvent {
        public String getKey();

        public Setting<?> getOldValue();

        public Setting<?> getNewValue();
    }
}

