/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DeleteFromRelationConfirmationDialog
extends JDialog
implements TableModelListener {
    private static DeleteFromRelationConfirmationDialog instance;
    private RelationMemberTableModel model;
    private final HtmlPanel htmlPanel = new HtmlPanel();
    private boolean canceled;
    private final JButton btnOK = new JButton(new OKAction());

    public static synchronized DeleteFromRelationConfirmationDialog getInstance() {
        if (instance == null) {
            instance = new DeleteFromRelationConfirmationDialog();
        }
        return instance;
    }

    protected JPanel buildRelationMemberTablePanel() {
        JTable jTable = new JTable(this.model, new RelationMemberTableColumnModel());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JScrollPane(jTable));
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.btnOK);
        this.btnOK.setFocusable(true);
        jPanel.add(new JButton(new CancelAction()));
        jPanel.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Delete#DeleteFromRelations"))));
        return jPanel;
    }

    protected final void build() {
        this.model = new RelationMemberTableModel();
        this.model.addTableModelListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.htmlPanel, "North");
        this.getContentPane().add((Component)this.buildRelationMemberTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Delete#DeleteFromRelations"));
        this.addWindowListener(new WindowEventHandler());
    }

    protected void updateMessage() {
        int n = this.model.getNumObjectsToDelete();
        int n2 = this.model.getNumParentRelations();
        String string = I18n.trn("Please confirm to remove <strong>{0} object</strong>.", "Please confirm to remove <strong>{0} objects</strong>.", n, n);
        String string2 = I18n.trn("{0} relation is affected.", "{0} relations are affected.", n2, n2);
        String string3 = "<html>" + string + ' ' + string2 + "</html>";
        this.htmlPanel.getEditorPane().setText(string3);
        this.invalidate();
    }

    protected void updateTitle() {
        int n = this.model.getNumObjectsToDelete();
        if (n > 0) {
            this.setTitle(I18n.trn("Deleting {0} object", "Deleting {0} objects", n, n));
        } else {
            this.setTitle(I18n.tr("Delete objects", new Object[0]));
        }
    }

    public DeleteFromRelationConfirmationDialog() {
        super((Window)GuiHelper.getFrameForComponent(Main.parent), "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public RelationMemberTableModel getModel() {
        return this.model;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 200))).applySafe(this);
            this.setCanceled(false);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateMessage();
        this.updateTitle();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            DeleteFromRelationConfirmationDialog.this.btnOK.requestFocusInWindow();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort deleting the objects", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and remove the object from the relations", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(false);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    private static class RelationMemberTableColumnModel
    extends DefaultTableColumnModel {
        protected final void createColumns() {
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("To delete", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("From Relation", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(2);
            tableColumn.setHeaderValue(I18n.tr("Pos.", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(30);
            tableColumn.setPreferredWidth(30);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(3);
            tableColumn.setHeaderValue(I18n.tr("Role", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setWidth(50);
            tableColumn.setPreferredWidth(50);
            this.addColumn(tableColumn);
        }

        RelationMemberTableColumnModel() {
            this.createColumns();
        }
    }

    public static class RelationMemberTableModel
    extends DefaultTableModel {
        private final transient List<RelationToChildReference> data = new ArrayList<RelationToChildReference>();

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void populate(Collection<RelationToChildReference> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.data.sort(new RelationToChildReferenceComparator());
            this.fireTableDataChanged();
        }

        public Set<OsmPrimitive> getObjectsToDelete() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationToChildReference relationToChildReference : this.data) {
                hashSet.add(relationToChildReference.getChild());
            }
            return hashSet;
        }

        public int getNumObjectsToDelete() {
            return this.getObjectsToDelete().size();
        }

        public Set<OsmPrimitive> getParentRelations() {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationToChildReference relationToChildReference : this.data) {
                hashSet.add(relationToChildReference.getParent());
            }
            return hashSet;
        }

        public int getNumParentRelations() {
            return this.getParentRelations().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return null;
            }
            RelationToChildReference relationToChildReference = this.data.get(n);
            switch (n2) {
                case 0: {
                    return relationToChildReference.getChild();
                }
                case 1: {
                    return relationToChildReference.getParent();
                }
                case 2: {
                    return relationToChildReference.getPosition() + 1;
                }
                case 3: {
                    return relationToChildReference.getRole();
                }
            }
            assert (false) : "Illegal column index";
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        private static class RelationToChildReferenceComparator
        implements Comparator<RelationToChildReference>,
        Serializable {
            private RelationToChildReferenceComparator() {
            }

            @Override
            public int compare(RelationToChildReference relationToChildReference, RelationToChildReference relationToChildReference2) {
                DefaultNameFormatter defaultNameFormatter = DefaultNameFormatter.getInstance();
                int n = relationToChildReference.getChild().getDisplayName(defaultNameFormatter).compareTo(relationToChildReference2.getChild().getDisplayName(defaultNameFormatter));
                if (n != 0) {
                    return n;
                }
                n = relationToChildReference.getParent().getDisplayName(defaultNameFormatter).compareTo(relationToChildReference2.getParent().getDisplayName(defaultNameFormatter));
                if (n != 0) {
                    return n;
                }
                return Integer.compare(relationToChildReference.getPosition(), relationToChildReference2.getPosition());
            }
        }
    }
}

