/* scratchcore.vapi generated by valac 0.34.4, do not modify. */

namespace Scratch {
	namespace Dialogs {
		[CCode (cheader_filename = "scratchcore.h")]
		public class Preferences : Gtk.Dialog {
			public Preferences (Gtk.Window? parent, Scratch.Services.PluginsManager plugins);
		}
	}
	namespace Services {
		[CCode (cheader_filename = "scratchcore.h")]
		public class Document : Granite.Widgets.Tab {
			public delegate void VoidFunc ();
			public string original_content;
			public bool saved;
			public Scratch.Widgets.SourceView source_view;
			public Document (Gtk.ActionGroup actions, GLib.File? file = null);
			public bool can_write ();
			public void check_file_status ();
			public void check_undoable_actions ();
			public new bool close (bool app_closing = false);
			public void create_page ();
			public void duplicate_selection ();
			public bool exists ();
			public new void focus ();
			public string get_basename ();
			public string get_language_id ();
			public string get_language_name ();
			public string get_mime_type ();
			public string get_selected_text ();
			public string get_text ();
			public string get_uri ();
			public void hide_info_bar ();
			public bool move (GLib.File new_dest);
			public async bool open ();
			public void redo ();
			public void revert ();
			public async bool save ();
			public async bool save_as ();
			public void set_message (Gtk.MessageType type, string label, string? button1 = null, owned Scratch.Services.Document.VoidFunc? callback1 = null, string? button2 = null, owned Scratch.Services.Document.VoidFunc? callback2 = null);
			public void set_saved_status (bool val);
			public void toggle_changed_handlers (bool enabled);
			public void undo ();
			public GLib.File file { get; set; }
			public bool is_file_temporary { get; }
			public Gtk.ActionGroup main_actions { get; set; }
			public signal void doc_closed ();
			public signal void doc_opened ();
			public signal void doc_saved ();
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class FileHandler : GLib.Object {
			public FileHandler ();
			public static bool copy (string path, string new_path);
			public static async string? load_content_from_file (GLib.File file);
			public static string? load_content_from_file_sync (GLib.File file);
			public static bool move (string path, string new_path);
			public static bool move_uri (string uri, string new_uri);
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class Interface : GLib.Object {
			public Scratch.Services.PluginsManager manager;
			public Interface (Scratch.Services.PluginsManager manager);
			public void close_document (Scratch.Services.Document doc);
			public Scratch.Services.Document open_file (GLib.File file);
			public Scratch.TemplateManager template_manager { get; private set; }
			public signal void hook_document (Scratch.Services.Document doc);
			public signal void hook_main_menu (Gtk.Menu menu);
			public signal void hook_notebook_bottom (Gtk.Notebook notebook);
			public signal void hook_notebook_context (Gtk.Notebook notebook);
			public signal void hook_notebook_sidebar (Gtk.Notebook notebook);
			public signal void hook_preferences_dialog (Scratch.Dialogs.Preferences dialog);
			public signal void hook_share_menu (Gtk.Menu menu);
			public signal void hook_split_view (Scratch.Widgets.SplitView view);
			public signal void hook_toolbar (Scratch.Widgets.Toolbar toolbar);
			public signal void hook_window (Scratch.MainWindow window);
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class PluginsManager : GLib.Object {
			public weak Scratch.MainWindow window;
			public PluginsManager (Scratch.MainWindow window, string? set_name = null);
			public Gtk.Widget get_view ();
			public Scratch.Services.Interface plugin_iface { get; private set; }
			public signal void extension_added (Peas.PluginInfo info);
			public signal void extension_removed (Peas.PluginInfo info);
			public signal void hook_document (Scratch.Services.Document doc);
			public signal void hook_main_menu (Gtk.Menu menu);
			public signal void hook_notebook_bottom (Gtk.Notebook notebook);
			public signal void hook_notebook_context (Gtk.Notebook notebook);
			public signal void hook_notebook_sidebar (Gtk.Notebook notebook);
			public signal void hook_preferences_dialog (Scratch.Dialogs.Preferences dialog);
			public signal void hook_share_menu (Gtk.Menu menu);
			public signal void hook_split_view (Scratch.Widgets.SplitView view);
			public signal void hook_toolbar (Scratch.Widgets.Toolbar toolbar);
			public signal void hook_window (Scratch.MainWindow window);
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class ZeitgeistLogger {
			public string actor;
			public string event_manifestation;
			public ZeitgeistLogger ();
			public void close_insert (string? uri, string mimetype);
			public void move_insert (string old_uri, string new_uri, string mimetype);
			public void open_insert (string? uri, string mimetype);
			public void save_insert (string uri, string mimetype);
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public struct Encoding {
			public Scratch.Services.EncodingType type;
			public string? encoding;
			public string? name;
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public enum DocumentStates {
			NORMAL,
			READONLY
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public enum EncodingType {
			ISO_8859_1,
			ISO_8859_2,
			ISO_8859_3,
			ISO_8859_4,
			ISO_8859_5,
			ISO_8859_6,
			ISO_8859_7,
			ISO_8859_8,
			ISO_8859_9,
			ISO_8859_10,
			ISO_8859_13,
			ISO_8859_14,
			ISO_8859_15,
			ISO_8859_16,
			UTF_7,
			UTF_16,
			UTF_16_BE,
			UTF_16_LE,
			UTF_32,
			UCS_2,
			UCS_4,
			ARMSCII_8,
			BIG5,
			BIG5_HKSCS,
			CP_866,
			EUC_JP,
			EUC_JP_MS,
			CP932,
			EUC_KR,
			EUC_TW,
			GB18030,
			GB2312,
			GBK,
			GEOSTD8,
			IBM_850,
			IBM_852,
			IBM_855,
			IBM_857,
			IBM_862,
			IBM_864,
			ISO_2022_JP,
			ISO_2022_KR,
			ISO_IR_111,
			JOHAB,
			KOI8_R,
			KOI8__R,
			KOI8_U,
			SHIFT_JIS,
			TCVN,
			TIS_620,
			UHC,
			VISCII,
			WINDOWS_1250,
			WINDOWS_1251,
			WINDOWS_1252,
			WINDOWS_1253,
			WINDOWS_1254,
			WINDOWS_1255,
			WINDOWS_1256,
			WINDOWS_1257,
			WINDOWS_1258,
			LAST,
			UTF_8,
			UNKNOWN
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public enum FileOption {
			EXISTS,
			IS_DIR,
			IS_EXECUTABLE
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public const Scratch.Services.Encoding[] encodings;
	}
	namespace Utils {
		[CCode (cheader_filename = "scratchcore.h")]
		public static string? last_path;
		[CCode (cheader_filename = "scratchcore.h")]
		public const string UI_PATH;
		[CCode (cheader_filename = "scratchcore.h")]
		public static Gtk.FileChooserDialog new_file_chooser_dialog (Gtk.FileChooserAction action, string title, Gtk.Window? parent, bool select_multiple = false);
	}
	namespace Widgets {
		[CCode (cheader_filename = "scratchcore.h")]
		public class DocumentView : Gtk.Box {
			public GLib.List<Scratch.Services.Document> docs;
			public Granite.Widgets.DynamicNotebook notebook;
			public DocumentView (Scratch.MainWindow window);
			public void close_current_document ();
			public void close_document (Scratch.Services.Document doc);
			public void duplicate_document (Scratch.Services.Document original);
			public new void focus ();
			public Scratch.Services.Document? get_current_document ();
			public bool is_empty ();
			public void new_document ();
			public void new_document_from_clipboard (string clipboard);
			public void next_document ();
			public void open_document (Scratch.Services.Document doc);
			public void previous_document ();
			public void set_current_document (Scratch.Services.Document doc);
			public Scratch.Services.Document current { set; }
			public signal void document_change (Scratch.Services.Document? document);
			public signal void empty ();
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class LoadingView : Gtk.EventBox {
			public LoadingView ();
			public void start ();
			public void stop ();
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class SearchManager : Gtk.Toolbar {
			public Gtk.SpinButton go_to_entry;
			public Gtk.SearchEntry replace_entry;
			public Gtk.SearchEntry search_entry;
			public SearchManager (Scratch.MainWindow window);
			public void highlight_none ();
			public bool search ();
			public void search_next ();
			public void search_previous ();
			public void set_search_string (string to_search);
			public void set_text_view (Scratch.Widgets.SourceView? text_view);
			public signal void need_hide ();
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class SourceView : Gtk.SourceView {
			public Gtk.SourceBuffer buffer;
			public Gtk.TextTag error_tag;
			public Gtk.SourceLanguageManager manager;
			public Gtk.TextMark mark;
			public Gtk.SourceStyleSchemeManager style_scheme_manager;
			public Gtk.TextTag warning_tag;
			public SourceView ();
			public void change_syntax_highlight_from_file (GLib.File file);
			public void duplicate_selection ();
			public string get_selected_text (bool replace_new_line = true);
			public void go_to_line (int line);
			public void set_language (Gtk.SourceLanguage? lang);
			public void set_text (string text, bool opening = true);
			public void use_default_font (bool value);
			public signal void deselected ();
			public signal void language_changed (Gtk.SourceLanguage? language);
			public signal void selection_changed (Gtk.TextIter start_iter, Gtk.TextIter end_iter);
			public signal void style_changed (Gtk.SourceStyleScheme style);
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class SplitView : Granite.Widgets.CollapsiblePaned {
			public Scratch.Widgets.DocumentView? current_view;
			public GLib.List<Scratch.Widgets.DocumentView> views;
			public Granite.Widgets.Welcome welcome_screen;
			public SplitView (Scratch.MainWindow window);
			public Scratch.Widgets.DocumentView? add_view ();
			public Scratch.Widgets.DocumentView? get_current_view ();
			public void hide_welcome ();
			public bool is_empty ();
			public void remove_view (Scratch.Widgets.DocumentView? view = null);
			public void show_welcome ();
			public signal void document_change (Scratch.Services.Document document);
			public signal void views_changed (uint count);
			public signal void welcome_hidden ();
			public signal void welcome_shown ();
		}
		[CCode (cheader_filename = "scratchcore.h")]
		public class Toolbar : Gtk.HeaderBar {
			public Granite.Widgets.AppMenu app_menu;
			public Gtk.ToggleToolButton find_button;
			public Gtk.Menu menu;
			public Gtk.ToolButton open_button;
			public Gtk.ToolButton revert_button;
			public Gtk.ToolButton save_as_button;
			public Gtk.ToolButton save_button;
			public Gtk.MenuButton share_app_menu;
			public Gtk.Menu share_menu;
			public Gtk.ToolButton templates_button;
			public Gtk.ToolButton zoom_default;
			public Toolbar (Gtk.ActionGroup main_actions, Gtk.Menu menu);
		}
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class MainWindow : Gtk.Window {
		public int FONT_SIZE_MAX;
		public int FONT_SIZE_MIN;
		public weak Scratch.ScratchApp app;
		public Gtk.Notebook bottombar;
		public Gtk.Clipboard clipboard;
		public Gtk.Notebook contextbar;
		public Scratch.Widgets.LoadingView loading_view;
		public Gtk.ActionGroup main_actions;
		public Scratch.Widgets.SearchManager search_manager;
		public Gtk.Notebook sidebar;
		public Scratch.Widgets.SplitView split_view;
		public Scratch.Widgets.Toolbar toolbar;
		public Gtk.UIManager ui;
		public MainWindow (Scratch.ScratchApp scratch_app);
		public Scratch.Widgets.DocumentView? add_view ();
		public void close_document (Scratch.Services.Document doc);
		protected override bool delete_event (Gdk.EventAny event);
		public Scratch.Services.Document? get_current_document ();
		public string get_current_font ();
		public double get_current_font_size ();
		public Scratch.Widgets.DocumentView? get_current_view ();
		public string get_default_font ();
		public double get_default_font_size ();
		public bool has_temporary_files ();
		public bool is_empty ();
		public void open_document (Scratch.Services.Document doc);
		public bool quit_source_func ();
		public void set_default_zoom ();
		public void start_loading ();
		public void stop_loading ();
		public void zoom_in ();
		public void zoom_out ();
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class SavedState : Granite.Services.Settings {
		public SavedState ();
		public int hp1_size { get; set; }
		public int hp2_size { get; set; }
		public int vp_size { get; set; }
		public int window_height { get; set; }
		public Scratch.ScratchWindowState window_state { get; set; }
		public int window_width { get; set; }
		public int window_x { get; set; }
		public int window_y { get; set; }
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class ScratchApp : Granite.Application {
		public static Scratch.ScratchApp _instance;
		public ScratchApp ();
		protected override void activate ();
		protected override int command_line (GLib.ApplicationCommandLine command_line);
		public Scratch.MainWindow? get_last_window ();
		public static int main (string[] args);
		public Scratch.MainWindow new_window ();
		protected override void open (GLib.File[] files, string hint);
		public string app_cmd_name { get; }
		public string data_home_folder_unsaved { get; }
		public string default_font { get; set; }
		public static Scratch.ScratchApp instance { get; }
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class ServicesSettings : Granite.Services.Settings {
		public ServicesSettings ();
		public string expiry_time { get; set; }
		public string paste_format_code { get; set; }
		public bool set_private { get; set; }
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class Settings : Granite.Services.Settings {
		public Settings ();
		public bool auto_indent { get; set; }
		public bool autosave { get; set; }
		public bool draw_spaces { get; set; }
		public string focused_document { get; set; }
		public string font { get; set; }
		public bool highlight_current_line { get; set; }
		public bool highlight_matching_brackets { get; set; }
		public int indent_width { get; set; }
		public bool line_break { get; set; }
		public string[] opened_files { get; set; }
		public string[] plugins_enabled { get; set; }
		public int right_margin_position { get; set; }
		public string show_at_start { get; set; }
		public bool show_line_numbers { get; set; }
		public bool show_mini_map { get; set; }
		public bool show_right_margin { get; set; }
		public bool spaces_instead_of_tabs { get; set; }
		public string style_scheme { get; set; }
		public bool use_system_font { get; set; }
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public abstract class Template : GLib.Object {
		public Template ();
		public static void configure_template (string origin, string destination, Gee.HashMap<string,string> variables);
		public static void enumerate_directory (GLib.File origin, Gee.TreeSet<GLib.FileInfo> files, Gee.TreeSet<GLib.File> directories);
		public abstract Gtk.Widget get_creation_box ();
		public static void info_directory (GLib.File file, out bool is_directory, out bool exists);
		public signal void loaded (GLib.File file);
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class TemplateManager : GLib.Object {
		public bool template_available;
		public TemplateManager ();
		public void register_template (string icon_id, string label, string description, GLib.Type template_type);
		public void show_window (Gtk.Widget? parent);
		public signal void template_loaded (Scratch.Template template, GLib.File file);
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public class TestTemplate : Scratch.Template {
		public TestTemplate ();
		public override Gtk.Widget get_creation_box ();
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public enum ScratchWindowState {
		NORMAL,
		MAXIMIZED,
		FULLSCREEN
	}
	[CCode (cheader_filename = "scratchcore.h")]
	public static Scratch.SavedState saved_state;
	[CCode (cheader_filename = "scratchcore.h")]
	public static Scratch.ServicesSettings services;
	[CCode (cheader_filename = "scratchcore.h")]
	public static Scratch.Settings settings;
}
namespace Constants {
	[CCode (cheader_filename = "scratchcore.h")]
	public const string ABOUT_SCRATCH;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string COMMENT;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string DATADIR;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string GENERIC;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string GETTEXT_PACKAGE;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string INSTALL_PREFIX;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string NEW_DOCUMENT;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string NEW_WINDOW;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string PKGDATADIR;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string PLUGINDIR;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string RELEASE_NAME;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string SCRIPTDIR;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string VERSION;
	[CCode (cheader_filename = "scratchcore.h")]
	public const string VERSION_INFO;
}
[CCode (cheader_filename = "scratchcore.h")]
public class TemplateButton : Gtk.Button {
	public TemplateButton (string title, string description, string icon);
	public void set_icon_from_pixbuf (Gdk.Pixbuf pixbuf);
}
