/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;

public class Cardinality
implements Cloneable {
    long min;
    long max;
    public static final long UNBOUND = Long.MAX_VALUE;

    public Cardinality() {
        this.min = 0L;
        this.max = Long.MAX_VALUE;
    }

    public Cardinality(long min, long max) {
        if (min < 0L || max < 0L) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_cardNegative"));
        }
        if (min > max) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_cardMaxLessMin"));
        }
        this.min = min;
        this.max = max;
    }

    public long getMinimum() {
        return this.min;
    }

    public void setMinimum(long min) {
        this.min = min;
    }

    public long getMaximum() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Cardinality)) {
            return false;
        }
        Cardinality other = (Cardinality)o;
        return this.min == other.min && this.max == other.max;
    }

    public int hashCode() {
        return (int)this.min + (int)this.max;
    }

    public boolean isGeneralizing(Cardinality restricted) {
        return this.min <= restricted.min && this.max >= restricted.max;
    }

    private static String makeString(long i) {
        if (i == Long.MAX_VALUE) {
            return "*";
        }
        return Long.toString(i);
    }

    public String toString() {
        if (this.min == 0L && this.max == Long.MAX_VALUE) {
            return "{0..*}";
        }
        if (this.min == this.max) {
            return "{" + Cardinality.makeString(this.min) + "}";
        }
        return "{" + Cardinality.makeString(this.min) + ".." + Cardinality.makeString(this.max) + "}";
    }

    public Cardinality clone() {
        Cardinality cloned = null;
        try {
            cloned = (Cardinality)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }
}

