/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListReorderer {
    public static <T> boolean moveBefore(List<T> sourceList, T object) {
        int previousIndex = sourceList.indexOf(object);
        if (previousIndex < 1) {
            return false;
        }
        sourceList.remove(object);
        sourceList.add(previousIndex - 1, object);
        return true;
    }

    public static <T> void moveBefore(List<T> sourceList, List<T> objectsToMove) {
        ListReorderer.sortMoveListByRelativeOrder(sourceList, objectsToMove);
        ArrayList<T> triedToMove = new ArrayList<T>();
        for (T objectToMove : objectsToMove) {
            int currentPosition = sourceList.indexOf(objectToMove);
            if (currentPosition > 0) {
                T occupyingObject = sourceList.get(currentPosition - 1);
                if (currentPosition < sourceList.size() && !triedToMove.contains(occupyingObject)) {
                    ListReorderer.moveBefore(sourceList, objectToMove);
                }
            }
            triedToMove.add(objectToMove);
        }
    }

    public static <T> void moveTo(List<T> sourceList, List<T> moveList, int index) {
        if (index < 0 || index >= sourceList.size()) {
            return;
        }
        T moveBeforeObject = sourceList.get(index);
        if (moveList.contains(moveBeforeObject)) {
            ArrayList<T> newMoveList = new ArrayList<T>(moveList);
            newMoveList.remove(moveBeforeObject);
            ListReorderer.moveTo(sourceList, newMoveList, index + 1);
            return;
        }
        sourceList.removeAll(moveList);
        index = sourceList.indexOf(moveBeforeObject);
        if (index < 0) {
            index = 0;
        }
        if (index > sourceList.size() - 1) {
            index = sourceList.size() - 1;
        }
        sourceList.addAll(index, moveList);
    }

    public static <T> boolean moveToFront(List<T> sourceList, T object) {
        boolean moved = false;
        if (sourceList.remove(object)) {
            sourceList.add(0, object);
            moved = true;
        }
        return moved;
    }

    public static <T> void moveToFront(List<T> sourceList, List<T> objectsToMove) {
        ListReorderer.sortMoveListByRelativeOrder(sourceList, objectsToMove);
        for (int i = objectsToMove.size() - 1; i >= 0; --i) {
            T object = objectsToMove.get(i);
            if (!sourceList.remove(object)) continue;
            sourceList.add(0, object);
        }
    }

    public static <T> boolean moveAfter(List<T> sourceList, T object) {
        int previousIndex = sourceList.indexOf(object);
        if (previousIndex >= sourceList.size() - 1 || previousIndex == -1) {
            return false;
        }
        sourceList.remove(object);
        sourceList.add(previousIndex + 1, object);
        return true;
    }

    public static <T> void moveAfter(List<T> sourceList, List<T> objectsToMove) {
        ListReorderer.sortMoveListByRelativeOrder(sourceList, objectsToMove);
        ArrayList<T> triedToMove = new ArrayList<T>();
        for (int i = objectsToMove.size() - 1; i >= 0; --i) {
            T occupyingObject;
            T objectToMove = objectsToMove.get(i);
            int currentPosition = sourceList.indexOf(objectToMove);
            if (currentPosition < sourceList.size() - 1 && !triedToMove.contains(occupyingObject = sourceList.get(currentPosition + 1))) {
                ListReorderer.moveAfter(sourceList, objectToMove);
            }
            triedToMove.add(objectToMove);
        }
    }

    public static <T> boolean moveToBack(List<T> sourceList, T object) {
        boolean moved = false;
        if (sourceList.remove(object)) {
            moved = sourceList.add(object);
        }
        return moved;
    }

    public static <T> void moveToBack(List<T> sourceList, List<T> objectsToMove) {
        ListReorderer.sortMoveListByRelativeOrder(sourceList, objectsToMove);
        for (int i = 0; i < objectsToMove.size(); ++i) {
            T object = objectsToMove.get(i);
            if (!sourceList.remove(object)) continue;
            sourceList.add(object);
        }
    }

    public static <T> void sortMoveListByRelativeOrder(final List<T> parentList, List<T> childList) {
        Collections.sort(childList, new Comparator<T>(){

            @Override
            public int compare(T o, T o1) {
                int index1;
                int index = parentList.indexOf(o);
                return index < (index1 = parentList.indexOf(o1)) ? -1 : (index > index1 ? 1 : 0);
            }
        });
    }

    public static <T> boolean allElementsInFront(List<T> sourceList, List<T> checkList) {
        if (!sourceList.containsAll(checkList)) {
            return false;
        }
        int sourceIndex = checkList.size();
        for (int index = 0; index < checkList.size(); ++index) {
            T element = checkList.get(index);
            int checkIndex = sourceList.indexOf(element);
            if (checkIndex < sourceIndex) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allElementsInBack(List<T> sourceList, List<T> checkList) {
        if (!sourceList.containsAll(checkList)) {
            return false;
        }
        int sourceIndex = sourceList.size() - checkList.size();
        for (int index = checkList.size() - 1; index >= 0; --index) {
            T element = checkList.get(index);
            int checkIndex = sourceList.indexOf(element);
            if (checkIndex >= sourceIndex) continue;
            return false;
        }
        return true;
    }

    public static <T> int[] getIndices(List<T> sourceList, List<T> objectsToMove) {
        int[] newIndices = new int[objectsToMove.size()];
        for (int index = 0; index < objectsToMove.size(); ++index) {
            int sourceIndexOfElement;
            T elementToMove = objectsToMove.get(index);
            newIndices[index] = sourceIndexOfElement = sourceList.indexOf(elementToMove);
        }
        return newIndices;
    }
}

