/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry;

import org.gradle.api.plugins.buildcomparison.compare.internal.ComparisonResultType;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntry;
import org.gradle.util.GUtil;

public class ArchiveEntryComparison
implements Comparable<ArchiveEntryComparison> {
    private final ArchiveEntry.Path path;
    private final ArchiveEntry source;
    private final ArchiveEntry target;

    public ArchiveEntryComparison(ArchiveEntry source, ArchiveEntry target) {
        if (source == null && target == null) {
            throw new IllegalArgumentException("Both 'from' and 'to' cannot be null");
        }
        this.path = ((ArchiveEntry)GUtil.elvis((Object)source, (Object)target)).getPath();
        this.source = source;
        this.target = target;
    }

    public ComparisonResultType getComparisonResultType() {
        if (this.source != null && this.target == null) {
            return ComparisonResultType.SOURCE_ONLY;
        }
        if (this.source == null && this.target != null) {
            return ComparisonResultType.TARGET_ONLY;
        }
        return this.source.equals(this.target) ? ComparisonResultType.EQUAL : ComparisonResultType.UNEQUAL;
    }

    public ArchiveEntry.Path getPath() {
        return this.path;
    }

    public ArchiveEntry getSource() {
        return this.source;
    }

    public ArchiveEntry getTarget() {
        return this.target;
    }

    @Override
    public int compareTo(ArchiveEntryComparison o) {
        return this.path.compareTo(o.path);
    }
}

