/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.launcher.daemon.configuration.DaemonParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonCommandLineConverter
extends AbstractCommandLineConverter<DaemonParameters> {
    private static final String DAEMON = "daemon";
    private static final String NO_DAEMON = "no-daemon";
    private static final String FOREGROUND = "foreground";
    private static final String STOP = "stop";
    private static final String STATUS = "status";

    public DaemonParameters convert(ParsedCommandLine args, DaemonParameters target) throws CommandLineArgumentException {
        if (args.hasOption(FOREGROUND)) {
            target.setForeground(true);
        }
        if (args.hasOption(STOP)) {
            target.setStop(true);
        }
        if (args.hasOption(STATUS)) {
            target.setStatus(true);
        }
        if (args.hasOption(NO_DAEMON)) {
            target.setEnabled(false);
        } else if (args.hasOption(DAEMON)) {
            target.setEnabled(true);
        }
        return target;
    }

    public void configure(CommandLineParser parser) {
        parser.option(new String[]{FOREGROUND}).hasDescription("Starts the Gradle Daemon in the foreground.").incubating();
        parser.option(new String[]{STOP}).hasDescription("Stops the Gradle Daemon if it is running.");
        parser.option(new String[]{STATUS}).hasDescription("Shows status of running and recently stopped Gradle Daemon(s).");
        parser.option(new String[]{DAEMON}).hasDescription("Uses the Gradle Daemon to run the build. Starts the Daemon if not running.");
        parser.option(new String[]{NO_DAEMON}).hasDescription("Do not use the Gradle Daemon to run the build.");
        parser.allowOneOf(new String[]{DAEMON, NO_DAEMON});
    }
}

