/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.List;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeAliasConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeAliasConstructorDescriptorImpl
extends FunctionDescriptorImpl
implements TypeAliasConstructorDescriptor {
    @NotNull
    private final TypeAliasDescriptor typeAliasDescriptor;
    @NotNull
    private final ClassConstructorDescriptor underlyingConstructorDescriptor;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isPrimary() {
        return this.getUnderlyingConstructorDescriptor().isPrimary();
    }

    @Override
    @NotNull
    public TypeAliasDescriptor getContainingDeclaration() {
        return this.getTypeAliasDescriptor();
    }

    @Override
    @NotNull
    public ClassDescriptor getConstructedClass() {
        ClassDescriptor classDescriptor = this.getUnderlyingConstructorDescriptor().getConstructedClass();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "underlyingConstructorDescriptor.constructedClass");
        return classDescriptor;
    }

    @Override
    @NotNull
    public KotlinType getReturnType() {
        KotlinType kotlinType = super.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public TypeAliasConstructorDescriptor getOriginal() {
        FunctionDescriptor functionDescriptor = super.getOriginal();
        if (functionDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor");
        }
        return (TypeAliasConstructorDescriptor)functionDescriptor;
    }

    @Override
    @NotNull
    public TypeAliasConstructorDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
        FunctionDescriptor functionDescriptor = super.substitute(substitutor2);
        if (functionDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor");
        }
        return (TypeAliasConstructorDescriptor)functionDescriptor;
    }

    @Override
    @NotNull
    public TypeAliasConstructorDescriptor copy(@NotNull DeclarationDescriptor newOwner, @NotNull Modality modality, @NotNull Visibility visibility, @NotNull CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        Intrinsics.checkParameterIsNotNull((Object)modality, "modality");
        Intrinsics.checkParameterIsNotNull(visibility, "visibility");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        FunctionDescriptor functionDescriptor = this.newCopyBuilder().setOwner(newOwner).setModality(modality).setVisibility(visibility).setKind(kind).setCopyOverrides(copyOverrides).build();
        if (functionDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor");
        }
        return (TypeAliasConstructorDescriptor)functionDescriptor;
    }

    @Override
    @NotNull
    protected TypeAliasConstructorDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(source, "source");
        boolean bl = Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.DECLARATION) || Intrinsics.areEqual((Object)kind, (Object)CallableMemberDescriptor.Kind.SYNTHESIZED);
        if (_Assertions.ENABLED && !bl) {
            String string = "Creating a type alias constructor that is not a declaration: " + "\n" + "copy from: " + this + "\n" + "newOwner: " + newOwner + "\n" + "kind: " + (Object)((Object)kind);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = newName2 == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Renaming type alias constructor: " + this;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new TypeAliasConstructorDescriptorImpl(this.getTypeAliasDescriptor(), this.getUnderlyingConstructorDescriptor(), this, annotations2, CallableMemberDescriptor.Kind.DECLARATION, source);
    }

    @Override
    @NotNull
    public TypeAliasDescriptor getTypeAliasDescriptor() {
        return this.typeAliasDescriptor;
    }

    @Override
    @NotNull
    public ClassConstructorDescriptor getUnderlyingConstructorDescriptor() {
        return this.underlyingConstructorDescriptor;
    }

    private TypeAliasConstructorDescriptorImpl(TypeAliasDescriptor typeAliasDescriptor, ClassConstructorDescriptor underlyingConstructorDescriptor, TypeAliasConstructorDescriptor original, Annotations annotations2, CallableMemberDescriptor.Kind kind, SourceElement source) {
        super(typeAliasDescriptor, original, annotations2, Name.special("<init>"), kind, source);
        this.typeAliasDescriptor = typeAliasDescriptor;
        this.underlyingConstructorDescriptor = underlyingConstructorDescriptor;
    }

    public /* synthetic */ TypeAliasConstructorDescriptorImpl(@NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull ClassConstructorDescriptor underlyingConstructorDescriptor, @Nullable TypeAliasConstructorDescriptor original, @NotNull Annotations annotations2, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source, DefaultConstructorMarker $constructor_marker) {
        this(typeAliasDescriptor, underlyingConstructorDescriptor, original, annotations2, kind, source);
    }

    public static final class Companion {
        @Nullable
        public final TypeAliasConstructorDescriptor create(@NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull ClassConstructorDescriptor constructor, @Nullable TypeSubstitutor substitutor2) {
            Intrinsics.checkParameterIsNotNull(typeAliasDescriptor, "typeAliasDescriptor");
            Intrinsics.checkParameterIsNotNull(constructor, "constructor");
            TypeSubstitutor typeSubstitutor2 = substitutor2;
            if (typeSubstitutor2 == null) {
                typeSubstitutor2 = TypeSubstitutor.EMPTY;
            }
            TypeSubstitutor actualSubstitutor = typeSubstitutor2;
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = null;
            Annotations annotations2 = constructor.getAnnotations();
            CallableMemberDescriptor.Kind kind = constructor.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)kind, "constructor.kind");
            SourceElement sourceElement = typeAliasDescriptor.getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "typeAliasDescriptor.source");
            TypeAliasConstructorDescriptorImpl typeAliasConstructor = new TypeAliasConstructorDescriptorImpl(typeAliasDescriptor, constructor, typeAliasConstructorDescriptor, annotations2, kind, sourceElement, null);
            List<ValueParameterDescriptor> list2 = FunctionDescriptorImpl.getSubstitutedValueParameters(typeAliasConstructor, constructor.getValueParameters(), actualSubstitutor, false);
            if (list2 == null) {
                return null;
            }
            List<ValueParameterDescriptor> valueParameters = list2;
            KotlinType kotlinType = actualSubstitutor.substitute(constructor.getReturnType(), Variance.INVARIANT);
            if (kotlinType == null) {
                return null;
            }
            KotlinType returnType = kotlinType;
            ClassDescriptor containingDeclaration = constructor.getContainingDeclaration();
            ReceiverParameterDescriptor dispatchReceiverParameter = containingDeclaration.isInner() ? containingDeclaration.getThisAsReceiverParameter() : (ReceiverParameterDescriptor)null;
            typeAliasConstructor.initialize(null, dispatchReceiverParameter, typeAliasDescriptor.getDeclaredTypeParameters(), valueParameters, returnType, Modality.FINAL, typeAliasDescriptor.getVisibility());
            return typeAliasConstructor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

