/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.RoleFinder;

public class DefaultRoleFinder
implements RoleFinder {
    protected IElementType[] myElementTypes;

    public DefaultRoleFinder(IElementType ... elementType) {
        this.myElementTypes = elementType;
    }

    @Override
    public ASTNode findChild(@NotNull ASTNode parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/tree/DefaultRoleFinder", "findChild"));
        }
        for (ASTNode current = parent2.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            for (IElementType elementType : this.myElementTypes) {
                if (current.getElementType() != elementType) continue;
                return current;
            }
        }
        return null;
    }
}

