/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jsv;

import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.api.JmolJSpecView;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class JSpecView
implements JmolJSpecView {
    private Viewer vwr;

    public void setViewer(Viewer vwr) {
        this.vwr = vwr;
    }

    public void atomPicked(int atomIndex) {
        if (atomIndex < 0) {
            return;
        }
        String peak = this.getPeakAtomRecord(atomIndex);
        if (peak != null) {
            this.sendJSpecView(peak + " src=\"JmolAtomSelect\"");
        }
    }

    private String getPeakAtomRecord(int atomIndex) {
        Atom[] atoms = this.vwr.ms.at;
        short iModel = atoms[atomIndex].mi;
        String type = null;
        switch (atoms[atomIndex].getElementNumber()) {
            case 1: {
                type = "1HNMR";
                break;
            }
            case 6: {
                type = "13CNMR";
                break;
            }
            default: {
                return null;
            }
        }
        Lst peaks = (Lst)this.vwr.ms.getInfo((int)iModel, "jdxAtomSelect_" + type);
        if (peaks == null) {
            return null;
        }
        this.vwr.ms.htPeaks = new Hashtable();
        Hashtable htPeaks = this.vwr.ms.htPeaks;
        for (int i = 0; i < peaks.size(); ++i) {
            String peak = (String)peaks.get(i);
            System.out.println("Jmol JSpecView.java peak=" + peak);
            BS bsPeak = (BS)htPeaks.get(peak);
            System.out.println("Jmol JSpecView.java bspeak=" + bsPeak);
            if (bsPeak == null) {
                bsPeak = new BS();
                htPeaks.put(peak, bsPeak);
                String satoms = PT.getQuotedAttribute((String)peak, (String)"atoms");
                String select = PT.getQuotedAttribute((String)peak, (String)"select");
                System.out.println("Jmol JSpecView.java satoms select " + satoms + " " + select);
                String script = "";
                if (satoms != null) {
                    script = script + "visible & (atomno=" + PT.rep((String)satoms, (String)",", (String)" or atomno=") + ")";
                } else if (select != null) {
                    script = script + "visible & (" + select + ")";
                }
                System.out.println("Jmol JSpecView.java script : " + script);
                bsPeak.or(this.vwr.getAtomBitSet((Object)script));
            }
            System.out.println("Jmol JSpecView bsPeak now : " + bsPeak + " " + atomIndex);
            if (!bsPeak.get(atomIndex)) continue;
            return peak;
        }
        return null;
    }

    private void sendJSpecView(String peak) {
        String msg = PT.getQuotedAttribute((String)peak, (String)"title");
        if (msg != null) {
            this.vwr.scriptEcho(Logger.debugging ? peak : msg);
        }
        peak = this.vwr.fullName + "JSpecView: " + peak;
        Logger.info((String)("Jmol.JSpecView.sendJSpecView Jmol>JSV " + peak));
        this.vwr.sm.syncSend(peak, (Object)">", 0);
    }

    public void setModel(int modelIndex) {
        int syncMode;
        int n = syncMode = "sync on".equals(this.vwr.ms.getInfoM("jmolscript")) ? 1 : this.vwr.sm.getSyncMode();
        if (syncMode != 1) {
            return;
        }
        String peak = (String)this.vwr.ms.getInfo(modelIndex, "jdxModelSelect");
        if (peak != null) {
            this.sendJSpecView(peak + " src=\"Jmol\"");
        }
    }

    public int getBaseModelIndex(int modelIndex) {
        String baseModel = (String)this.vwr.ms.getInfo(modelIndex, "jdxBaseModel");
        if (baseModel != null) {
            int i = this.vwr.ms.mc;
            while (--i >= 0) {
                if (!baseModel.equals(this.vwr.ms.getInfo(i, "jdxModelID"))) continue;
                return i;
            }
        }
        return modelIndex;
    }

    public String processSync(String script, int jsvMode) {
        if (Logger.debugging) {
            Logger.info((String)("org.jmol.jsv.JSpecView jsvMode=" + jsvMode + " script=" + script));
        }
        switch (jsvMode) {
            default: {
                return null;
            }
            case 0: {
                this.vwr.sm.syncSend(this.vwr.fullName + "JSpecView" + script.substring(10), (Object)">", 0);
                return null;
            }
            case 28: 
            case 35: 
            case 77: {
                this.vwr.sm.syncSend(this.vwr.fullName + "JSpecView:" + script, (Object)">", 0);
                return null;
            }
            case 21: {
                if (this.vwr.isApplet) {
                    return null;
                }
                return null;
            }
            case 14: {
                int modelIndex;
                String filename = PT.getQuotedAttribute((String)script, (String)"file");
                boolean isSimulation = filename != null && filename.startsWith(FileManager.SIMULATION_PROTOCOL);
                String id = !isSimulation || this.vwr.isApplet ? "" : PT.getQuotedAttribute((String)filename.replace('\'', '\"'), (String)"id");
                filename = isSimulation && !this.vwr.isApplet && (filename.startsWith(FileManager.SIMULATION_PROTOCOL + "C13/MOL=") || filename.startsWith(FileManager.SIMULATION_PROTOCOL + "H1/MOL=")) ? null : PT.rep((String)filename, (String)"#molfile", (String)"");
                String modelID = isSimulation ? "molfile" : PT.getQuotedAttribute((String)script, (String)"model");
                String baseModel = PT.getQuotedAttribute((String)script, (String)"baseModel");
                String atoms = PT.getQuotedAttribute((String)script, (String)"atoms");
                String select = PT.getQuotedAttribute((String)script, (String)"select");
                String script2 = PT.getQuotedAttribute((String)script, (String)"script");
                if (id == null || id.length() == 0) {
                    String string = modelID == null ? null : (id = (filename == null ? "" : filename + "#") + modelID);
                }
                if ("".equals(baseModel)) {
                    id = id + ".baseModel";
                }
                int n = modelIndex = id == null ? -3 : this.vwr.getModelIndexFromId(id);
                if (modelIndex == -2) {
                    return null;
                }
                if (modelIndex != -1 || filename == null) {
                    script = "";
                } else {
                    if (isSimulation && !this.vwr.isApplet) {
                        return null;
                    }
                    if (isSimulation) {
                        filename = filename + "#molfile";
                    }
                    script = "load " + PT.esc((String)filename);
                }
                if (id != null) {
                    script = script + ";model " + PT.esc((String)id);
                }
                if (atoms != null) {
                    script = script + ";select visible & (@" + PT.rep((String)atoms, (String)",", (String)" or @") + ")";
                } else if (select != null) {
                    script = script + ";select visible & (" + select + ")";
                }
                if (script2 != null) {
                    script = script + ";" + script2;
                }
                return script;
            }
            case 7: 
        }
        String[] list = Escape.unescapeStringArray((String)script.substring(7));
        Lst peaks = new Lst();
        String type = "1HNMR";
        for (int i = 0; i < list.length; ++i) {
            if (i == 0 && list[i].indexOf(FileManager.SIMULATION_PROTOCOL + "C13/") >= 0) {
                type = "13CNMR";
            }
            peaks.addLast((Object)list[i]);
        }
        this.vwr.ms.setInfo(this.vwr.am.cmi, (Object)("jdxAtomSelect_" + type), (Object)peaks);
        return null;
    }
}

