/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.AbstractDatabase;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.db.paros.ParosDatabaseServer;
import org.parosproxy.paros.db.paros.ParosTableAlert;
import org.parosproxy.paros.db.paros.ParosTableContext;
import org.parosproxy.paros.db.paros.ParosTableHistory;
import org.parosproxy.paros.db.paros.ParosTableParam;
import org.parosproxy.paros.db.paros.ParosTableScan;
import org.parosproxy.paros.db.paros.ParosTableSession;
import org.parosproxy.paros.db.paros.ParosTableSessionUrl;
import org.parosproxy.paros.db.paros.ParosTableStructure;
import org.parosproxy.paros.db.paros.ParosTableTag;
import org.parosproxy.paros.extension.option.DatabaseParam;

public class ParosDatabase
extends AbstractDatabase {
    private ParosDatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableScan tableScan = null;
    private TableTag tableTag = null;
    private TableSessionUrl tableSessionUrl = null;
    private TableParam tableParam = null;
    private TableContext tableContext = null;
    private TableStructure tableStructure = null;
    private List<DatabaseListener> internalDatabaseListeners = new ArrayList<DatabaseListener>();
    private DatabaseParam databaseOptions;

    public ParosDatabase() {
        this.tableHistory = new ParosTableHistory();
        this.tableSession = new ParosTableSession();
        this.tableAlert = new ParosTableAlert();
        this.tableScan = new ParosTableScan();
        this.tableTag = new ParosTableTag();
        this.tableSessionUrl = new ParosTableSessionUrl();
        this.tableParam = new ParosTableParam();
        this.tableContext = new ParosTableContext();
        this.tableStructure = new ParosTableStructure();
        this.internalDatabaseListeners.add(this.tableHistory);
        this.internalDatabaseListeners.add(this.tableSession);
        this.internalDatabaseListeners.add(this.tableAlert);
        this.internalDatabaseListeners.add(this.tableScan);
        this.internalDatabaseListeners.add(this.tableTag);
        this.internalDatabaseListeners.add(this.tableSessionUrl);
        this.internalDatabaseListeners.add(this.tableParam);
        this.internalDatabaseListeners.add(this.tableContext);
        this.internalDatabaseListeners.add(this.tableStructure);
    }

    @Override
    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    private void setDatabaseServer(ParosDatabaseServer parosDatabaseServer) {
        this.databaseServer = parosDatabaseServer;
    }

    @Override
    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    @Override
    public TableSession getTableSession() {
        return this.tableSession;
    }

    @Override
    public void open(String string) throws ClassNotFoundException, Exception {
        this.logger.debug((Object)("open " + string));
        this.setDatabaseServer(new ParosDatabaseServer(string, this.databaseOptions));
        this.notifyListenersDatabaseOpen(this.internalDatabaseListeners, this.getDatabaseServer());
        this.notifyListenersDatabaseOpen(this.getDatabaseServer());
    }

    @Override
    public void deleteSession(String string) {
        this.logger.debug((Object)("deleteSession " + string));
        if (this.databaseServer == null) {
            return;
        }
        try {
            this.databaseServer.shutdown(false);
        }
        catch (SQLException sQLException) {
            this.logger.error((Object)sQLException.getMessage(), (Throwable)sQLException);
        }
        this.deleteDbFile(new File(string));
        this.deleteDbFile(new File(string + ".data"));
        this.deleteDbFile(new File(string + ".script"));
        this.deleteDbFile(new File(string + ".properties"));
        this.deleteDbFile(new File(string + ".backup"));
        this.deleteDbFile(new File(string + ".lobs"));
        this.databaseServer = null;
    }

    private void deleteDbFile(File file) {
        this.logger.debug((Object)("Deleting " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            this.logger.error((Object)("Failed to delete " + file.getAbsolutePath()));
        }
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        this.logger.debug((Object)"close");
        if (this.databaseServer == null) {
            return;
        }
        super.close(bl, bl2);
        try {
            if (bl2) {
                this.getTableHistory().deleteTemporary();
            }
            this.databaseServer.shutdown(bl);
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    @Override
    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    @Override
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @Override
    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }

    @Override
    public TableTag getTableTag() {
        return this.tableTag;
    }

    @Override
    public void setTableTag(TableTag tableTag) {
        this.tableTag = tableTag;
    }

    @Override
    public TableSessionUrl getTableSessionUrl() {
        return this.tableSessionUrl;
    }

    @Override
    public void setTableSessionUrl(TableSessionUrl tableSessionUrl) {
        this.tableSessionUrl = tableSessionUrl;
    }

    @Override
    public TableParam getTableParam() {
        return this.tableParam;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public TableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getType() {
        return "hsqldb";
    }

    public void setDatabaseParam(DatabaseParam databaseParam) {
        if (databaseParam == null) {
            throw new IllegalArgumentException("Parameter databaseOptions must not be null.");
        }
        this.databaseOptions = databaseParam;
    }

    @Override
    public void discardSession(long l) throws DatabaseException {
    }
}

