/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class PackageReader
extends BandStructure {
    Package pkg;
    byte[] bytes;
    LimitedBuffer in;
    int[] tagCount = new int[14];
    int numFiles;
    int numAttrDefs;
    int numInnerClasses;
    int numClasses;
    static final int MAGIC_BYTES = 4;
    Map<ConstantPool.Utf8Entry, ConstantPool.SignatureEntry> utf8Signatures;
    static final int NO_FLAGS_YET = 0;
    Comparator<ConstantPool.Entry> entryOutputOrder = new Comparator<ConstantPool.Entry>(){

        @Override
        public int compare(ConstantPool.Entry e0, ConstantPool.Entry e1) {
            int k0 = PackageReader.this.getOutputIndex(e0);
            int k1 = PackageReader.this.getOutputIndex(e1);
            if (k0 >= 0 && k1 >= 0) {
                return k0 - k1;
            }
            if (k0 == k1) {
                return e0.compareTo(e1);
            }
            return k0 >= 0 ? -1 : 1;
        }
    };
    Code[] allCodes;
    List<Code> codesWithFlags;
    Map<Package.Class, Set<ConstantPool.Entry>> ldcRefMap = new HashMap<Package.Class, Set<ConstantPool.Entry>>();

    PackageReader(Package pkg, InputStream in) throws IOException {
        this.pkg = pkg;
        this.in = new LimitedBuffer(in);
    }

    void read() throws IOException {
        boolean ok = false;
        try {
            this.readFileHeader();
            this.readBandHeaders();
            this.readConstantPool();
            this.readAttrDefs();
            this.readInnerClasses();
            Package.Class[] classes = this.readClasses();
            this.readByteCodes();
            this.readFiles();
            assert (this.archiveSize1 == 0L || this.in.atLimit());
            assert (this.archiveSize1 == 0L || this.in.getBytesServed() == this.archiveSize0 + this.archiveSize1);
            this.all_bands.doneDisbursing();
            for (int i = 0; i < classes.length; ++i) {
                this.reconstructClass(classes[i]);
            }
            ok = true;
        }
        catch (Exception ee) {
            Utils.log.warning("Error on input: " + ee, ee);
            if (this.verbose > 0) {
                Utils.log.info("Stream offsets: served=" + this.in.getBytesServed() + " buffered=" + this.in.buffered + " limit=" + this.in.limit);
            }
            if (ee instanceof IOException) {
                throw (IOException)ee;
            }
            if (ee instanceof RuntimeException) {
                throw (RuntimeException)ee;
            }
            throw new Error("error unpacking", ee);
        }
    }

    void readFileHeader() throws IOException {
        this.readArchiveMagic();
        this.readArchiveHeader();
    }

    private int getMagicInt32() throws IOException {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res |= this.archive_magic.getByte() & 0xFF;
        }
        return res;
    }

    void readArchiveMagic() throws IOException {
        this.in.setReadLimit(19L);
        this.archive_magic.expectLength(4);
        this.archive_magic.readFrom(this.in);
        this.pkg.magic = this.getMagicInt32();
        this.archive_magic.doneDisbursing();
    }

    void readArchiveHeader() throws IOException {
        assert (26 == 8 + ConstantPool.TAGS_IN_ORDER.length + 6);
        this.archive_header_0.expectLength(3);
        this.archive_header_0.readFrom(this.in);
        this.pkg.package_minver = this.archive_header_0.getInt();
        this.pkg.package_majver = this.archive_header_0.getInt();
        this.pkg.checkVersion();
        this.initPackageMajver(this.pkg.package_majver);
        this.archiveOptions = this.archive_header_0.getInt();
        this.archive_header_0.doneDisbursing();
        boolean haveSpecial = PackageReader.testBit(this.archiveOptions, 1);
        boolean haveFiles = PackageReader.testBit(this.archiveOptions, 16);
        boolean haveNumbers = PackageReader.testBit(this.archiveOptions, 2);
        this.initAttrIndexLimit();
        this.archive_header_S.expectLength(haveFiles ? 2 : 0);
        this.archive_header_S.readFrom(this.in);
        if (haveFiles) {
            long sizeHi = this.archive_header_S.getInt();
            long sizeLo = this.archive_header_S.getInt();
            this.archiveSize1 = (sizeHi << 32) + (sizeLo << 32 >>> 32);
            this.in.setReadLimit(this.archiveSize1);
        } else {
            this.archiveSize1 = 0L;
            this.in.setReadLimit(-1L);
        }
        this.archive_header_S.doneDisbursing();
        this.archiveSize0 = this.in.getBytesServed();
        int remainingHeaders = 21;
        if (!haveFiles) {
            remainingHeaders -= 3;
        }
        if (!haveSpecial) {
            remainingHeaders -= 2;
        }
        if (!haveNumbers) {
            remainingHeaders -= 4;
        }
        assert (remainingHeaders >= 12);
        this.archive_header_1.expectLength(remainingHeaders);
        this.archive_header_1.readFrom(this.in);
        if (haveFiles) {
            this.archiveNextCount = this.archive_header_1.getInt();
            this.pkg.default_modtime = this.archive_header_1.getInt();
            this.numFiles = this.archive_header_1.getInt();
        } else {
            this.archiveNextCount = 0;
            this.numFiles = 0;
        }
        if (haveSpecial) {
            this.band_headers.expectLength(this.archive_header_1.getInt());
            this.numAttrDefs = this.archive_header_1.getInt();
        } else {
            this.band_headers.expectLength(0);
            this.numAttrDefs = 0;
        }
        this.readConstantPoolCounts(haveNumbers);
        this.numInnerClasses = this.archive_header_1.getInt();
        this.pkg.default_class_minver = (short)this.archive_header_1.getInt();
        this.pkg.default_class_majver = (short)this.archive_header_1.getInt();
        this.numClasses = this.archive_header_1.getInt();
        this.archive_header_1.doneDisbursing();
        if (PackageReader.testBit(this.archiveOptions, 32)) {
            this.pkg.default_options |= 1;
        }
    }

    void readBandHeaders() throws IOException {
        this.band_headers.readFrom(this.in);
        this.bandHeaderBytePos = 1;
        this.bandHeaderBytes = new byte[this.bandHeaderBytePos + this.band_headers.length()];
        for (int i = this.bandHeaderBytePos; i < this.bandHeaderBytes.length; ++i) {
            this.bandHeaderBytes[i] = (byte)this.band_headers.getByte();
        }
        this.band_headers.doneDisbursing();
    }

    /*
     * Unable to fully structure code
     */
    void readConstantPoolCounts(boolean haveNumbers) throws IOException {
        block3: for (k = 0; k < ConstantPool.TAGS_IN_ORDER.length; ++k) {
            tag = ConstantPool.TAGS_IN_ORDER[k];
            if (haveNumbers) ** GOTO lbl-1000
            switch (tag) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block3;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.tagCount[tag] = this.archive_header_1.getInt();
                }
            }
        }
    }

    @Override
    protected ConstantPool.Index getCPIndex(byte tag) {
        return this.pkg.cp.getIndexByTag(tag);
    }

    ConstantPool.Index initCPIndex(byte tag, ConstantPool.Entry[] cpMap) {
        if (this.verbose > 3) {
            for (int i = 0; i < cpMap.length; ++i) {
                Utils.log.fine("cp.add " + cpMap[i]);
            }
        }
        ConstantPool.Index index = ConstantPool.makeIndex(ConstantPool.tagName(tag), cpMap);
        if (this.verbose > 1) {
            Utils.log.fine("Read " + index);
        }
        this.pkg.cp.initIndexByTag(tag, index);
        return index;
    }

    void readConstantPool() throws IOException {
        if (this.verbose > 0) {
            Utils.log.info("Reading CP");
        }
        for (int k = 0; k < ConstantPool.TAGS_IN_ORDER.length; ++k) {
            byte tag = ConstantPool.TAGS_IN_ORDER[k];
            int len = this.tagCount[tag];
            ConstantPool.Entry[] cpMap = new ConstantPool.Entry[len];
            if (this.verbose > 0) {
                Utils.log.info("Reading " + cpMap.length + " " + ConstantPool.tagName(tag) + " entries...");
            }
            switch (tag) {
                case 1: {
                    this.readUtf8Bands(cpMap);
                    break;
                }
                case 3: {
                    this.cp_Int.expectLength(cpMap.length);
                    this.cp_Int.readFrom(this.in);
                    for (int i = 0; i < cpMap.length; ++i) {
                        int x = this.cp_Int.getInt();
                        cpMap[i] = ConstantPool.getLiteralEntry(Integer.valueOf(x));
                    }
                    this.cp_Int.doneDisbursing();
                    break;
                }
                case 4: {
                    this.cp_Float.expectLength(cpMap.length);
                    this.cp_Float.readFrom(this.in);
                    for (int i = 0; i < cpMap.length; ++i) {
                        int x = this.cp_Float.getInt();
                        float fx = Float.intBitsToFloat(x);
                        cpMap[i] = ConstantPool.getLiteralEntry(Float.valueOf(fx));
                    }
                    this.cp_Float.doneDisbursing();
                    break;
                }
                case 5: {
                    long x;
                    this.cp_Long_hi.expectLength(cpMap.length);
                    this.cp_Long_hi.readFrom(this.in);
                    this.cp_Long_lo.expectLength(cpMap.length);
                    this.cp_Long_lo.readFrom(this.in);
                    for (int i = 0; i < cpMap.length; ++i) {
                        long hi = this.cp_Long_hi.getInt();
                        long lo = this.cp_Long_lo.getInt();
                        x = (hi << 32) + (lo << 32 >>> 32);
                        cpMap[i] = ConstantPool.getLiteralEntry(Long.valueOf(x));
                    }
                    this.cp_Long_hi.doneDisbursing();
                    this.cp_Long_lo.doneDisbursing();
                    break;
                }
                case 6: {
                    long x;
                    this.cp_Double_hi.expectLength(cpMap.length);
                    this.cp_Double_hi.readFrom(this.in);
                    this.cp_Double_lo.expectLength(cpMap.length);
                    this.cp_Double_lo.readFrom(this.in);
                    for (int i = 0; i < cpMap.length; ++i) {
                        long hi = this.cp_Double_hi.getInt();
                        long lo = this.cp_Double_lo.getInt();
                        x = (hi << 32) + (lo << 32 >>> 32);
                        double dx = Double.longBitsToDouble(x);
                        cpMap[i] = ConstantPool.getLiteralEntry(Double.valueOf(dx));
                    }
                    this.cp_Double_hi.doneDisbursing();
                    this.cp_Double_lo.doneDisbursing();
                    break;
                }
                case 8: {
                    this.cp_String.expectLength(cpMap.length);
                    this.cp_String.readFrom(this.in);
                    this.cp_String.setIndex(this.getCPIndex((byte)1));
                    for (int i = 0; i < cpMap.length; ++i) {
                        cpMap[i] = ConstantPool.getLiteralEntry((Comparable)((Object)this.cp_String.getRef().stringValue()));
                    }
                    this.cp_String.doneDisbursing();
                    break;
                }
                case 7: {
                    this.cp_Class.expectLength(cpMap.length);
                    this.cp_Class.readFrom(this.in);
                    this.cp_Class.setIndex(this.getCPIndex((byte)1));
                    for (int i = 0; i < cpMap.length; ++i) {
                        cpMap[i] = ConstantPool.getClassEntry(this.cp_Class.getRef().stringValue());
                    }
                    this.cp_Class.doneDisbursing();
                    break;
                }
                case 13: {
                    this.readSignatureBands(cpMap);
                    break;
                }
                case 12: {
                    this.cp_Descr_name.expectLength(cpMap.length);
                    this.cp_Descr_name.readFrom(this.in);
                    this.cp_Descr_name.setIndex(this.getCPIndex((byte)1));
                    this.cp_Descr_type.expectLength(cpMap.length);
                    this.cp_Descr_type.readFrom(this.in);
                    this.cp_Descr_type.setIndex(this.getCPIndex((byte)13));
                    for (int i = 0; i < cpMap.length; ++i) {
                        ConstantPool.Entry ref = this.cp_Descr_name.getRef();
                        ConstantPool.Entry ref2 = this.cp_Descr_type.getRef();
                        cpMap[i] = ConstantPool.getDescriptorEntry((ConstantPool.Utf8Entry)ref, (ConstantPool.SignatureEntry)ref2);
                    }
                    this.cp_Descr_name.doneDisbursing();
                    this.cp_Descr_type.doneDisbursing();
                    break;
                }
                case 9: {
                    this.readMemberRefs(tag, cpMap, this.cp_Field_class, this.cp_Field_desc);
                    break;
                }
                case 10: {
                    this.readMemberRefs(tag, cpMap, this.cp_Method_class, this.cp_Method_desc);
                    break;
                }
                case 11: {
                    this.readMemberRefs(tag, cpMap, this.cp_Imethod_class, this.cp_Imethod_desc);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ConstantPool.Index index = this.initCPIndex(tag, cpMap);
            if (!this.optDumpBands) continue;
            try (PrintStream ps = new PrintStream(PackageReader.getDumpStream(index, ".idx"));){
                PackageReader.printArrayTo(ps, index.cpMap, 0, index.cpMap.length);
                continue;
            }
        }
        this.cp_bands.doneDisbursing();
        this.setBandIndexes();
    }

    void readUtf8Bands(ConstantPool.Entry[] cpMap) throws IOException {
        int i;
        int prefix;
        int len = cpMap.length;
        if (len == 0) {
            return;
        }
        boolean SUFFIX_SKIP_1 = true;
        int PREFIX_SKIP_2 = 2;
        this.cp_Utf8_prefix.expectLength(Math.max(0, len - 2));
        this.cp_Utf8_prefix.readFrom(this.in);
        this.cp_Utf8_suffix.expectLength(Math.max(0, len - 1));
        this.cp_Utf8_suffix.readFrom(this.in);
        char[][] suffixChars = new char[len][];
        int bigSuffixCount = 0;
        this.cp_Utf8_chars.expectLength(this.cp_Utf8_suffix.getIntTotal());
        this.cp_Utf8_chars.readFrom(this.in);
        for (int i2 = 0; i2 < len; ++i2) {
            int suffix;
            int n = suffix = i2 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (suffix == 0 && i2 >= 1) {
                ++bigSuffixCount;
                continue;
            }
            suffixChars[i2] = new char[suffix];
            for (int j = 0; j < suffix; ++j) {
                int ch = this.cp_Utf8_chars.getInt();
                assert (ch == (char)ch);
                suffixChars[i2][j] = (char)ch;
            }
        }
        this.cp_Utf8_chars.doneDisbursing();
        int maxChars = 0;
        this.cp_Utf8_big_suffix.expectLength(bigSuffixCount);
        this.cp_Utf8_big_suffix.readFrom(this.in);
        this.cp_Utf8_suffix.resetForSecondPass();
        for (int i3 = 0; i3 < len; ++i3) {
            int suffix = i3 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            int n = prefix = i3 < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            if (suffix == 0 && i3 >= 1) {
                assert (suffixChars[i3] == null);
                suffix = this.cp_Utf8_big_suffix.getInt();
            } else assert (suffixChars[i3] != null);
            if (maxChars >= prefix + suffix) continue;
            maxChars = prefix + suffix;
        }
        char[] buf = new char[maxChars];
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (i = 0; i < len; ++i) {
            int suffix;
            if (i < 1 || (suffix = this.cp_Utf8_suffix.getInt()) != 0) continue;
            suffix = this.cp_Utf8_big_suffix.getInt();
            suffixChars[i] = new char[suffix];
            if (suffix == 0) continue;
            BandStructure.IntBand packed = this.cp_Utf8_big_chars.newIntBand("(Utf8_big_" + i + ")");
            packed.expectLength(suffix);
            packed.readFrom(this.in);
            for (int j = 0; j < suffix; ++j) {
                int ch = packed.getInt();
                assert (ch == (char)ch);
                suffixChars[i][j] = (char)ch;
            }
            packed.doneDisbursing();
        }
        this.cp_Utf8_big_chars.doneDisbursing();
        this.cp_Utf8_prefix.resetForSecondPass();
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (i = 0; i < len; ++i) {
            int suffix;
            prefix = i < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            int n = suffix = i < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (suffix == 0 && i >= 1) {
                suffix = this.cp_Utf8_big_suffix.getInt();
            }
            System.arraycopy(suffixChars[i], 0, buf, prefix, suffix);
            cpMap[i] = ConstantPool.getUtf8Entry(new String(buf, 0, prefix + suffix));
        }
        this.cp_Utf8_prefix.doneDisbursing();
        this.cp_Utf8_suffix.doneDisbursing();
        this.cp_Utf8_big_suffix.doneDisbursing();
    }

    void readSignatureBands(ConstantPool.Entry[] cpMap) throws IOException {
        ConstantPool.Utf8Entry formRef;
        int i;
        this.cp_Signature_form.expectLength(cpMap.length);
        this.cp_Signature_form.readFrom(this.in);
        this.cp_Signature_form.setIndex(this.getCPIndex((byte)1));
        int[] numSigClasses = new int[cpMap.length];
        for (i = 0; i < cpMap.length; ++i) {
            formRef = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            numSigClasses[i] = ConstantPool.countClassParts(formRef);
        }
        this.cp_Signature_form.resetForSecondPass();
        this.cp_Signature_classes.expectLength(PackageReader.getIntTotal(numSigClasses));
        this.cp_Signature_classes.readFrom(this.in);
        this.cp_Signature_classes.setIndex(this.getCPIndex((byte)7));
        this.utf8Signatures = new HashMap<ConstantPool.Utf8Entry, ConstantPool.SignatureEntry>();
        for (i = 0; i < cpMap.length; ++i) {
            formRef = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            ConstantPool.ClassEntry[] classRefs = new ConstantPool.ClassEntry[numSigClasses[i]];
            for (int j = 0; j < classRefs.length; ++j) {
                classRefs[j] = (ConstantPool.ClassEntry)this.cp_Signature_classes.getRef();
            }
            ConstantPool.SignatureEntry se = ConstantPool.getSignatureEntry(formRef, classRefs);
            cpMap[i] = se;
            this.utf8Signatures.put(se.asUtf8Entry(), se);
        }
        this.cp_Signature_form.doneDisbursing();
        this.cp_Signature_classes.doneDisbursing();
    }

    void readMemberRefs(byte tag, ConstantPool.Entry[] cpMap, BandStructure.CPRefBand cp_class, BandStructure.CPRefBand cp_desc) throws IOException {
        cp_class.expectLength(cpMap.length);
        cp_class.readFrom(this.in);
        cp_class.setIndex(this.getCPIndex((byte)7));
        cp_desc.expectLength(cpMap.length);
        cp_desc.readFrom(this.in);
        cp_desc.setIndex(this.getCPIndex((byte)12));
        for (int i = 0; i < cpMap.length; ++i) {
            ConstantPool.ClassEntry mclass = (ConstantPool.ClassEntry)cp_class.getRef();
            ConstantPool.DescriptorEntry mdescr = (ConstantPool.DescriptorEntry)cp_desc.getRef();
            cpMap[i] = ConstantPool.getMemberEntry(tag, mclass, mdescr);
        }
        cp_class.doneDisbursing();
        cp_desc.doneDisbursing();
    }

    void readFiles() throws IOException {
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + this.numFiles + " files...");
        }
        this.file_name.expectLength(this.numFiles);
        this.file_size_lo.expectLength(this.numFiles);
        int options = this.archiveOptions;
        boolean haveSizeHi = PackageReader.testBit(options, 256);
        boolean haveModtime = PackageReader.testBit(options, 64);
        boolean haveOptions = PackageReader.testBit(options, 128);
        if (haveSizeHi) {
            this.file_size_hi.expectLength(this.numFiles);
        }
        if (haveModtime) {
            this.file_modtime.expectLength(this.numFiles);
        }
        if (haveOptions) {
            this.file_options.expectLength(this.numFiles);
        }
        this.file_name.readFrom(this.in);
        this.file_size_hi.readFrom(this.in);
        this.file_size_lo.readFrom(this.in);
        this.file_modtime.readFrom(this.in);
        this.file_options.readFrom(this.in);
        this.file_bits.setInputStreamFrom(this.in);
        Iterator<Package.Class> nextClass = this.pkg.getClasses().iterator();
        long totalFileLength = 0L;
        long[] fileLengths = new long[this.numFiles];
        for (int i = 0; i < this.numFiles; ++i) {
            long size = (long)this.file_size_lo.getInt() << 32 >>> 32;
            if (haveSizeHi) {
                size += (long)this.file_size_hi.getInt() << 32;
            }
            fileLengths[i] = size;
            totalFileLength += size;
        }
        assert (this.in.getReadLimit() == -1L || this.in.getReadLimit() == totalFileLength);
        byte[] buf = new byte[65536];
        for (int i = 0; i < this.numFiles; ++i) {
            int nr;
            ConstantPool.Utf8Entry name = (ConstantPool.Utf8Entry)this.file_name.getRef();
            long size = fileLengths[i];
            Package package_ = this.pkg;
            package_.getClass();
            Package.File file = package_.new Package.File(name);
            file.modtime = this.pkg.default_modtime;
            file.options = this.pkg.default_options;
            if (haveModtime) {
                file.modtime += this.file_modtime.getInt();
            }
            if (haveOptions) {
                file.options |= this.file_options.getInt();
            }
            if (this.verbose > 1) {
                Utils.log.fine("Reading " + size + " bytes of " + name.stringValue());
            }
            for (long toRead = size; toRead > 0L; toRead -= (long)nr) {
                nr = buf.length;
                if ((long)nr > toRead) {
                    nr = (int)toRead;
                }
                if ((nr = this.file_bits.getInputStream().read(buf, 0, nr)) < 0) {
                    throw new EOFException();
                }
                file.addBytes(buf, 0, nr);
            }
            this.pkg.addFile(file);
            if (!file.isClassStub()) continue;
            assert (file.getFileLength() == 0L);
            Package.Class cls = nextClass.next();
            cls.initFile(file);
        }
        while (nextClass.hasNext()) {
            Package.Class cls = nextClass.next();
            cls.initFile(null);
            cls.file.modtime = this.pkg.default_modtime;
        }
        this.file_name.doneDisbursing();
        this.file_size_hi.doneDisbursing();
        this.file_size_lo.doneDisbursing();
        this.file_modtime.doneDisbursing();
        this.file_options.doneDisbursing();
        this.file_bits.doneDisbursing();
        this.file_bands.doneDisbursing();
        if (this.archiveSize1 != 0L && !this.in.atLimit()) {
            throw new RuntimeException("Predicted archive_size " + this.archiveSize1 + " != " + (this.in.getBytesServed() - this.archiveSize0));
        }
    }

    void readAttrDefs() throws IOException {
        this.attr_definition_headers.expectLength(this.numAttrDefs);
        this.attr_definition_name.expectLength(this.numAttrDefs);
        this.attr_definition_layout.expectLength(this.numAttrDefs);
        this.attr_definition_headers.readFrom(this.in);
        this.attr_definition_name.readFrom(this.in);
        this.attr_definition_layout.readFrom(this.in);
        try (PrintStream dump = !this.optDumpBands ? null : new PrintStream(PackageReader.getDumpStream(this.attr_definition_headers, ".def"));){
            for (int i = 0; i < this.numAttrDefs; ++i) {
                int header = this.attr_definition_headers.getByte();
                ConstantPool.Utf8Entry name = (ConstantPool.Utf8Entry)this.attr_definition_name.getRef();
                ConstantPool.Utf8Entry layout = (ConstantPool.Utf8Entry)this.attr_definition_layout.getRef();
                int ctype = header & 3;
                int index = (header >> 2) - 1;
                Attribute.Layout def = new Attribute.Layout(ctype, name.stringValue(), layout.stringValue());
                String pvLayout = def.layoutForPackageMajver(this.getPackageMajver());
                if (!pvLayout.equals(def.layout())) {
                    throw new IOException("Bad attribute layout in version 150 archive: " + def.layout());
                }
                this.setAttributeLayoutIndex(def, index);
                if (dump == null) continue;
                dump.println(index + " " + def);
            }
        }
        this.attr_definition_headers.doneDisbursing();
        this.attr_definition_name.doneDisbursing();
        this.attr_definition_layout.doneDisbursing();
        this.makeNewAttributeBands();
        this.attr_definition_bands.doneDisbursing();
    }

    void readInnerClasses() throws IOException {
        this.ic_this_class.expectLength(this.numInnerClasses);
        this.ic_this_class.readFrom(this.in);
        this.ic_flags.expectLength(this.numInnerClasses);
        this.ic_flags.readFrom(this.in);
        int longICCount = 0;
        for (int i = 0; i < this.numInnerClasses; ++i) {
            boolean longForm;
            int flags = this.ic_flags.getInt();
            boolean bl = longForm = (flags & 0x10000) != 0;
            if (!longForm) continue;
            ++longICCount;
        }
        this.ic_outer_class.expectLength(longICCount);
        this.ic_outer_class.readFrom(this.in);
        this.ic_name.expectLength(longICCount);
        this.ic_name.readFrom(this.in);
        this.ic_flags.resetForSecondPass();
        ArrayList<Package.InnerClass> icList = new ArrayList<Package.InnerClass>(this.numInnerClasses);
        for (int i = 0; i < this.numInnerClasses; ++i) {
            ConstantPool.Utf8Entry thisName;
            ConstantPool.ClassEntry outerClass;
            int flags = this.ic_flags.getInt();
            boolean longForm = (flags & 0x10000) != 0;
            flags &= 0xFFFEFFFF;
            ConstantPool.ClassEntry thisClass = (ConstantPool.ClassEntry)this.ic_this_class.getRef();
            if (longForm) {
                outerClass = (ConstantPool.ClassEntry)this.ic_outer_class.getRef();
                thisName = (ConstantPool.Utf8Entry)this.ic_name.getRef();
            } else {
                String n = thisClass.stringValue();
                String[] parse = Package.parseInnerClassName(n);
                assert (parse != null);
                String pkgOuter = parse[0];
                String name = parse[2];
                outerClass = pkgOuter == null ? null : ConstantPool.getClassEntry(pkgOuter);
                thisName = name == null ? null : ConstantPool.getUtf8Entry(name);
            }
            Package.InnerClass ic = new Package.InnerClass(thisClass, outerClass, thisName, flags);
            assert (longForm || ic.predictable);
            icList.add(ic);
        }
        this.ic_flags.doneDisbursing();
        this.ic_this_class.doneDisbursing();
        this.ic_outer_class.doneDisbursing();
        this.ic_name.doneDisbursing();
        this.pkg.setAllInnerClasses(icList);
        this.ic_bands.doneDisbursing();
    }

    void readLocalInnerClasses(Package.Class cls) throws IOException {
        int nc = this.class_InnerClasses_N.getInt();
        ArrayList<Package.InnerClass> localICs = new ArrayList<Package.InnerClass>(nc);
        for (int i = 0; i < nc; ++i) {
            ConstantPool.ClassEntry thisClass = (ConstantPool.ClassEntry)this.class_InnerClasses_RC.getRef();
            int flags = this.class_InnerClasses_F.getInt();
            if (flags == 0) {
                Package.InnerClass ic = this.pkg.getGlobalInnerClass(thisClass);
                assert (ic != null);
                localICs.add(ic);
                continue;
            }
            if (flags == 65536) {
                flags = 0;
            }
            ConstantPool.ClassEntry outer = (ConstantPool.ClassEntry)this.class_InnerClasses_outer_RCN.getRef();
            ConstantPool.Utf8Entry name = (ConstantPool.Utf8Entry)this.class_InnerClasses_name_RUN.getRef();
            localICs.add(new Package.InnerClass(thisClass, outer, name, flags));
        }
        cls.setInnerClasses(localICs);
    }

    Package.Class[] readClasses() throws IOException {
        Package.Class[] classes = new Package.Class[this.numClasses];
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + classes.length + " classes...");
        }
        this.class_this.expectLength(this.numClasses);
        this.class_super.expectLength(this.numClasses);
        this.class_interface_count.expectLength(this.numClasses);
        this.class_this.readFrom(this.in);
        this.class_super.readFrom(this.in);
        this.class_interface_count.readFrom(this.in);
        this.class_interface.expectLength(this.class_interface_count.getIntTotal());
        this.class_interface.readFrom(this.in);
        for (int i = 0; i < classes.length; ++i) {
            Package.Class cls;
            ConstantPool.ClassEntry thisClass = (ConstantPool.ClassEntry)this.class_this.getRef();
            ConstantPool.ClassEntry superClass = (ConstantPool.ClassEntry)this.class_super.getRef();
            ConstantPool.ClassEntry[] interfaces = new ConstantPool.ClassEntry[this.class_interface_count.getInt()];
            for (int j = 0; j < interfaces.length; ++j) {
                interfaces[j] = (ConstantPool.ClassEntry)this.class_interface.getRef();
            }
            if (superClass == thisClass) {
                superClass = null;
            }
            Package package_ = this.pkg;
            package_.getClass();
            classes[i] = cls = package_.new Package.Class(0, thisClass, superClass, interfaces);
        }
        this.class_this.doneDisbursing();
        this.class_super.doneDisbursing();
        this.class_interface_count.doneDisbursing();
        this.class_interface.doneDisbursing();
        this.readMembers(classes);
        this.countAndReadAttrs(0, Arrays.asList(classes));
        this.pkg.trimToSize();
        this.readCodeHeaders();
        return classes;
    }

    private int getOutputIndex(ConstantPool.Entry e) {
        assert (e.tag != 13);
        int k = this.pkg.cp.untypedIndexOf(e);
        if (k >= 0) {
            return k;
        }
        if (e.tag == 1) {
            ConstantPool.Entry se = this.utf8Signatures.get(e);
            return this.pkg.cp.untypedIndexOf(se);
        }
        return -1;
    }

    void reconstructClass(Package.Class cls) {
        Attribute retroVersion;
        if (this.verbose > 1) {
            Utils.log.fine("reconstruct " + cls);
        }
        if ((retroVersion = cls.getAttribute(this.attrClassFileVersion)) != null) {
            cls.removeAttribute(retroVersion);
            short[] minmajver = this.parseClassFileVersionAttr(retroVersion);
            cls.minver = minmajver[0];
            cls.majver = minmajver[1];
        } else {
            cls.minver = this.pkg.default_class_minver;
            cls.majver = this.pkg.default_class_majver;
        }
        cls.expandSourceFile();
        cls.setCPMap(this.reconstructLocalCPMap(cls));
    }

    ConstantPool.Entry[] reconstructLocalCPMap(Package.Class cls) {
        Set<ConstantPool.Entry> ldcRefs = this.ldcRefMap.get(cls);
        HashSet<ConstantPool.Entry> cpRefs = new HashSet<ConstantPool.Entry>();
        cls.visitRefs(0, cpRefs);
        ConstantPool.completeReferencesIn(cpRefs, true);
        int changed = cls.expandLocalICs();
        if (changed != 0) {
            if (changed > 0) {
                cls.visitInnerClassRefs(0, cpRefs);
            } else {
                cpRefs.clear();
                cls.visitRefs(0, cpRefs);
            }
            ConstantPool.completeReferencesIn(cpRefs, true);
        }
        int numDoubles = 0;
        for (ConstantPool.Entry e : cpRefs) {
            if (e.isDoubleWord()) {
                ++numDoubles;
            }
            assert (e.tag != 13) : e;
        }
        ConstantPool.Entry[] cpMap = new ConstantPool.Entry[1 + numDoubles + cpRefs.size()];
        int fillp = 1;
        if (ldcRefs != null) {
            assert (cpRefs.containsAll(ldcRefs));
            for (ConstantPool.Entry e : ldcRefs) {
                cpMap[fillp++] = e;
            }
            assert (fillp == 1 + ldcRefs.size());
            cpRefs.removeAll(ldcRefs);
            ldcRefs = null;
        }
        HashSet<ConstantPool.Entry> wideRefs = cpRefs;
        cpRefs = null;
        int narrowLimit = fillp;
        for (ConstantPool.Entry e : wideRefs) {
            cpMap[fillp++] = e;
        }
        assert (fillp == narrowLimit + wideRefs.size());
        Arrays.sort(cpMap, 1, narrowLimit, this.entryOutputOrder);
        Arrays.sort(cpMap, narrowLimit, fillp, this.entryOutputOrder);
        if (this.verbose > 3) {
            Utils.log.fine("CP of " + this + " {");
            for (int i = 0; i < fillp; ++i) {
                ConstantPool.Entry e;
                e = cpMap[i];
                Utils.log.fine("  " + (e == null ? -1 : this.getOutputIndex(e)) + " : " + e);
            }
            Utils.log.fine("}");
        }
        int revp = cpMap.length;
        int i = fillp;
        while (--i >= 1) {
            ConstantPool.Entry e = cpMap[i];
            if (e.isDoubleWord()) {
                cpMap[--revp] = null;
            }
            cpMap[--revp] = e;
        }
        assert (revp == 1);
        return cpMap;
    }

    void readMembers(Package.Class[] classes) throws IOException {
        assert (classes.length == this.numClasses);
        this.class_field_count.expectLength(this.numClasses);
        this.class_method_count.expectLength(this.numClasses);
        this.class_field_count.readFrom(this.in);
        this.class_method_count.readFrom(this.in);
        int totalNF = this.class_field_count.getIntTotal();
        int totalNM = this.class_method_count.getIntTotal();
        this.field_descr.expectLength(totalNF);
        this.method_descr.expectLength(totalNM);
        if (this.verbose > 1) {
            Utils.log.fine("expecting #fields=" + totalNF + " and #methods=" + totalNM + " in #classes=" + this.numClasses);
        }
        ArrayList<Package.Class.Field> fields = new ArrayList<Package.Class.Field>(totalNF);
        this.field_descr.readFrom(this.in);
        for (int i = 0; i < classes.length; ++i) {
            Package.Class c = classes[i];
            int nf = this.class_field_count.getInt();
            for (int j = 0; j < nf; ++j) {
                Package.Class clazz = c;
                clazz.getClass();
                Package.Class.Field f = clazz.new Package.Class.Field(0, (ConstantPool.DescriptorEntry)this.field_descr.getRef());
                fields.add(f);
            }
        }
        this.class_field_count.doneDisbursing();
        this.field_descr.doneDisbursing();
        this.countAndReadAttrs(1, fields);
        fields = null;
        ArrayList<Package.Class.Method> methods = new ArrayList<Package.Class.Method>(totalNM);
        this.method_descr.readFrom(this.in);
        for (int i = 0; i < classes.length; ++i) {
            Package.Class c = classes[i];
            int nm = this.class_method_count.getInt();
            for (int j = 0; j < nm; ++j) {
                Package.Class clazz = c;
                clazz.getClass();
                Package.Class.Method m = clazz.new Package.Class.Method(0, (ConstantPool.DescriptorEntry)this.method_descr.getRef());
                methods.add(m);
            }
        }
        this.class_method_count.doneDisbursing();
        this.method_descr.doneDisbursing();
        this.countAndReadAttrs(2, methods);
        this.allCodes = this.buildCodeAttrs(methods);
    }

    Code[] buildCodeAttrs(List<Package.Class.Method> methods) {
        ArrayList<Code> codes = new ArrayList<Code>(methods.size());
        for (Package.Class.Method m : methods) {
            if (m.getAttribute(this.attrCodeEmpty) == null) continue;
            m.code = new Code(m);
            codes.add(m.code);
        }
        Code[] a = new Code[codes.size()];
        codes.toArray(a);
        return a;
    }

    void readCodeHeaders() throws IOException {
        boolean attrsOK = PackageReader.testBit(this.archiveOptions, 4);
        this.code_headers.expectLength(this.allCodes.length);
        this.code_headers.readFrom(this.in);
        ArrayList<Code> longCodes = new ArrayList<Code>(this.allCodes.length / 10);
        for (int i = 0; i < this.allCodes.length; ++i) {
            Code c = this.allCodes[i];
            int sc = this.code_headers.getByte();
            assert (sc == (sc & 0xFF));
            if (this.verbose > 2) {
                Utils.log.fine("codeHeader " + c + " = " + sc);
            }
            if (sc == 0) {
                longCodes.add(c);
                continue;
            }
            c.setMaxStack(PackageReader.shortCodeHeader_max_stack(sc));
            c.setMaxNALocals(PackageReader.shortCodeHeader_max_na_locals(sc));
            c.setHandlerCount(PackageReader.shortCodeHeader_handler_count(sc));
            assert (PackageReader.shortCodeHeader(c) == sc);
        }
        this.code_headers.doneDisbursing();
        this.code_max_stack.expectLength(longCodes.size());
        this.code_max_na_locals.expectLength(longCodes.size());
        this.code_handler_count.expectLength(longCodes.size());
        this.code_max_stack.readFrom(this.in);
        this.code_max_na_locals.readFrom(this.in);
        this.code_handler_count.readFrom(this.in);
        for (Code c : longCodes) {
            c.setMaxStack(this.code_max_stack.getInt());
            c.setMaxNALocals(this.code_max_na_locals.getInt());
            c.setHandlerCount(this.code_handler_count.getInt());
        }
        this.code_max_stack.doneDisbursing();
        this.code_max_na_locals.doneDisbursing();
        this.code_handler_count.doneDisbursing();
        this.readCodeHandlers();
        this.codesWithFlags = attrsOK ? Arrays.asList(this.allCodes) : longCodes;
        this.countAttrs(3, this.codesWithFlags);
    }

    void readCodeHandlers() throws IOException {
        int i;
        int nh = 0;
        for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            Code c = this.allCodes[i2];
            nh += c.getHandlerCount();
        }
        BandStructure.ValueBand[] code_handler_bands = new BandStructure.ValueBand[]{this.code_handler_start_P, this.code_handler_end_PO, this.code_handler_catch_PO, this.code_handler_class_RCN};
        for (i = 0; i < code_handler_bands.length; ++i) {
            code_handler_bands[i].expectLength(nh);
            code_handler_bands[i].readFrom(this.in);
        }
        for (i = 0; i < this.allCodes.length; ++i) {
            Code c = this.allCodes[i];
            int jmax = c.getHandlerCount();
            for (int j = 0; j < jmax; ++j) {
                c.handler_class[j] = this.code_handler_class_RCN.getRef();
                c.handler_start[j] = this.code_handler_start_P.getInt();
                c.handler_end[j] = this.code_handler_end_PO.getInt();
                c.handler_catch[j] = this.code_handler_catch_PO.getInt();
            }
        }
        for (i = 0; i < code_handler_bands.length; ++i) {
            code_handler_bands[i].doneDisbursing();
        }
    }

    void fixupCodeHandlers() {
        for (int i = 0; i < this.allCodes.length; ++i) {
            Code c = this.allCodes[i];
            int jmax = c.getHandlerCount();
            for (int j = 0; j < jmax; ++j) {
                int sum = c.handler_start[j];
                c.handler_start[j] = c.decodeBCI(sum);
                c.handler_end[j] = c.decodeBCI(sum += c.handler_end[j]);
                c.handler_catch[j] = c.decodeBCI(sum += c.handler_catch[j]);
            }
        }
    }

    void countAndReadAttrs(int ctype, Collection holders) throws IOException {
        this.countAttrs(ctype, holders);
        this.readAttrs(ctype, holders);
    }

    void countAttrs(int ctype, Collection holders) throws IOException {
        int j;
        int totalCount;
        Attribute.Layout def;
        int ai;
        BandStructure.MultiBand xxx_attr_bands = this.attrBands[ctype];
        long flagMask = this.attrFlagMask[ctype];
        if (this.verbose > 1) {
            Utils.log.fine("scanning flags and attrs for " + Attribute.contextName(ctype) + "[" + holders.size() + "]");
        }
        List defList = (List)this.attrDefs.get(ctype);
        Attribute.Layout[] defs = new Attribute.Layout[defList.size()];
        defList.toArray(defs);
        BandStructure.IntBand xxx_flags_hi = PackageReader.getAttrBand(xxx_attr_bands, 0);
        BandStructure.IntBand xxx_flags_lo = PackageReader.getAttrBand(xxx_attr_bands, 1);
        BandStructure.IntBand xxx_attr_count = PackageReader.getAttrBand(xxx_attr_bands, 2);
        BandStructure.IntBand xxx_attr_indexes = PackageReader.getAttrBand(xxx_attr_bands, 3);
        BandStructure.IntBand xxx_attr_calls = PackageReader.getAttrBand(xxx_attr_bands, 4);
        int overflowMask = this.attrOverflowMask[ctype];
        int overflowHolderCount = 0;
        boolean haveLongFlags = this.haveFlagsHi(ctype);
        xxx_flags_hi.expectLength(haveLongFlags ? holders.size() : 0);
        xxx_flags_hi.readFrom(this.in);
        xxx_flags_lo.expectLength(holders.size());
        xxx_flags_lo.readFrom(this.in);
        assert ((flagMask & (long)overflowMask) == (long)overflowMask);
        for (Attribute.Holder h : holders) {
            int flags;
            h.flags = flags = xxx_flags_lo.getInt();
            if ((flags & overflowMask) == 0) continue;
            ++overflowHolderCount;
        }
        xxx_attr_count.expectLength(overflowHolderCount);
        xxx_attr_count.readFrom(this.in);
        xxx_attr_indexes.expectLength(xxx_attr_count.getIntTotal());
        xxx_attr_indexes.readFrom(this.in);
        int[] totalCounts = new int[defs.length];
        for (Attribute.Holder h : holders) {
            Attribute canonical;
            assert (h.attributes == null);
            long attrBits = ((long)h.flags & flagMask) << 32 >>> 32;
            h.flags -= (int)attrBits;
            assert (h.flags == (char)h.flags);
            assert (ctype != 3 || h.flags == 0);
            if (haveLongFlags) {
                attrBits += (long)xxx_flags_hi.getInt() << 32;
            }
            if (attrBits == 0L) continue;
            int noa = 0;
            long overflowBit = attrBits & (long)overflowMask;
            assert (overflowBit >= 0L);
            attrBits -= overflowBit;
            if (overflowBit != 0L) {
                noa = xxx_attr_count.getInt();
            }
            int nfa = 0;
            long bits = attrBits;
            int ai2 = 0;
            while (bits != 0L) {
                if ((bits & 1L << ai2) != 0L) {
                    bits -= 1L << ai2;
                    ++nfa;
                }
                ++ai2;
            }
            ArrayList<Attribute> ha = new ArrayList<Attribute>(nfa + noa);
            h.attributes = ha;
            bits = attrBits;
            int ai3 = 0;
            while (bits != 0L) {
                if ((bits & 1L << ai3) != 0L) {
                    bits -= 1L << ai3;
                    int n = ai3;
                    totalCounts[n] = totalCounts[n] + 1;
                    if (defs[ai3] == null) {
                        this.badAttrIndex(ai3, ctype);
                    }
                    canonical = defs[ai3].canonicalInstance();
                    ha.add(canonical);
                    --nfa;
                }
                ++ai3;
            }
            assert (nfa == 0);
            while (noa > 0) {
                int n = ai3 = xxx_attr_indexes.getInt();
                totalCounts[n] = totalCounts[n] + 1;
                if (defs[ai3] == null) {
                    this.badAttrIndex(ai3, ctype);
                }
                canonical = defs[ai3].canonicalInstance();
                ha.add(canonical);
                --noa;
            }
        }
        xxx_flags_hi.doneDisbursing();
        xxx_flags_lo.doneDisbursing();
        xxx_attr_count.doneDisbursing();
        xxx_attr_indexes.doneDisbursing();
        int callCounts = 0;
        boolean predef = true;
        while (true) {
            for (ai = 0; ai < defs.length; ++ai) {
                def = defs[ai];
                if (def == null || predef != this.isPredefinedAttr(ctype, ai) || (totalCount = totalCounts[ai]) == 0) continue;
                Attribute.Layout.Element[] cbles = def.getCallables();
                for (j = 0; j < cbles.length; ++j) {
                    assert (cbles[j].kind == 10);
                    if (!cbles[j].flagTest((byte)8)) continue;
                    ++callCounts;
                }
            }
            if (!predef) break;
            predef = false;
        }
        xxx_attr_calls.expectLength(callCounts);
        xxx_attr_calls.readFrom(this.in);
        predef = true;
        while (true) {
            for (ai = 0; ai < defs.length; ++ai) {
                def = defs[ai];
                if (def == null || predef != this.isPredefinedAttr(ctype, ai)) continue;
                totalCount = totalCounts[ai];
                BandStructure.Band[] ab = (BandStructure.Band[])this.attrBandTable.get(def);
                if (def == this.attrInnerClassesEmpty) {
                    this.class_InnerClasses_N.expectLength(totalCount);
                    this.class_InnerClasses_N.readFrom(this.in);
                    int tupleCount = this.class_InnerClasses_N.getIntTotal();
                    this.class_InnerClasses_RC.expectLength(tupleCount);
                    this.class_InnerClasses_RC.readFrom(this.in);
                    this.class_InnerClasses_F.expectLength(tupleCount);
                    this.class_InnerClasses_F.readFrom(this.in);
                    this.class_InnerClasses_outer_RCN.expectLength(tupleCount -= this.class_InnerClasses_F.getIntCount(0));
                    this.class_InnerClasses_outer_RCN.readFrom(this.in);
                    this.class_InnerClasses_name_RUN.expectLength(tupleCount);
                    this.class_InnerClasses_name_RUN.readFrom(this.in);
                    continue;
                }
                if (totalCount == 0) {
                    for (j = 0; j < ab.length; ++j) {
                        ab[j].doneWithUnusedBand();
                    }
                    continue;
                }
                boolean hasCallables = def.hasCallables();
                if (!hasCallables) {
                    this.readAttrBands(def.elems, totalCount, new int[0], ab);
                    continue;
                }
                Attribute.Layout.Element[] cbles = def.getCallables();
                int[] forwardCounts = new int[cbles.length];
                forwardCounts[0] = totalCount;
                for (int j2 = 0; j2 < cbles.length; ++j2) {
                    assert (cbles[j2].kind == 10);
                    int entryCount = forwardCounts[j2];
                    forwardCounts[j2] = -1;
                    if (cbles[j2].flagTest((byte)8)) {
                        entryCount += xxx_attr_calls.getInt();
                    }
                    this.readAttrBands(cbles[j2].body, entryCount, forwardCounts, ab);
                }
            }
            if (!predef) break;
            predef = false;
        }
        xxx_attr_calls.doneDisbursing();
    }

    void badAttrIndex(int ai, int ctype) throws IOException {
        throw new IOException("Unknown attribute index " + ai + " for " + Constants.ATTR_CONTEXT_NAME[ctype] + " attribute");
    }

    void readAttrs(int ctype, Collection holders) throws IOException {
        HashSet<Attribute.Layout> sawDefs = new HashSet<Attribute.Layout>();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (final Attribute.Holder h : holders) {
            if (h.attributes == null) continue;
            ListIterator<Attribute> j = h.attributes.listIterator();
            while (j.hasNext()) {
                boolean isCV;
                Attribute a = j.next();
                Attribute.Layout def = a.layout();
                if (def.bandCount == 0) {
                    if (def != this.attrInnerClassesEmpty) continue;
                    this.readLocalInnerClasses((Package.Class)h);
                    continue;
                }
                sawDefs.add(def);
                boolean bl = isCV = ctype == 1 && def == this.attrConstantValue;
                if (isCV) {
                    this.setConstantValueIndex((Package.Class.Field)h);
                }
                if (this.verbose > 2) {
                    Utils.log.fine("read " + a + " in " + h);
                }
                final BandStructure.Band[] ab = (BandStructure.Band[])this.attrBandTable.get(def);
                buf.reset();
                Object fixups = a.unparse(new Attribute.ValueStream(){

                    @Override
                    public int getInt(int bandIndex) {
                        return ((BandStructure.IntBand)ab[bandIndex]).getInt();
                    }

                    @Override
                    public ConstantPool.Entry getRef(int bandIndex) {
                        return ((BandStructure.CPRefBand)ab[bandIndex]).getRef();
                    }

                    @Override
                    public int decodeBCI(int bciCode) {
                        Code code = (Code)h;
                        return code.decodeBCI(bciCode);
                    }
                }, buf);
                j.set(a.addContent(buf.toByteArray(), fixups));
                if (!isCV) continue;
                this.setConstantValueIndex(null);
            }
        }
        for (Attribute.Layout def : sawDefs) {
            if (def == null) continue;
            BandStructure.Band[] ab = (BandStructure.Band[])this.attrBandTable.get(def);
            for (int j = 0; j < ab.length; ++j) {
                ab[j].doneDisbursing();
            }
        }
        if (ctype == 0) {
            this.class_InnerClasses_N.doneDisbursing();
            this.class_InnerClasses_RC.doneDisbursing();
            this.class_InnerClasses_F.doneDisbursing();
            this.class_InnerClasses_outer_RCN.doneDisbursing();
            this.class_InnerClasses_name_RUN.doneDisbursing();
        }
        BandStructure.MultiBand xxx_attr_bands = this.attrBands[ctype];
        for (int i = 0; i < xxx_attr_bands.size(); ++i) {
            BandStructure.Band b = xxx_attr_bands.get(i);
            if (!(b instanceof BandStructure.MultiBand)) continue;
            b.doneDisbursing();
        }
        xxx_attr_bands.doneDisbursing();
    }

    private void readAttrBands(Attribute.Layout.Element[] elems, int count, int[] forwardCounts, BandStructure.Band[] ab) throws IOException {
        block6: for (int i = 0; i < elems.length; ++i) {
            Attribute.Layout.Element e = elems[i];
            BandStructure.Band eBand = null;
            if (e.hasBand()) {
                eBand = ab[e.bandIndex];
                eBand.expectLength(count);
                eBand.readFrom(this.in);
            }
            switch (e.kind) {
                case 5: {
                    int repCount = ((BandStructure.IntBand)eBand).getIntTotal();
                    this.readAttrBands(e.body, repCount, forwardCounts, ab);
                    continue block6;
                }
                case 7: {
                    int remainingCount = count;
                    for (int j = 0; j < e.body.length; ++j) {
                        int caseCount;
                        if (j == e.body.length - 1) {
                            caseCount = remainingCount;
                        } else {
                            caseCount = 0;
                            int j0 = j;
                            while (j == j0 || j < e.body.length && e.body[j].flagTest((byte)8)) {
                                caseCount += ((BandStructure.IntBand)eBand).getIntCount(e.body[j].value);
                                ++j;
                            }
                            --j;
                        }
                        remainingCount -= caseCount;
                        this.readAttrBands(e.body[j].body, caseCount, forwardCounts, ab);
                    }
                    assert (remainingCount == 0);
                    continue block6;
                }
                case 9: {
                    assert (e.body.length == 1);
                    assert (e.body[0].kind == 10);
                    if (e.flagTest((byte)8)) continue block6;
                    assert (forwardCounts[e.value] >= 0);
                    int n = e.value;
                    forwardCounts[n] = forwardCounts[n] + count;
                    continue block6;
                }
                case 10: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    void readByteCodes() throws IOException {
        int i;
        this.bc_codes.elementCountForDebug = this.allCodes.length;
        this.bc_codes.setInputStreamFrom(this.in);
        this.readByteCodeOps();
        this.bc_codes.doneDisbursing();
        BandStructure.Band[] operand_bands = new BandStructure.Band[]{this.bc_case_value, this.bc_byte, this.bc_short, this.bc_local, this.bc_label, this.bc_intref, this.bc_floatref, this.bc_longref, this.bc_doubleref, this.bc_stringref, this.bc_classref, this.bc_fieldref, this.bc_methodref, this.bc_imethodref, this.bc_thisfield, this.bc_superfield, this.bc_thismethod, this.bc_supermethod, this.bc_initref, this.bc_escref, this.bc_escrefsize, this.bc_escsize};
        for (i = 0; i < operand_bands.length; ++i) {
            operand_bands[i].readFrom(this.in);
        }
        this.bc_escbyte.expectLength(this.bc_escsize.getIntTotal());
        this.bc_escbyte.readFrom(this.in);
        this.expandByteCodeOps();
        this.bc_case_count.doneDisbursing();
        for (i = 0; i < operand_bands.length; ++i) {
            operand_bands[i].doneDisbursing();
        }
        this.bc_escbyte.doneDisbursing();
        this.bc_bands.doneDisbursing();
        this.readAttrs(3, this.codesWithFlags);
        this.fixupCodeHandlers();
        this.code_bands.doneDisbursing();
        this.class_bands.doneDisbursing();
    }

    private void readByteCodeOps() throws IOException {
        byte[] buf = new byte[4096];
        ArrayList<Integer> allSwitchOps = new ArrayList<Integer>();
        block11: for (int k = 0; k < this.allCodes.length; ++k) {
            Code c = this.allCodes[k];
            int i = 0;
            while (true) {
                int bc = this.bc_codes.getByte();
                if (i + 10 > buf.length) {
                    buf = PackageReader.realloc(buf);
                }
                buf[i] = (byte)bc;
                boolean isWide = false;
                if (bc == 196) {
                    bc = this.bc_codes.getByte();
                    buf[++i] = (byte)bc;
                    isWide = true;
                }
                assert (bc == (0xFF & bc));
                switch (bc) {
                    case 170: 
                    case 171: {
                        this.bc_case_count.expectMoreLength(1);
                        allSwitchOps.add(bc);
                        break;
                    }
                    case 132: {
                        this.bc_local.expectMoreLength(1);
                        if (isWide) {
                            this.bc_short.expectMoreLength(1);
                            break;
                        }
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 17: {
                        this.bc_short.expectMoreLength(1);
                        break;
                    }
                    case 16: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 188: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 197: {
                        assert (this.getCPRefOpBand(bc) == this.bc_classref);
                        this.bc_classref.expectMoreLength(1);
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 253: {
                        this.bc_escrefsize.expectMoreLength(1);
                        this.bc_escref.expectMoreLength(1);
                        break;
                    }
                    case 254: {
                        this.bc_escsize.expectMoreLength(1);
                        break;
                    }
                    default: {
                        BandStructure.CPRefBand bc_which;
                        if (Instruction.isInvokeInitOp(bc)) {
                            this.bc_initref.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isSelfLinkerOp(bc)) {
                            bc_which = this.selfOpRefBand(bc);
                            bc_which.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isBranchOp(bc)) {
                            this.bc_label.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isCPRefOp(bc)) {
                            bc_which = this.getCPRefOpBand(bc);
                            bc_which.expectMoreLength(1);
                            assert (bc != 197);
                            break;
                        }
                        if (!Instruction.isLocalSlotOp(bc)) break;
                        this.bc_local.expectMoreLength(1);
                        break;
                    }
                    case 255: {
                        c.bytes = PackageReader.realloc(buf, i);
                        continue block11;
                    }
                }
                ++i;
            }
        }
        this.bc_case_count.readFrom(this.in);
        for (Integer i : allSwitchOps) {
            int bc = i;
            int caseCount = this.bc_case_count.getInt();
            this.bc_label.expectMoreLength(1 + caseCount);
            this.bc_case_value.expectMoreLength(bc == 170 ? 1 : caseCount);
        }
        this.bc_case_count.resetForSecondPass();
    }

    private void expandByteCodeOps() throws IOException {
        byte[] buf = new byte[4096];
        int[] insnMap = new int[4096];
        int[] labels = new int[1024];
        Fixups fixupBuf = new Fixups();
        for (int k = 0; k < this.allCodes.length; ++k) {
            int curPC;
            Code code = this.allCodes[k];
            byte[] codeOps = code.bytes;
            code.bytes = null;
            Package.Class curClass = code.thisClass();
            Set<ConstantPool.Entry> ldcRefSet = this.ldcRefMap.get(curClass);
            if (ldcRefSet == null) {
                ldcRefSet = new HashSet<ConstantPool.Entry>();
                this.ldcRefMap.put(curClass, ldcRefSet);
            }
            ConstantPool.ClassEntry thisClass = curClass.thisClass;
            ConstantPool.ClassEntry superClass = curClass.superClass;
            ConstantPool.ClassEntry newClass = null;
            int pc = 0;
            int numInsns = 0;
            int numLabels = 0;
            boolean hasEscs = false;
            fixupBuf.clear();
            block27: for (int i = 0; i < codeOps.length; ++i) {
                int bc = Instruction.getByte(codeOps, i);
                curPC = pc;
                insnMap[numInsns++] = curPC;
                if (pc + 10 > buf.length) {
                    buf = PackageReader.realloc(buf);
                }
                if (numInsns + 10 > insnMap.length) {
                    insnMap = PackageReader.realloc(insnMap);
                }
                if (numLabels + 10 > labels.length) {
                    labels = PackageReader.realloc(labels);
                }
                boolean isWide = false;
                if (bc == 196) {
                    buf[pc++] = (byte)bc;
                    bc = Instruction.getByte(codeOps, ++i);
                    isWide = true;
                }
                switch (bc) {
                    case 170: 
                    case 171: {
                        int caseCount = this.bc_case_count.getInt();
                        while (pc + 30 + caseCount * 8 > buf.length) {
                            buf = PackageReader.realloc(buf);
                        }
                        buf[pc++] = (byte)bc;
                        Arrays.fill(buf, pc, pc + 30, (byte)0);
                        Instruction.Switch isw = (Instruction.Switch)Instruction.at(buf, curPC);
                        isw.setCaseCount(caseCount);
                        if (bc == 170) {
                            isw.setCaseValue(0, this.bc_case_value.getInt());
                        } else {
                            for (int j = 0; j < caseCount; ++j) {
                                isw.setCaseValue(j, this.bc_case_value.getInt());
                            }
                        }
                        labels[numLabels++] = curPC;
                        pc = isw.getNextPC();
                        continue block27;
                    }
                    case 132: {
                        buf[pc++] = (byte)bc;
                        int local = this.bc_local.getInt();
                        if (isWide) {
                            int delta = this.bc_short.getInt();
                            Instruction.setShort(buf, pc, local);
                            Instruction.setShort(buf, pc += 2, delta);
                            pc += 2;
                            continue block27;
                        }
                        byte delta = (byte)this.bc_byte.getByte();
                        buf[pc++] = (byte)local;
                        buf[pc++] = delta;
                        continue block27;
                    }
                    case 17: {
                        int val = this.bc_short.getInt();
                        buf[pc++] = (byte)bc;
                        Instruction.setShort(buf, pc, val);
                        pc += 2;
                        continue block27;
                    }
                    case 16: 
                    case 188: {
                        int val = this.bc_byte.getByte();
                        buf[pc++] = (byte)bc;
                        buf[pc++] = (byte)val;
                        continue block27;
                    }
                    case 253: {
                        int fmt;
                        hasEscs = true;
                        int size = this.bc_escrefsize.getInt();
                        ConstantPool.Entry ref = this.bc_escref.getRef();
                        if (size == 1) {
                            ldcRefSet.add(ref);
                        }
                        switch (size) {
                            case 1: {
                                fmt = 1;
                                break;
                            }
                            case 2: {
                                fmt = 0;
                                break;
                            }
                            default: {
                                assert (false);
                                fmt = 0;
                            }
                        }
                        fixupBuf.add(pc, fmt, ref);
                        buf[pc + 1] = 0;
                        buf[pc + 0] = 0;
                        pc += size;
                        continue block27;
                    }
                    case 254: {
                        hasEscs = true;
                        int size = this.bc_escsize.getInt();
                        while (pc + size > buf.length) {
                            buf = PackageReader.realloc(buf);
                        }
                        while (size-- > 0) {
                            buf[pc++] = (byte)this.bc_escbyte.getByte();
                        }
                        continue block27;
                    }
                    default: {
                        if (Instruction.isInvokeInitOp(bc)) {
                            ConstantPool.ClassEntry classRef;
                            int idx = bc - 230;
                            int origBC = 183;
                            switch (idx) {
                                case 0: {
                                    classRef = thisClass;
                                    break;
                                }
                                case 1: {
                                    classRef = superClass;
                                    break;
                                }
                                default: {
                                    assert (idx == 2);
                                    classRef = newClass;
                                }
                            }
                            buf[pc++] = (byte)origBC;
                            int coding = this.bc_initref.getInt();
                            ConstantPool.MemberEntry ref = this.pkg.cp.getOverloadingForIndex((byte)10, classRef, "<init>", coding);
                            fixupBuf.add(pc, 0, ref);
                            buf[pc + 1] = 0;
                            buf[pc + 0] = 0;
                            assert (Instruction.opLength(origBC) == (pc += 2) - curPC);
                            continue block27;
                        }
                        if (Instruction.isSelfLinkerOp(bc)) {
                            ConstantPool.Index which_ix;
                            BandStructure.CPRefBand bc_which;
                            ConstantPool.ClassEntry which_cls;
                            boolean isAload;
                            boolean isSuper;
                            int idx = bc - 202;
                            boolean bl = isSuper = idx >= 14;
                            if (isSuper) {
                                idx -= 14;
                            }
                            boolean bl2 = isAload = idx >= 7;
                            if (isAload) {
                                idx -= 7;
                            }
                            int origBC = 178 + idx;
                            boolean isField = Instruction.isFieldOp(origBC);
                            ConstantPool.ClassEntry classEntry = which_cls = isSuper ? superClass : thisClass;
                            if (isField) {
                                bc_which = isSuper ? this.bc_superfield : this.bc_thisfield;
                                which_ix = this.pkg.cp.getMemberIndex((byte)9, which_cls);
                            } else {
                                bc_which = isSuper ? this.bc_supermethod : this.bc_thismethod;
                                which_ix = this.pkg.cp.getMemberIndex((byte)10, which_cls);
                            }
                            assert (bc_which == this.selfOpRefBand(bc));
                            ConstantPool.MemberEntry ref = (ConstantPool.MemberEntry)bc_which.getRef(which_ix);
                            if (isAload) {
                                buf[pc++] = 42;
                                curPC = pc;
                                insnMap[numInsns++] = curPC;
                            }
                            buf[pc++] = (byte)origBC;
                            fixupBuf.add(pc, 0, ref);
                            buf[pc + 1] = 0;
                            buf[pc + 0] = 0;
                            assert (Instruction.opLength(origBC) == (pc += 2) - curPC);
                            continue block27;
                        }
                        if (Instruction.isBranchOp(bc)) {
                            buf[pc++] = (byte)bc;
                            assert (!isWide);
                            int nextPC = curPC + Instruction.opLength(bc);
                            labels[numLabels++] = curPC;
                            while (pc < nextPC) {
                                buf[pc++] = 0;
                            }
                            continue block27;
                        }
                        if (Instruction.isCPRefOp(bc)) {
                            int fmt;
                            BandStructure.CPRefBand bc_which = this.getCPRefOpBand(bc);
                            ConstantPool.Entry ref = bc_which.getRef();
                            if (ref == null) {
                                if (bc_which == this.bc_classref) {
                                    ref = thisClass;
                                } else assert (false);
                            }
                            int origBC = bc;
                            int size = 2;
                            switch (bc) {
                                case 18: 
                                case 233: 
                                case 234: 
                                case 235: {
                                    origBC = 18;
                                    size = 1;
                                    ldcRefSet.add(ref);
                                    break;
                                }
                                case 19: 
                                case 236: 
                                case 237: 
                                case 238: {
                                    origBC = 19;
                                    break;
                                }
                                case 20: 
                                case 239: {
                                    origBC = 20;
                                    break;
                                }
                                case 187: {
                                    newClass = (ConstantPool.ClassEntry)ref;
                                }
                            }
                            buf[pc++] = (byte)origBC;
                            switch (size) {
                                case 1: {
                                    fmt = 1;
                                    break;
                                }
                                case 2: {
                                    fmt = 0;
                                    break;
                                }
                                default: {
                                    assert (false);
                                    fmt = 0;
                                }
                            }
                            fixupBuf.add(pc, fmt, ref);
                            buf[pc + 1] = 0;
                            buf[pc + 0] = 0;
                            pc += size;
                            if (origBC == 197) {
                                int val = this.bc_byte.getByte();
                                buf[pc++] = (byte)val;
                            } else if (origBC == 185) {
                                int argSize = ((ConstantPool.MemberEntry)ref).descRef.typeRef.computeSize(true);
                                buf[pc++] = (byte)(1 + argSize);
                                buf[pc++] = 0;
                            }
                            assert (Instruction.opLength(origBC) == pc - curPC);
                            continue block27;
                        }
                        if (Instruction.isLocalSlotOp(bc)) {
                            buf[pc++] = (byte)bc;
                            int local = this.bc_local.getInt();
                            if (isWide) {
                                Instruction.setShort(buf, pc, local);
                                pc += 2;
                                if (bc == 132) {
                                    int iVal = this.bc_short.getInt();
                                    Instruction.setShort(buf, pc, iVal);
                                    pc += 2;
                                }
                            } else {
                                Instruction.setByte(buf, pc, local);
                                ++pc;
                                if (bc == 132) {
                                    int iVal = this.bc_byte.getByte();
                                    Instruction.setByte(buf, pc, iVal);
                                    ++pc;
                                }
                            }
                            assert (Instruction.opLength(bc) == pc - curPC);
                            continue block27;
                        }
                        if (bc >= 202) {
                            Utils.log.warning("unrecognized bytescode " + bc + " " + Instruction.byteName(bc));
                        }
                        assert (bc < 202);
                        buf[pc++] = (byte)bc;
                        assert (Instruction.opLength(bc) == pc - curPC);
                        continue block27;
                    }
                }
            }
            code.setBytes(PackageReader.realloc(buf, pc));
            code.setInstructionMap(insnMap, numInsns);
            Instruction ibr = null;
            for (int i = 0; i < numLabels; ++i) {
                curPC = labels[i];
                if ((ibr = Instruction.at(code.bytes, curPC, ibr)) instanceof Instruction.Switch) {
                    Instruction.Switch isw = (Instruction.Switch)ibr;
                    isw.setDefaultLabel(this.getLabel(this.bc_label, code, curPC));
                    int caseCount = isw.getCaseCount();
                    for (int j = 0; j < caseCount; ++j) {
                        isw.setCaseLabel(j, this.getLabel(this.bc_label, code, curPC));
                    }
                    continue;
                }
                ibr.setBranchLabel(this.getLabel(this.bc_label, code, curPC));
            }
            if (fixupBuf.size() <= 0) continue;
            if (this.verbose > 2) {
                Utils.log.fine("Fixups in code: " + fixupBuf);
            }
            code.addFixups(fixupBuf);
        }
    }

    static class LimitedBuffer
    extends BufferedInputStream {
        long served;
        int servedPos;
        long limit;
        long buffered;

        public boolean atLimit() {
            boolean z;
            boolean bl = z = this.getBytesServed() == this.limit;
            assert (!z || this.limit == this.buffered);
            return z;
        }

        public long getBytesServed() {
            return this.served + (long)(this.pos - this.servedPos);
        }

        public void setReadLimit(long newLimit) {
            this.limit = newLimit == -1L ? -1L : this.getBytesServed() + newLimit;
        }

        public long getReadLimit() {
            if (this.limit == -1L) {
                return this.limit;
            }
            return this.limit - this.getBytesServed();
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.count) {
                return this.buf[this.pos++] & 0xFF;
            }
            this.served += (long)(this.pos - this.servedPos);
            int ch = super.read();
            this.servedPos = this.pos;
            if (ch >= 0) {
                ++this.served;
            }
            assert (this.served <= this.limit || this.limit == -1L);
            return ch;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.served += (long)(this.pos - this.servedPos);
            int nr = super.read(b, off, len);
            this.servedPos = this.pos;
            if (nr >= 0) {
                this.served += (long)nr;
            }
            assert (this.served <= this.limit || this.limit == -1L);
            return nr;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new RuntimeException("no skipping");
        }

        LimitedBuffer(InputStream originalIn) {
            super(null, 16384);
            this.servedPos = this.pos;
            this.in = new FilterInputStream(originalIn){

                @Override
                public int read() throws IOException {
                    if (LimitedBuffer.this.buffered == LimitedBuffer.this.limit) {
                        return -1;
                    }
                    ++LimitedBuffer.this.buffered;
                    return super.read();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int nr;
                    long remaining;
                    if (LimitedBuffer.this.buffered == LimitedBuffer.this.limit) {
                        return -1;
                    }
                    if (LimitedBuffer.this.limit != -1L && (long)len > (remaining = LimitedBuffer.this.limit - LimitedBuffer.this.buffered)) {
                        len = (int)remaining;
                    }
                    if ((nr = super.read(b, off, len)) >= 0) {
                        LimitedBuffer.this.buffered += (long)nr;
                    }
                    return nr;
                }
            };
        }
    }
}

