/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractClassDef
extends Viewable {
    private Set targetForRoles = new HashSet(2);

    public void addTargetForRole(RoleDef role) {
        AssociationDef assoc = (AssociationDef)role.getContainer();
        Iterator iter = assoc.getAttributesAndRoles();
        while (iter.hasNext()) {
            RoleDef otherRole;
            Object obj = iter.next();
            if (!(obj instanceof RoleDef) || (otherRole = (RoleDef)obj) == role) continue;
            AbstractClassDef targetClass = otherRole.getDestination();
            Iterator attri = targetClass.getAttributesAndRoles();
            while (attri.hasNext()) {
                Element attrOrRole = (Element)attri.next();
                String attrName = attrOrRole.getName();
                String roleName = role.getName();
                if (!attrOrRole.getName().equals(role.getName())) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", role.getName(), otherRole.getName(), targetClass.getName()));
            }
            Iterator rolei = targetClass.getOpposideRoles();
            while (rolei.hasNext()) {
                RoleDef targetOppRole = (RoleDef)rolei.next();
                if (!targetOppRole.getName().equals(role.getName()) || role.isExtending(targetOppRole)) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", role.getName(), otherRole.getName(), targetClass.getName()));
            }
        }
        this.targetForRoles.add(role);
    }

    public Iterator getDefinedTargetForRoles() {
        return this.targetForRoles.iterator();
    }

    public Iterator getTargetForRoles() {
        LinkedList result = new LinkedList();
        HashMap<RoleDef, RoleDef> mostDerived = new HashMap<RoleDef, RoleDef>();
        AbstractClassDef v = this;
        while (v != null) {
            LinkedList attrsOfV_reversed = new LinkedList();
            Iterator iter = v.targetForRoles.iterator();
            while (iter.hasNext()) {
                RoleDef role;
                Extendable leastDerived = role = (RoleDef)iter.next();
                Extendable leastDerivedParent = null;
                while ((leastDerivedParent = (Extendable)((Object)leastDerived.getRealExtending())) != null) {
                    leastDerived = leastDerivedParent;
                }
                if (!mostDerived.containsKey(leastDerived)) {
                    mostDerived.put((RoleDef)leastDerived, role);
                }
                if (role != leastDerived) continue;
                attrsOfV_reversed.add(0, mostDerived.get(role));
            }
            Iterator attrsOfV_iter = attrsOfV_reversed.iterator();
            while (attrsOfV_iter.hasNext()) {
                result.add(0, attrsOfV_iter.next());
            }
            v = (AbstractClassDef)v.getRealExtending();
        }
        return result.iterator();
    }

    public Iterator getOpposideRoles() {
        LinkedList result = new LinkedList();
        Iterator rolei = this.getTargetForRoles();
        while (rolei.hasNext()) {
            RoleDef role = (RoleDef)rolei.next();
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Object oppRole = iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add(oppRole);
            }
        }
        return result.iterator();
    }

    public RoleDef findOpposideRole(String roleName) {
        if (roleName == null) {
            return null;
        }
        Iterator it = this.getOpposideRoles();
        while (it.hasNext()) {
            RoleDef e = (RoleDef)it.next();
            if (!roleName.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public List getDefinedLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator it = this.getDefinedTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = (RoleDef)it.next();
            if (!e.isAssociationEmbedded()) continue;
            assocv.add(e);
        }
        return assocv;
    }

    public List getLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator it = this.getTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = (RoleDef)it.next();
            if (!e.isAssociationEmbedded()) continue;
            assocv.add(e);
        }
        return assocv;
    }
}

