/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.config;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionConverter {
    private static final Log log = LogFactory.getLog(OptionConverter.class);
    private static final String DELIM_START = "${";
    private static final char DELIM_STOP = '}';
    private static final int DELIM_START_LEN = 2;
    private static final int DELIM_STOP_LEN = 1;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length + stringArray2.length;
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String convertSpecialChars(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 110) {
                    n3 = 10;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 102) {
                    n3 = 12;
                } else if (n3 == 8) {
                    n3 = 8;
                } else if (n3 == 34) {
                    n3 = 34;
                } else if (n3 == 39) {
                    n3 = 39;
                } else if (n3 == 92) {
                    n3 = 92;
                }
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (Throwable throwable) {
            log.debug("Was not allowed to read system property \"" + string + "\".");
            return string2;
        }
    }

    public static <T> T instantiateByKey(Properties properties, String string, T t) {
        String string2 = OptionConverter.findAndSubst(string, properties);
        if (string2 == null) {
            if (log.isTraceEnabled()) {
                log.info("Could not find value for key " + string);
            }
            return t;
        }
        return OptionConverter.instantiateByClassName(string2.trim(), t);
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        String string2 = string.trim();
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public static int toInt(String string, int n) {
        if (string != null) {
            String string2 = string.trim();
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.error("[" + string2 + "] is not in proper int form.");
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }

    public static long toFileSize(String string, long l) {
        if (string == null) {
            return l;
        }
        String string2 = string.trim().toUpperCase();
        long l2 = 1L;
        int n = string2.indexOf("KB");
        if (n != -1) {
            l2 = 1024L;
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf("MB");
            if (n != -1) {
                l2 = 0x100000L;
                string2 = string2.substring(0, n);
            } else {
                n = string2.indexOf("GB");
                if (n != -1) {
                    l2 = 0x40000000L;
                    string2 = string2.substring(0, n);
                }
            }
        }
        if (string2 != null) {
            try {
                return Long.parseLong(string2) * l2;
            }
            catch (NumberFormatException numberFormatException) {
                log.error("[" + string2 + "] is not in proper int form");
                log.error("[" + string + "] not in expected format", numberFormatException);
            }
        }
        return l;
    }

    public static String findAndSubst(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(string2, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Bad option value [" + string2 + "]", illegalArgumentException);
            return string2;
        }
    }

    public static <T> T instantiateByClassName(String string, T t) {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                try {
                    Object obj2 = obj;
                    return (T)obj2;
                }
                catch (ClassCastException classCastException) {
                    log.error("A \"" + string + "\" object is not assignable to the generic variable.");
                    return t;
                }
            }
            catch (Exception exception) {
                log.error("Could not instantiate class [" + string + "]", exception);
            }
        }
        return t;
    }

    public static String substVars(String string, Properties properties) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(DELIM_START, n)) == -1) {
                if (n == 0) {
                    return string;
                }
                stringBuilder.append(string.substring(n, string.length()));
                return stringBuilder.toString();
            }
            stringBuilder.append(string.substring(n, n2));
            int n3 = string.indexOf(125, n2);
            if (n3 == -1) {
                throw new IllegalArgumentException('\"' + string + "\" has no closing brace. Opening brace at position " + n2 + '.');
            }
            String string2 = string.substring(n2 += 2, n3);
            String string3 = OptionConverter.getSystemProperty(string2, null);
            if (string3 == null && properties != null) {
                string3 = properties.getProperty(string2);
            }
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            n = n3 + 1;
        }
    }
}

