/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import org.jruby.truffle.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.literal.IntegerFixnumLiteralNode;

public abstract class PrimitiveArrayNodeFactory {
    public static RubyNode read(RubyNode array, int index) {
        IntegerFixnumLiteralNode literalIndex = new IntegerFixnumLiteralNode(index);
        if (index >= 0) {
            return ArrayReadNormalizedNodeGen.create(array, literalIndex);
        }
        return ArrayReadDenormalizedNodeGen.create(array, literalIndex);
    }

    public static RubyNode readSlice(RubyNode array, int start, int exclusiveEnd) {
        IntegerFixnumLiteralNode literalStart = new IntegerFixnumLiteralNode(start);
        IntegerFixnumLiteralNode literalExclusiveEnd = new IntegerFixnumLiteralNode(exclusiveEnd);
        if (start >= 0 && exclusiveEnd >= 0) {
            return ArrayReadSliceNormalizedNodeGen.create(array, literalStart, literalExclusiveEnd);
        }
        return ArrayReadSliceDenormalizedNodeGen.create(array, literalStart, literalExclusiveEnd);
    }
}

