/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;

public class CbScrollbar
extends Panel {
    static final int VERTICAL = 0;
    static final int HORIZONTAL = 1;
    CbScrollbarCallback callback;
    boolean inside;
    boolean indent;
    int orient;
    int value;
    int lvisible;
    int num;
    int lineinc = 1;
    Color lc1 = Util.light_edge;
    Color lc2 = Util.body;
    Color lc3 = Util.dark_edge;
    Color hc1 = Util.light_edge_hi;
    Color hc2 = Util.body_hi;
    Color hc3 = Util.dark_edge_hi;
    Color bc = Util.dark_bg;
    int y1;
    int y2;
    int x1;
    int x2;
    int drag;
    CbScrollbarArrow arrow1;
    CbScrollbarArrow arrow2;

    CbScrollbar(int n, CbScrollbarCallback cbScrollbarCallback) {
        this(n, 0, 1, 1, cbScrollbarCallback);
    }

    CbScrollbar(int n, int n2, int n3, int n4, CbScrollbarCallback cbScrollbarCallback) {
        this.setValues(n2, n3, n4);
        this.orient = n;
        this.callback = cbScrollbarCallback;
        this.setLayout(null);
        if (this.orient == 0) {
            this.arrow1 = new CbScrollbarArrow(this, 0);
            this.add(this.arrow1);
            this.arrow2 = new CbScrollbarArrow(this, 1);
            this.add(this.arrow2);
        } else {
            this.arrow1 = new CbScrollbarArrow(this, 2);
            this.add(this.arrow1);
            this.arrow2 = new CbScrollbarArrow(this, 3);
            this.add(this.arrow2);
        }
    }

    public void setValues(int n, int n2, int n3) {
        this.value = n;
        this.lvisible = n2;
        this.num = n3;
        if (this.lvisible > this.num) {
            this.lvisible = this.num;
        }
        this.checkValue();
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        this.checkValue();
        this.repaint();
    }

    private void checkValue() {
        if (this.value < 0) {
            this.value = 0;
        } else if (this.value > this.num - this.lvisible) {
            this.value = this.num - this.lvisible;
        }
    }

    public void paint(Graphics graphics) {
        if (this.num == 0) {
            return;
        }
        int n = this.size().width;
        int n2 = this.size().height;
        boolean bl = this.inside && !this.arrow1.inside && !this.arrow2.inside;
        Color color = bl ? this.hc1 : this.lc1;
        Color color2 = bl ? this.hc2 : this.lc2;
        Color color3 = bl ? this.hc3 : this.lc3;
        graphics.setColor(this.bc);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color3);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.setColor(color);
        graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        graphics.drawLine(n - 1, n2 - 1, 0, n2 - 1);
        if (this.orient == 0) {
            int n3 = n2 - n * 2;
            this.y1 = n + n3 * this.value / this.num;
            this.y2 = n + n3 * (this.value + this.lvisible) / this.num - 1;
            graphics.setColor(color2);
            graphics.fillRect(1, this.y1, n - 2, this.y2 - this.y1);
            graphics.setColor(this.indent ? color3 : color);
            graphics.drawLine(1, this.y1, n - 2, this.y1);
            graphics.drawLine(1, this.y1, 1, this.y2 - 1);
            graphics.setColor(this.indent ? color : color3);
            graphics.drawLine(n - 2, this.y2 - 1, n - 2, this.y1);
            graphics.drawLine(n - 2, this.y2 - 1, 1, this.y2 - 1);
            if (bl) {
                graphics.drawLine(n - 3, this.y2 - 2, n - 3, this.y1 + 1);
                graphics.drawLine(n - 3, this.y2 - 2, 2, this.y2 - 2);
            }
        } else if (this.orient == 1) {
            int n4 = n - n2 * 2;
            this.x1 = n2 + n4 * this.value / this.num;
            this.x2 = n2 + n4 * (this.value + this.lvisible) / this.num - 1;
            graphics.setColor(color2);
            graphics.fillRect(this.x1, 1, this.x2 - this.x1, n2 - 2);
            graphics.setColor(this.indent ? color3 : color);
            graphics.drawLine(this.x1, 1, this.x1, n2 - 2);
            graphics.drawLine(this.x1, 1, this.x2 - 1, 1);
            graphics.setColor(this.indent ? color : color3);
            graphics.drawLine(this.x2 - 1, n2 - 2, this.x1, n2 - 2);
            graphics.drawLine(this.x2 - 1, n2 - 2, this.x2 - 1, 1);
            if (bl) {
                graphics.drawLine(this.x2 - 2, n2 - 3, this.x1 + 1, n2 - 3);
                graphics.drawLine(this.x2 - 2, n2 - 3, this.x2 - 2, 2);
            }
        }
    }

    void arrowClick(int n) {
        int n2 = this.value;
        this.value += n;
        this.checkValue();
        if (this.value != n2) {
            this.callback.moved(this, this.value);
            this.repaint();
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.orient == 0) {
            this.arrow1.reshape(1, 1, n3 - 2, n3 - 1);
            this.arrow2.reshape(1, n4 - n3 - 1, n3 - 2, n3 - 1);
        } else {
            this.arrow1.reshape(1, 1, n4 - 1, n4 - 2);
            this.arrow2.reshape(n3 - n4 - 1, 1, n4 - 1, n4 - 2);
        }
        this.repaint();
    }

    public Dimension preferredSize() {
        return this.orient == 0 ? new Dimension(16, 100) : new Dimension(100, 16);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.orient == 0) {
            if (n2 < this.y1) {
                this.arrowClick(-this.lvisible);
            } else if (n2 > this.y2) {
                this.arrowClick(this.lvisible);
            } else {
                this.indent = true;
                this.drag = n2 - this.y1;
                this.repaint();
            }
        } else if (n < this.x1) {
            this.arrowClick(-this.lvisible);
        } else if (n > this.x2) {
            this.arrowClick(this.lvisible);
        } else {
            this.indent = true;
            this.drag = n - this.x1;
            this.repaint();
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.indent) {
            int n3 = this.size().width;
            int n4 = this.size().height;
            int n5 = this.value;
            if (this.orient == 0) {
                int n6 = n4 - n3 * 2;
                int n7 = n2 - this.drag - n3;
                this.value = n7 * this.num / n6;
            } else {
                int n8 = n3 - n4 * 2;
                int n9 = n - this.drag - n4;
                this.value = n9 * this.num / n8;
            }
            this.checkValue();
            if (this.value != n5) {
                this.callback.moving(this, this.value);
                this.repaint();
            }
        }
        return this.indent;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.indent) {
            this.indent = false;
            this.repaint();
            this.callback.moved(this, this.value);
            return true;
        }
        return false;
    }
}

