#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: ghc-mod
version: 5.7.0.0
id: ghc-mod-5.7.0.0-1LISJeEpaxOE140Rl1pfGN
key: ghc-mod-5.7.0.0-1LISJeEpaxOE140Rl1pfGN
license: AGPL-3
maintainer: Daniel Gröber <dxld@darkboxed.org>
homepage: http://www.mew.org/~kazu/proj/ghc-mod/
synopsis: Happy Haskell Programming
description:
    ghc-mod is a backend program to enrich Haskell programming in editors. It
    strives to offer most of the features one has come to expect from modern IDEs
    in any editor.
    ghc-mod provides a library for other haskell programs to use as well as a
    standalone program for easy editor integration. All of the fundamental
    functionality of the frontend program can be accessed through the library
    however many implementation details are hidden and if you want to
    significantly extend ghc-mod you should submit these changes upstream instead
    of implementing them on top of the library.
    For more information, please see its home page.
category: GHC, Development
author: Kazu Yamamoto <kazu@iij.ad.jp>,
        Daniel Gröber <dxld@darkboxed.org>,
        Alejandro Serrano <trupill@gmail.com>,
        Nikolay Yakimov <root@livid.pp.ru>
exposed: True
exposed-modules:
    Language.Haskell.GhcMod Language.Haskell.GhcMod.Internal
    Language.Haskell.GhcMod.Boot Language.Haskell.GhcMod.Browse
    Language.Haskell.GhcMod.CabalHelper Language.Haskell.GhcMod.Caching
    Language.Haskell.GhcMod.Caching.Types
    Language.Haskell.GhcMod.CaseSplit Language.Haskell.GhcMod.Check
    Language.Haskell.GhcMod.Convert Language.Haskell.GhcMod.Cradle
    Language.Haskell.GhcMod.CustomPackageDb
    Language.Haskell.GhcMod.Debug Language.Haskell.GhcMod.DebugLogger
    Language.Haskell.GhcMod.Doc Language.Haskell.GhcMod.DynFlags
    Language.Haskell.GhcMod.DynFlagsTH Language.Haskell.GhcMod.Error
    Language.Haskell.GhcMod.FileMapping Language.Haskell.GhcMod.FillSig
    Language.Haskell.GhcMod.Find Language.Haskell.GhcMod.Flag
    Language.Haskell.GhcMod.Gap Language.Haskell.GhcMod.GhcPkg
    Language.Haskell.GhcMod.HomeModuleGraph
    Language.Haskell.GhcMod.Info Language.Haskell.GhcMod.Lang
    Language.Haskell.GhcMod.Lint Language.Haskell.GhcMod.LightGhc
    Language.Haskell.GhcMod.Logger Language.Haskell.GhcMod.Logging
    Language.Haskell.GhcMod.Modules Language.Haskell.GhcMod.Monad
    Language.Haskell.GhcMod.Monad.Env Language.Haskell.GhcMod.Monad.Log
    Language.Haskell.GhcMod.Monad.Newtypes
    Language.Haskell.GhcMod.Monad.Orphans
    Language.Haskell.GhcMod.Monad.Out
    Language.Haskell.GhcMod.Monad.State
    Language.Haskell.GhcMod.Monad.Types Language.Haskell.GhcMod.Output
    Language.Haskell.GhcMod.PathsAndFiles
    Language.Haskell.GhcMod.PkgDoc Language.Haskell.GhcMod.Pretty
    Language.Haskell.GhcMod.Read Language.Haskell.GhcMod.SrcUtils
    Language.Haskell.GhcMod.Stack Language.Haskell.GhcMod.Target
    Language.Haskell.GhcMod.Test Language.Haskell.GhcMod.Types
    Language.Haskell.GhcMod.Utils Language.Haskell.GhcMod.World
    Language.Haskell.GhcMod.Options.Options
    Language.Haskell.GhcMod.Options.DocUtils
    Language.Haskell.GhcMod.Options.Help
hidden-modules: Paths_ghc_mod Utils Data.Binary.Generic
                System.Directory.ModTime
abi: acac7d49053ea612807d60cb58185be4
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/ghc-mod-5.7.0.0
library-dirs: /usr/lib/ghc-8.0.1/site-local/ghc-mod-5.7.0.0
data-dir: /usr/share/ghc-mod
hs-libraries: HSghc-mod-5.7.0.0-1LISJeEpaxOE140Rl1pfGN
depends:
    base-4.9.0.0 binary-0.8.3.0 bytestring-0.10.8.1
    cabal-helper-0.7.3.0-8irtsA9yeTTAn5BCqOpvck containers-0.5.7.1
    deepseq-1.4.2.0 directory-1.2.6.2
    djinn-ghc-0.0.2.3-8MQ0xwYN51z9HjHjeyXGaC
    extra-1.5.1-HeeVckCVl1V9DE6lYqg83I
    fclabels-2.0.3.2-3Xs3bCBbAC9J1XqCJSoYEp filepath-1.4.1.0 ghc-8.0.1
    ghc-boot-8.0.1 ghc-paths-0.1.0.9-GIOnKzk0HmEBZ77Q1HsThK
    ghc-syb-utils-0.2.3-8FwTENlrnJNLAYazvnOvfZ
    haskell-src-exts-1.18.2-HRhMMqwyV4YAPJcOMs1zba
    hlint-1.9.40-7SDAOO3xJK8EP5OwIg3q2A
    monad-control-1.0.1.0-CVvkY5Vr2NNGCNJRXug3iR
    monad-journal-0.7.2-Cv21fCiS3Tt1lbKPFn5Qbh
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    old-time-1.1.0.3-IcvdkJUsE9M8t3io8peAEp
    optparse-applicative-0.13.0.0-IErSQpKP3j4oJy1jHSvi1
    pipes-4.3.2-LsUxl7vdJuRKCI34rrjNBO pretty-1.1.3.3 process-1.4.2.0
    safe-0.3.12-AllanCJRaxaAIEhwGWDhwA
    split-0.2.3.1-IJKK4pOCYGKud0jZImZke syb-0.6-C65vWCsht6A8uLstpQIXyj
    template-haskell-2.11.0.0 temporary-1.2.0.4-2ZGJgvUMoC3CqxertnjRxn
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0 transformers-base-0.4.4-LWS58Nywv1PJoy1IFDbvS4
haddock-interfaces: /usr/share/doc/ghc-mod/html/ghc-mod.haddock
haddock-html: /usr/share/doc/ghc-mod/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
