#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: nonce
version: 1.0.2
id: nonce-1.0.2-4gb8xlcKamM1DkznzNkyYS
key: nonce-1.0.2-4gb8xlcKamM1DkznzNkyYS
license: BSD3
copyright: (c) 2014 Prowdsponsor
maintainer: Prowdsponsor <opensource@prowdsponsor.com>
homepage: https://github.com/prowdsponsor/nonce
synopsis: Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.
    .
    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.
category: Cryptography
author: Felipe Lessa <felipe.lessa@prowdsponsor.com>
exposed: True
exposed-modules:
    Crypto.Nonce
abi: 80025e837f8970183de2777c4c8a4885
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/nonce-1.0.2
library-dirs: /usr/lib/ghc-8.0.1/site-local/nonce-1.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.1/nonce-1.0.2
hs-libraries: HSnonce-1.0.2-4gb8xlcKamM1DkznzNkyYS
depends:
    base-4.9.0.0 base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY
    bytestring-0.10.8.1 cprng-aes-0.6.1-ElzXuMli7WyAHsEinA5oq
    crypto-random-0.0.9-JOU8lue6KbLEq1yW10dkyV
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ transformers-0.5.2.0
haddock-interfaces: /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html: /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
