/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.M4;
import javajs.util.P3i;
import javajs.util.SB;
import org.jmol.symmetry.HallInfo;
import org.jmol.symmetry.HallRotation;
import org.jmol.symmetry.HallTranslation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;

class HallRotationTerm {
    String inputCode;
    String primitiveCode;
    String lookupCode;
    String translationString;
    HallRotation rotation;
    HallTranslation translation;
    M4 seitzMatrix12ths = new M4();
    boolean isImproper;
    int order;
    char axisType = '\u0000';
    char diagonalReferenceAxis = '\u0000';
    boolean allPositive = true;

    HallRotationTerm(HallInfo hallInfo, String code, int prevOrder, char prevAxisType) {
        this.inputCode = code;
        code = code + "   ";
        if (code.charAt(0) == '-') {
            this.isImproper = true;
            code = code.substring(1);
        }
        this.primitiveCode = "";
        this.order = code.charAt(0) - 48;
        this.diagonalReferenceAxis = '\u0000';
        this.axisType = '\u0000';
        int ptr = 2;
        char c = code.charAt(1);
        block0 : switch (c) {
            case 'x': 
            case 'y': 
            case 'z': {
                switch (code.charAt(2)) {
                    case '\"': 
                    case '\'': {
                        this.diagonalReferenceAxis = c;
                        c = code.charAt(2);
                        ++ptr;
                    }
                }
            }
            case '*': {
                this.axisType = c;
                break;
            }
            case '\"': 
            case '\'': {
                this.axisType = c;
                switch (code.charAt(2)) {
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.diagonalReferenceAxis = code.charAt(2);
                        ++ptr;
                        break block0;
                    }
                }
                this.diagonalReferenceAxis = prevAxisType;
                break;
            }
            default: {
                this.axisType = (char)(this.order == 1 ? 95 : (hallInfo.nRotations == 0 ? 122 : (hallInfo.nRotations == 2 ? 42 : (prevOrder == 2 || prevOrder == 4 ? 120 : 39))));
                code = code.substring(0, 1) + this.axisType + code.substring(1);
            }
        }
        this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : code.substring(0, 2));
        if (this.diagonalReferenceAxis != '\u0000') {
            code = code.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + code.substring(ptr);
            this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
            ptr = 3;
        }
        this.lookupCode = code.substring(0, ptr);
        this.rotation = HallRotation.lookup(this.lookupCode);
        if (this.rotation == null) {
            Logger.error("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode);
            return;
        }
        this.translation = new HallTranslation('\u0000', null);
        this.translationString = "";
        int len = code.length();
        for (int i = ptr; i < len; ++i) {
            char translationCode = code.charAt(i);
            HallTranslation t = HallTranslation.getHallTranslation(translationCode, this.order);
            if (t == null) continue;
            this.translationString = this.translationString + "" + t.translationCode;
            this.translation.rotationShift12ths += t.rotationShift12ths;
            this.translation.vectorShift12ths.add(t.vectorShift12ths);
        }
        this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
        this.seitzMatrix12ths.setM4(this.isImproper ? this.rotation.seitzMatrixInv : this.rotation.seitzMatrix);
        this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
        this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
        this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
        switch (this.axisType) {
            case 'x': {
                this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'y': {
                this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                break;
            }
            case 'z': {
                this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
            }
        }
        if (hallInfo.vectorCode.length() > 0) {
            M4 m1 = M4.newM4(null);
            M4 m2 = M4.newM4(null);
            P3i v = hallInfo.vector12ths;
            m1.m03 = v.x;
            m1.m13 = v.y;
            m1.m23 = v.z;
            m2.m03 = -v.x;
            m2.m13 = -v.y;
            m2.m23 = -v.z;
            this.seitzMatrix12ths.mul2(m1, this.seitzMatrix12ths);
            this.seitzMatrix12ths.mul(m2);
        }
        if (Logger.debugging) {
            Logger.debug("code = " + code + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths);
        }
    }

    String dumpInfo(String vectorCode) {
        SB sb = new SB();
        sb.append("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").appendI(this.order).append(this.isImproper ? " (improper axis)" : "");
        if (this.axisType != '_') {
            sb.append("; axisType: ").appendC(this.axisType);
            if (this.diagonalReferenceAxis != '\u0000') {
                sb.appendC(this.diagonalReferenceAxis);
            }
        }
        if (this.translationString.length() > 0) {
            sb.append("; translation: ").append(this.translationString);
        }
        if (vectorCode.length() > 0) {
            sb.append("; vector offset: ").append(vectorCode);
        }
        if (this.rotation != null) {
            sb.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths, false));
        }
        return sb.toString();
    }

    String getXYZ(boolean allPositive) {
        return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, true, allPositive, true);
    }
}

