/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class JpegSegmentData {
    @NotNull
    private final HashMap<Byte, List<byte[]>> _segmentDataMap = new HashMap(10);

    public void addSegment(byte by, @NotNull byte[] byArray) {
        this.getOrCreateSegmentList(by).add(byArray);
    }

    public Iterable<JpegSegmentType> getSegmentTypes() {
        HashSet<JpegSegmentType> hashSet = new HashSet<JpegSegmentType>();
        for (Byte by : this._segmentDataMap.keySet()) {
            JpegSegmentType jpegSegmentType = JpegSegmentType.fromByte(by);
            if (jpegSegmentType == null) {
                throw new IllegalStateException("Should not have a segmentTypeByte that is not in the enum: " + Integer.toHexString(by.byteValue()));
            }
            hashSet.add(jpegSegmentType);
        }
        return hashSet;
    }

    @Nullable
    public byte[] getSegment(byte by) {
        return this.getSegment(by, 0);
    }

    @Nullable
    public byte[] getSegment(@NotNull JpegSegmentType jpegSegmentType) {
        return this.getSegment(jpegSegmentType.byteValue, 0);
    }

    @Nullable
    public byte[] getSegment(@NotNull JpegSegmentType jpegSegmentType, int n) {
        return this.getSegment(jpegSegmentType.byteValue, n);
    }

    @Nullable
    public byte[] getSegment(byte by, int n) {
        List<byte[]> list = this.getSegmentList(by);
        return list != null && list.size() > n ? list.get(n) : null;
    }

    @NotNull
    public Iterable<byte[]> getSegments(@NotNull JpegSegmentType jpegSegmentType) {
        return this.getSegments(jpegSegmentType.byteValue);
    }

    @NotNull
    public Iterable<byte[]> getSegments(byte by) {
        ArrayList arrayList = this.getSegmentList(by);
        return arrayList == null ? new ArrayList() : arrayList;
    }

    @Nullable
    private List<byte[]> getSegmentList(byte by) {
        return this._segmentDataMap.get(by);
    }

    @NotNull
    private List<byte[]> getOrCreateSegmentList(byte by) {
        ArrayList<byte[]> arrayList;
        if (this._segmentDataMap.containsKey(by)) {
            arrayList = this._segmentDataMap.get(by);
        } else {
            arrayList = new ArrayList();
            this._segmentDataMap.put(by, arrayList);
        }
        return arrayList;
    }

    public int getSegmentCount(@NotNull JpegSegmentType jpegSegmentType) {
        return this.getSegmentCount(jpegSegmentType.byteValue);
    }

    public int getSegmentCount(byte by) {
        List<byte[]> list = this.getSegmentList(by);
        return list == null ? 0 : list.size();
    }

    public void removeSegmentOccurrence(@NotNull JpegSegmentType jpegSegmentType, int n) {
        this.removeSegmentOccurrence(jpegSegmentType.byteValue, n);
    }

    public void removeSegmentOccurrence(byte by, int n) {
        List<byte[]> list = this._segmentDataMap.get(by);
        list.remove(n);
    }

    public void removeSegment(@NotNull JpegSegmentType jpegSegmentType) {
        this.removeSegment(jpegSegmentType.byteValue);
    }

    public void removeSegment(byte by) {
        this._segmentDataMap.remove(by);
    }

    public boolean containsSegment(@NotNull JpegSegmentType jpegSegmentType) {
        return this.containsSegment(jpegSegmentType.byteValue);
    }

    public boolean containsSegment(byte by) {
        return this._segmentDataMap.containsKey(by);
    }
}

