/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap<V> {
    private Entry<V>[] table;
    private int count;
    volatile transient Set<Integer> keySet = null;
    volatile transient Collection<V> values = null;
    private int threshold;
    private final float loadFactor;
    private transient Set<Entry<V>> entrySet = null;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.table = new Entry[initialCapacity];
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<V> e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(int key) {
        Entry<V>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(int key) {
        Entry<V>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldMap[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    Entry<V> getEntry(int key) {
        Entry<V>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public V put(int key, V value) {
        Entry<V>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.hash == hash) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry<V>(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public V remove(int key) {
        Entry<V>[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        Entry<V> prev = null;
        while (e != null) {
            if (e.hash == hash) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    Iterator<Integer> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    public Set<Integer> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Entry<V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public String toString() {
        Iterator<Entry<V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Entry<V> e = i.next();
            V value = e.getValue();
            sb.append(e.getKey());
            sb.append('=');
            sb.append((Object)(value == this ? "(this IntHashMap)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public Object clone() {
        IntHashMap<V> newMap = new IntHashMap<V>(this.table.length, this.loadFactor);
        for (int i = 0; i < this.table.length; ++i) {
            Entry<V> entry = this.table[i];
            while (entry != null) {
                newMap.put(entry.getKey(), entry.getValue());
                entry = entry.next;
            }
        }
        return newMap;
    }

    public static <U> IntHashMap<U> nullMap() {
        return NullMap.INSTANCE;
    }

    private static final class NullMap<U>
    extends IntHashMap<U> {
        static final NullMap INSTANCE = new NullMap();

        private NullMap() {
            super(0);
        }

        @Override
        public boolean contains(Object value) {
            return false;
        }

        @Override
        public boolean containsKey(int key) {
            return false;
        }

        @Override
        public U get(int key) {
            return null;
        }

        @Override
        public U put(int key, U value) {
            return null;
        }

        @Override
        public U remove(int key) {
            return null;
        }

        @Override
        protected void rehash() {
        }
    }

    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return IntHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntHashMap.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return IntHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return IntHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return IntHashMap.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        Entry<V> next;
        int index;

        HashIterator() {
            Entry[] t = IntHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (IntHashMap.this.count != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = IntHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry<V> {
        final int hash;
        final int key;
        V value;
        Entry<V> next;

        protected Entry(int hash, int key, V value, Entry<V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

