/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.collections.WeakValuedMap;
import org.jruby.truffle.core.regexp.RegexpOptions;
import org.jruby.truffle.core.regexp.RegexpSupport;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.ByteListKey;
import org.jruby.truffle.core.string.StringSupport;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.parser.ReOptions;

public class ClassicRegexp
implements ReOptions {
    private final RubyContext context;
    private Regex pattern;
    private Rope str = RopeConstants.EMPTY_UTF8_ROPE;
    private RegexpOptions options;
    static final WeakValuedMap<ByteListKey, Regex> patternCache = new WeakValuedMap();
    private static final int QUOTED_V = 11;

    public void setLiteral() {
        this.options.setLiteral(true);
    }

    public boolean isLiteral() {
        return this.options.isLiteral();
    }

    public void setEncodingNone() {
        this.options.setEncodingNone(true);
    }

    public Encoding getEncoding() {
        return this.pattern.getEncoding();
    }

    public void setEncoding(Encoding encoding) {
    }

    private static Regex makeRegexp(RubyContext runtime, ByteList bytes, RegexpOptions options, Encoding enc) {
        try {
            int p = bytes.getBegin();
            return new Regex(bytes.getUnsafeBytes(), p, p + bytes.getRealSize(), options.toJoniOptions(), enc, Syntax.DEFAULT, new WarnCallback(){

                @Override
                public void warn(String s) {
                }
            });
        }
        catch (Exception e) {
            throw new RaiseException(runtime.getCoreExceptions().regexpError(e.getMessage(), null));
        }
    }

    static Regex getRegexpFromCache(RubyContext runtime, ByteList bytes, Encoding enc, RegexpOptions options) {
        ByteListKey key = new ByteListKey(bytes);
        Regex regex = patternCache.get(key);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options.toJoniOptions()) {
            return regex;
        }
        regex = ClassicRegexp.makeRegexp(runtime, bytes, options, enc);
        regex.setUserObject(bytes);
        patternCache.put(key, regex);
        return regex;
    }

    public static int matcherSearch(Matcher matcher, int start, int range, int option) {
        try {
            SearchMatchTask task = new SearchMatchTask(start, range, option, false);
            return task.run(null, matcher);
        }
        catch (InterruptedException e) {
            throw new UnsupportedOperationException();
        }
    }

    ClassicRegexp(RubyContext context) {
        this.context = context;
        this.options = new RegexpOptions();
    }

    private ClassicRegexp(RubyContext context, Rope str, RegexpOptions options) {
        this(context);
        str.getClass();
        this.regexpInitialize(str, str.getEncoding(), options);
    }

    public static ClassicRegexp newRegexp(RubyContext runtime, Rope pattern, int options) {
        return ClassicRegexp.newRegexp(runtime, pattern, RegexpOptions.fromEmbeddedOptions(options));
    }

    public static ClassicRegexp newRegexp(RubyContext runtime, Rope pattern, RegexpOptions options) {
        return new ClassicRegexp(runtime, pattern, (RegexpOptions)options.clone());
    }

    public static ClassicRegexp newRegexpParser(RubyContext runtime, Rope pattern, RegexpOptions options) {
        return new ClassicRegexp(runtime, pattern, (RegexpOptions)options.clone());
    }

    private static void preprocessLight(RubyContext context, Rope str, Encoding enc, Encoding[] fixedEnc, RegexpSupport.ErrorMode mode) {
        fixedEnc[0] = enc.isAsciiCompatible() ? null : enc;
        boolean hasProperty = ClassicRegexp.unescapeNonAscii(context, null, str.getBytes(), 0, str.byteLength(), enc, fixedEnc, str, mode);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
    }

    public static boolean unescapeNonAscii(RubyContext context, ByteList to, byte[] bytes, int p, int end, Encoding enc, Encoding[] encp, Rope str, RegexpSupport.ErrorMode mode) {
        boolean hasProperty = false;
        byte[] buf = null;
        block9: while (p < end) {
            int cl = StringSupport.preciseLength(enc, bytes, p, end);
            if (cl <= 0) {
                ClassicRegexp.raisePreprocessError(context, str, "invalid multibyte character", mode);
            }
            if (cl > 1 || (bytes[p] & 0x80) != 0) {
                if (to != null) {
                    to.append(bytes, p, cl);
                }
                p += cl;
                if (encp[0] == null) {
                    encp[0] = enc;
                    continue;
                }
                if (encp[0] == enc) continue;
                ClassicRegexp.raisePreprocessError(context, str, "non ASCII character in UTF-8 regexp", mode);
                continue;
            }
            int c = bytes[p++] & 0xFF;
            switch (c) {
                case 92: {
                    if (p == end) {
                        ClassicRegexp.raisePreprocessError(context, str, "too short escape sequence", mode);
                    }
                    c = bytes[p++] & 0xFF;
                    switch (c) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (StringSupport.scanOct(bytes, p - 1, end - (p - 1)) <= 127) {
                                if (to == null) continue block9;
                                to.append(92).append(c);
                                break;
                            }
                        }
                        case 48: 
                        case 67: 
                        case 77: 
                        case 99: 
                        case 120: {
                            p -= 2;
                            if (enc == USASCIIEncoding.INSTANCE) {
                                if (buf == null) {
                                    buf = new byte[1];
                                }
                                int pbeg = p;
                                p = ClassicRegexp.readEscapedByte(context, buf, 0, bytes, p, end, str, mode);
                                c = buf[0];
                                if (c == 65535) {
                                    return false;
                                }
                                if (to == null) continue block9;
                                to.append(bytes, pbeg, p - pbeg);
                                break;
                            }
                            p = ClassicRegexp.unescapeEscapedNonAscii(context, to, bytes, p, end, enc, encp, str, mode);
                            break;
                        }
                        case 117: {
                            if (p == end) {
                                ClassicRegexp.raisePreprocessError(context, str, "too short escape sequence", mode);
                            }
                            if (bytes[p] == 123) {
                                ++p;
                                if ((p = ClassicRegexp.unescapeUnicodeList(context, to, bytes, p, end, encp, str, mode)) != end && bytes[p++] == 125) continue block9;
                                ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode list", mode);
                                break;
                            }
                            p = ClassicRegexp.unescapeUnicodeBmp(context, to, bytes, p, end, encp, str, mode);
                            break;
                        }
                        case 112: {
                            if (encp[0] == null) {
                                hasProperty = true;
                            }
                            if (to == null) continue block9;
                            to.append(92).append(c);
                            break;
                        }
                        default: {
                            if (to == null) continue block9;
                            to.append(92).append(c);
                            break;
                        }
                    }
                    continue block9;
                }
                default: {
                    if (to == null) continue block9;
                    to.append(c);
                }
            }
        }
        return hasProperty;
    }

    private static int unescapeUnicodeBmp(RubyContext context, ByteList to, byte[] bytes, int p, int end, Encoding[] encp, Rope str, RegexpSupport.ErrorMode mode) {
        if (p + 4 > end) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode escape", mode);
        }
        int code = StringSupport.scanHex(bytes, p, 4);
        int len = StringSupport.hexLength(bytes, p, 4);
        if (len != 4) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode escape", mode);
        }
        ClassicRegexp.appendUtf8(context, to, code, encp, str, mode);
        return p + 4;
    }

    private static int unescapeUnicodeList(RubyContext context, ByteList to, byte[] bytes, int p, int end, Encoding[] encp, Rope str, RegexpSupport.ErrorMode mode) {
        while (p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF)) {
            ++p;
        }
        boolean hasUnicode = false;
        block1: while (true) {
            int code = StringSupport.scanHex(bytes, p, end - p);
            int len = StringSupport.hexLength(bytes, p, end - p);
            if (len == 0) break;
            if (len > 6) {
                ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode range", mode);
            }
            p += len;
            if (to != null) {
                ClassicRegexp.appendUtf8(context, to, code, encp, str, mode);
            }
            hasUnicode = true;
            while (true) {
                if (p >= end || !ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF)) continue block1;
                ++p;
            }
            break;
        }
        if (!hasUnicode) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode list", mode);
        }
        return p;
    }

    private static void appendUtf8(RubyContext context, ByteList to, int code, Encoding[] enc, Rope str, RegexpSupport.ErrorMode mode) {
        ClassicRegexp.checkUnicodeRange(context, code, str, mode);
        if (code < 128) {
            if (to != null) {
                to.append(String.format("\\x%02X", code).getBytes(StandardCharsets.US_ASCII));
            }
        } else {
            if (to != null) {
                to.ensure(to.getRealSize() + 6);
                to.setRealSize(to.getRealSize() + ClassicRegexp.utf8Decode(context, to.getUnsafeBytes(), to.getBegin() + to.getRealSize(), code));
            }
            if (enc[0] == null) {
                enc[0] = UTF8Encoding.INSTANCE;
            } else if (!enc[0].isUTF8()) {
                ClassicRegexp.raisePreprocessError(context, str, "UTF-8 character in non UTF-8 regexp", mode);
            }
        }
    }

    public static int utf8Decode(RubyContext context, byte[] to, int p, int code) {
        if (code <= 127) {
            to[p] = (byte)code;
            return 1;
        }
        if (code <= 2047) {
            to[p + 0] = (byte)(code >>> 6 & 0xFF | 0xC0);
            to[p + 1] = (byte)(code & 0x3F | 0x80);
            return 2;
        }
        if (code <= 65535) {
            to[p + 0] = (byte)(code >>> 12 & 0xFF | 0xE0);
            to[p + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 2] = (byte)(code & 0x3F | 0x80);
            return 3;
        }
        if (code <= 0x1FFFFF) {
            to[p + 0] = (byte)(code >>> 18 & 0xFF | 0xF0);
            to[p + 1] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p + 2] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 3] = (byte)(code & 0x3F | 0x80);
            return 4;
        }
        if (code <= 0x3FFFFFF) {
            to[p + 0] = (byte)(code >>> 24 & 0xFF | 0xF8);
            to[p + 1] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p + 2] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p + 3] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 4] = (byte)(code & 0x3F | 0x80);
            return 5;
        }
        if (code <= Integer.MAX_VALUE) {
            to[p + 0] = (byte)(code >>> 30 & 0xFF | 0xFC);
            to[p + 1] = (byte)(code >>> 24 & 0x3F | 0x80);
            to[p + 2] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p + 3] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p + 4] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p + 5] = (byte)(code & 0x3F | 0x80);
            return 6;
        }
        throw new RaiseException(context.getCoreExceptions().rangeError("pack(U): value out of range", null));
    }

    private static void checkUnicodeRange(RubyContext context, int code, Rope str, RegexpSupport.ErrorMode mode) {
        if (55296 <= code && code <= 57343 || 0x10FFFF < code) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid Unicode range", mode);
        }
    }

    private static int unescapeEscapedNonAscii(RubyContext context, ByteList to, byte[] bytes, int p, int end, Encoding enc, Encoding[] encp, Rope str, RegexpSupport.ErrorMode mode) {
        byte[] chBuf = new byte[enc.maxLength()];
        int chLen = 0;
        p = ClassicRegexp.readEscapedByte(context, chBuf, chLen++, bytes, p, end, str, mode);
        while (chLen < enc.maxLength() && StringSupport.MBCLEN_NEEDMORE_P(StringSupport.preciseLength(enc, chBuf, 0, chLen))) {
            p = ClassicRegexp.readEscapedByte(context, chBuf, chLen++, bytes, p, end, str, mode);
        }
        int cl = StringSupport.preciseLength(enc, chBuf, 0, chLen);
        if (cl == -1) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid multibyte escape", mode);
        }
        if (chLen > 1 || (chBuf[0] & 0x80) != 0) {
            if (to != null) {
                to.append(chBuf, 0, chLen);
            }
            if (encp[0] == null) {
                encp[0] = enc;
            } else if (encp[0] != enc) {
                ClassicRegexp.raisePreprocessError(context, str, "escaped non ASCII character in UTF-8 regexp", mode);
            }
        } else if (to != null) {
            to.append(String.format("\\x%02X", chBuf[0] & 0xFF).getBytes(StandardCharsets.US_ASCII));
        }
        return p;
    }

    public static int raisePreprocessError(RubyContext context, Rope str, String err, RegexpSupport.ErrorMode mode) {
        switch (mode) {
            case RAISE: {
                throw new RaiseException(context.getCoreExceptions().regexpError(err, null));
            }
            case PREPROCESS: {
                throw new RaiseException(context.getCoreExceptions().argumentError("regexp preprocess failed: " + err, null));
            }
        }
        return 0;
    }

    public static int readEscapedByte(RubyContext context, byte[] to, int toP, byte[] bytes, int p, int end, Rope str, RegexpSupport.ErrorMode mode) {
        if (p == end || bytes[p++] != 92) {
            ClassicRegexp.raisePreprocessError(context, str, "too short escaped multibyte character", mode);
        }
        boolean metaPrefix = false;
        boolean ctrlPrefix = false;
        int code = 0;
        block15: while (true) {
            if (p == end) {
                ClassicRegexp.raisePreprocessError(context, str, "too short escape sequence", mode);
            }
            switch (bytes[p++]) {
                case 92: {
                    code = 92;
                    break block15;
                }
                case 110: {
                    code = 10;
                    break block15;
                }
                case 116: {
                    code = 9;
                    break block15;
                }
                case 114: {
                    code = 13;
                    break block15;
                }
                case 102: {
                    code = 12;
                    break block15;
                }
                case 118: {
                    code = 11;
                    break block15;
                }
                case 97: {
                    code = 7;
                    break block15;
                }
                case 101: {
                    code = 27;
                    break block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int olen = end < --p + 3 ? end - p : 3;
                    code = StringSupport.scanOct(bytes, p, olen);
                    p += StringSupport.octLength(bytes, p, olen);
                    break block15;
                }
                case 120: {
                    int hlen = end < p + 2 ? end - p : 2;
                    code = StringSupport.scanHex(bytes, p, hlen);
                    int len = StringSupport.hexLength(bytes, p, hlen);
                    if (len < 1) {
                        ClassicRegexp.raisePreprocessError(context, str, "invalid hex escape", mode);
                    }
                    p += len;
                    break block15;
                }
                case 77: {
                    if (metaPrefix) {
                        ClassicRegexp.raisePreprocessError(context, str, "duplicate meta escape", mode);
                    }
                    metaPrefix = true;
                    if (p + 1 < end && bytes[p++] == 45 && (bytes[p] & 0x80) == 0) {
                        if (bytes[p] == 92) {
                            ++p;
                            continue block15;
                        }
                        code = bytes[p++] & 0xFF;
                        break block15;
                    }
                    ClassicRegexp.raisePreprocessError(context, str, "too short meta escape", mode);
                }
                case 67: {
                    if (p == end || bytes[p++] != 45) {
                        ClassicRegexp.raisePreprocessError(context, str, "too short control escape", mode);
                    }
                }
                case 99: {
                    if (ctrlPrefix) {
                        ClassicRegexp.raisePreprocessError(context, str, "duplicate control escape", mode);
                    }
                    ctrlPrefix = true;
                    if (p < end && (bytes[p] & 0x80) == 0) {
                        if (bytes[p] == 92) {
                            ++p;
                            continue block15;
                        }
                        code = bytes[p++] & 0xFF;
                        break block15;
                    }
                    ClassicRegexp.raisePreprocessError(context, str, "too short control escape", mode);
                }
                default: {
                    ClassicRegexp.raisePreprocessError(context, str, "unexpected escape sequence", mode);
                }
            }
            break;
        }
        if (code < 0 || code > 255) {
            ClassicRegexp.raisePreprocessError(context, str, "invalid escape code", mode);
        }
        if (ctrlPrefix) {
            code &= 0x1F;
        }
        if (metaPrefix) {
            code |= 0x80;
        }
        to[toP] = (byte)code;
        return p;
    }

    public static void preprocessCheck(RubyContext runtime, Rope bytes) {
        ClassicRegexp.preprocess(runtime, bytes, bytes.getEncoding(), new Encoding[]{null}, RegexpSupport.ErrorMode.RAISE);
    }

    public static ByteList preprocess(RubyContext runtime, Rope str, Encoding enc, Encoding[] fixedEnc, RegexpSupport.ErrorMode mode) {
        ByteList to = new ByteList(str.byteLength());
        if (enc.isAsciiCompatible()) {
            fixedEnc[0] = null;
        } else {
            fixedEnc[0] = enc;
            to.setEncoding(enc);
        }
        boolean hasProperty = ClassicRegexp.unescapeNonAscii(runtime, to, str.getBytes(), 0, str.byteLength(), enc, fixedEnc, str, mode);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
        if (fixedEnc[0] != null) {
            to.setEncoding(fixedEnc[0]);
        }
        return to;
    }

    public static ByteList preprocessDRegexp(RubyContext context, Rope[] strings, RegexpOptions options) {
        ByteList string = null;
        Encoding regexpEnc = null;
        for (int i = 0; i < strings.length; ++i) {
            Rope str = strings[i];
            Encoding[] encodingHolder = new Encoding[]{null};
            regexpEnc = ClassicRegexp.processDRegexpElement(context, options, regexpEnc, encodingHolder, str);
            if (string == null) {
                string = RopeOperations.getByteListReadOnly(str);
                continue;
            }
            string.append(str.getBytes());
        }
        if (regexpEnc != null) {
            string.setEncoding(regexpEnc);
        }
        return string;
    }

    private static Encoding processDRegexpElement(RubyContext context, RegexpOptions options, Encoding regexpEnc, Encoding[] fixedEnc, Rope str) {
        Encoding strEnc = str.getEncoding();
        if (options.isEncodingNone() && strEnc != ASCIIEncoding.INSTANCE) {
            if (str.getCodeRange() != CodeRange.CR_7BIT) {
                throw new RaiseException(context.getCoreExceptions().regexpError("/.../n has a non escaped non ASCII character in non ASCII-8BIT script", null));
            }
            strEnc = ASCIIEncoding.INSTANCE;
        }
        ClassicRegexp.preprocessLight(context, str, strEnc, fixedEnc, RegexpSupport.ErrorMode.PREPROCESS);
        if (fixedEnc[0] != null) {
            if (regexpEnc != null && regexpEnc != fixedEnc[0]) {
                throw new RaiseException(context.getCoreExceptions().regexpError("encoding mismatch in dynamic regexp: " + new String(regexpEnc.getName()) + " and " + new String(fixedEnc[0].getName()), null));
            }
            regexpEnc = fixedEnc[0];
        }
        return regexpEnc;
    }

    public static Rope quote19(Rope bs, boolean asciiOnly) {
        Encoding enc;
        byte[] bytes;
        int end;
        int p;
        block22: {
            p = 0;
            end = bs.byteLength();
            bytes = bs.getBytes();
            enc = bs.getEncoding();
            while (p < end) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes[p] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes, p, end);
                    c = enc.mbcToCode(bytes, p, end);
                }
                if (!Encoding.isAscii(c)) {
                    p += StringSupport.length(enc, bytes, p, end);
                    continue;
                }
                switch (c) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        break block22;
                    }
                    default: {
                        p += cl;
                        break;
                    }
                }
            }
            if (asciiOnly) {
                return bs.withEncoding(USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT);
            }
            return bs;
        }
        ByteList result = new ByteList(end * 2);
        result.setEncoding(asciiOnly ? USASCIIEncoding.INSTANCE : bs.getEncoding());
        byte[] obytes = result.getUnsafeBytes();
        int op = p;
        System.arraycopy(bytes, 0, obytes, 0, op);
        block13: while (p < end) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes[p] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes, p, end);
                c = enc.mbcToCode(bytes, p, end);
            }
            if (!Encoding.isAscii(c)) {
                int n = StringSupport.length(enc, bytes, p, end);
                while (n-- > 0) {
                    obytes[op++] = bytes[p++];
                }
                continue;
            }
            p += cl;
            switch (c) {
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    op += enc.codeToMbc(92, obytes, op);
                    break;
                }
                case 32: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(32, obytes, op);
                    continue block13;
                }
                case 9: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(116, obytes, op);
                    continue block13;
                }
                case 10: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(110, obytes, op);
                    continue block13;
                }
                case 13: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(114, obytes, op);
                    continue block13;
                }
                case 12: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(102, obytes, op);
                    continue block13;
                }
                case 11: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(118, obytes, op);
                    continue block13;
                }
            }
            op += enc.codeToMbc(c, obytes, op);
        }
        result.setRealSize(op);
        return RopeOperations.ropeFromByteList(result);
    }

    public ClassicRegexp regexpInitialize(Rope bytes, Encoding enc, RegexpOptions options) {
        this.options = options;
        if (this.pattern != null) {
            throw new RaiseException(this.context.getCoreExceptions().typeError("already initialized regexp", null));
        }
        if (enc.isDummy()) {
            throw new UnsupportedOperationException();
        }
        Encoding[] fixedEnc = new Encoding[]{null};
        ByteList unescaped = ClassicRegexp.preprocess(this.context, bytes, enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
        if (fixedEnc[0] != null) {
            if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                throw new UnsupportedOperationException();
            }
            if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                options.setFixed(true);
                enc = fixedEnc[0];
            }
        } else if (!options.isFixed()) {
            enc = USASCIIEncoding.INSTANCE;
        }
        if (fixedEnc[0] != null) {
            options.setFixed(true);
        }
        if (options.isEncodingNone()) {
            this.setEncodingNone();
        }
        this.pattern = ClassicRegexp.getRegexpFromCache(this.context, unescaped, enc, options);
        bytes.getClass();
        this.str = bytes;
        return this;
    }

    public static void appendOptions(ByteList to, RegexpOptions options) {
        if (options.isMultiline()) {
            to.append((byte)109);
        }
        if (options.isIgnorecase()) {
            to.append((byte)105);
        }
        if (options.isExtended()) {
            to.append((byte)120);
        }
    }

    public ByteList toByteList() {
        RegexpOptions newOptions = (RegexpOptions)this.options.clone();
        int p = 0;
        int len = this.str.byteLength();
        byte[] bytes = this.str.getBytes();
        ByteList result = new ByteList(len);
        result.append((byte)40).append((byte)63);
        while (len >= 4 && bytes[p] == 40 && bytes[p + 1] == 63) {
            boolean err = true;
            p += 2;
            if ((len -= 2) > 0) {
                do {
                    if (bytes[p] == 109) {
                        newOptions.setMultiline(true);
                    } else if (bytes[p] == 105) {
                        newOptions.setIgnorecase(true);
                    } else {
                        if (bytes[p] != 120) break;
                        newOptions.setExtended(true);
                    }
                    ++p;
                } while (--len > 0);
            }
            if (len > 1 && bytes[p] == 45) {
                ++p;
                --len;
                do {
                    if (bytes[p] == 109) {
                        newOptions.setMultiline(false);
                    } else if (bytes[p] == 105) {
                        newOptions.setIgnorecase(false);
                    } else {
                        if (bytes[p] != 120) break;
                        newOptions.setExtended(false);
                    }
                    ++p;
                } while (--len > 0);
            }
            if (bytes[p] == 41) {
                --len;
                ++p;
                continue;
            }
            if (bytes[p] == 58 && bytes[p + len - 1] == 41) {
                try {
                    Regex regex = new Regex(bytes, ++p, p + (len -= 2), 0, this.str.getEncoding(), Syntax.DEFAULT);
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            newOptions = this.options;
            p = 0;
            len = this.str.byteLength();
            break;
        }
        ClassicRegexp.appendOptions(result, newOptions);
        if (!newOptions.isEmbeddable()) {
            result.append((byte)45);
            if (!newOptions.isMultiline()) {
                result.append((byte)109);
            }
            if (!newOptions.isIgnorecase()) {
                result.append((byte)105);
            }
            if (!newOptions.isExtended()) {
                result.append((byte)120);
            }
        }
        result.append((byte)58);
        this.appendRegexpString19(result, bytes, p, len, this.str.getEncoding(), null);
        result.append((byte)41);
        result.setEncoding(this.getEncoding());
        return result;
    }

    public void appendRegexpString19(ByteList to, byte[] bytes, int start, int len, Encoding enc, Encoding resEnc) {
        int p = start;
        int end = p + len;
        boolean needEscape = false;
        while (p < end) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes[p] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes, p, end);
                c = enc.mbcToCode(bytes, p, end);
            }
            if (!Encoding.isAscii(c)) {
                p += StringSupport.length(enc, bytes, p, end);
                continue;
            }
            if (c != 47 && enc.isPrint(c)) {
                p += cl;
                continue;
            }
            needEscape = true;
            break;
        }
        if (!needEscape) {
            to.append(bytes, start, len);
        } else {
            boolean isUnicode = StringSupport.isUnicode(enc);
            p = start;
            while (p < end) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes[p] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes, p, end);
                    c = enc.mbcToCode(bytes, p, end);
                }
                if (c == 92 && p + cl < end) {
                    int n = cl + StringSupport.length(enc, bytes, p + cl, end);
                    to.append(bytes, p, n);
                    p += n;
                    continue;
                }
                if (c == 47) {
                    to.append((byte)92);
                    to.append(bytes, p, cl);
                } else {
                    if (!Encoding.isAscii(c)) {
                        int l = StringSupport.preciseLength(enc, bytes, p, end);
                        if (l <= 0) {
                            l = 1;
                            to.append(String.format("\\x%02X", c).getBytes(StandardCharsets.US_ASCII));
                        } else if (resEnc != null) {
                            int code = enc.mbcToCode(bytes, p, end);
                            to.append(String.format(StringSupport.escapedCharFormat(code, isUnicode), code).getBytes(StandardCharsets.US_ASCII));
                        } else {
                            to.append(bytes, p, l);
                        }
                        p += l;
                        continue;
                    }
                    if (enc.isPrint(c)) {
                        to.append(bytes, p, cl);
                    } else if (!enc.isSpace(c)) {
                        to.append(String.format("\\x%02X", c).getBytes(StandardCharsets.US_ASCII));
                    } else {
                        to.append(bytes, p, cl);
                    }
                }
                p += cl;
            }
        }
    }

    public String[] getNames() {
        int nameLength = this.pattern.numberOfNames();
        if (nameLength == 0) {
            return StringSupport.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[nameLength];
        int j = 0;
        Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
        while (i.hasNext()) {
            NameEntry e = i.next();
            names[j++] = new String(e.name, e.nameP, e.nameEnd - e.nameP).intern();
        }
        return names;
    }

    private static class SearchMatchTask {
        final int start;
        final int range;
        final int option;
        final boolean match;

        SearchMatchTask(int start, int range, int option, boolean match) {
            this.start = start;
            this.range = range;
            this.option = option;
            this.match = match;
        }

        public Integer run(Object context, Matcher matcher) throws InterruptedException {
            return this.match ? matcher.matchInterruptible(this.start, this.range, this.option) : matcher.searchInterruptible(this.start, this.range, this.option);
        }
    }
}

