/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.segment;

import java.util.ArrayList;
import org.ictclas4j.bean.Atom;
import org.ictclas4j.bean.Dictionary;
import org.ictclas4j.bean.SegNode;
import org.ictclas4j.bean.WordItem;
import org.ictclas4j.segment.SegGraph;
import org.ictclas4j.utility.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphGenerate {
    public static SegGraph generate(ArrayList<Atom> atoms, Dictionary dict) {
        SegGraph segGraph = null;
        SegNode sn = null;
        Atom atom = null;
        if (atoms != null && atoms.size() > 0 && dict != null) {
            segGraph = new SegGraph();
            for (int i = 0; i < atoms.size(); ++i) {
                atom = atoms.get(i);
                String word = atom.getWord();
                if (atom.getPos() == 7) {
                    sn = new SegNode(i, i + 1, 0, 0.0, atom.getWord());
                } else {
                    double value = 2079997.0;
                    int pos = 0;
                    switch (atom.getPos()) {
                        case 9: 
                        case 10: {
                            pos = -27904;
                            word = "\u672a##\u6570";
                            value = 0.0;
                            break;
                        }
                        case 6: {
                            pos = 30464;
                            break;
                        }
                        case 8: {
                            pos = -28280;
                            value = 0.0;
                            word = "\u672a##\u4e32";
                            break;
                        }
                        case 5: {
                            if (Utility.getCharCount("+-1234567890", atom.getWord()) == atom.getLen()) {
                                pos = -27904;
                                word = "\u672a##\u6570";
                            } else {
                                pos = -28280;
                                word = "\u672a##\u4e32";
                            }
                            value = 0.0;
                            break;
                        }
                        default: {
                            pos = atom.getPos();
                        }
                    }
                    sn = new SegNode(i, i + 1, pos, value, word);
                }
                sn.setSrcWord(atom.getWord());
                segGraph.insert(sn, true);
            }
            String word = null;
            block7: for (int i = 0; i < atoms.size(); ++i) {
                int j = i + 1;
                word = atoms.get(i).getWord();
                boolean flag = false;
                if (j < atoms.size()) {
                    Atom a2 = atoms.get(j);
                    if ("\u6708".equals(word) && "\u4efd".equals(a2.getWord())) {
                        segGraph.delete(i, j);
                        segGraph.delete(i + 1, j + 1);
                        word = word + a2.getWord();
                        flag = true;
                        ++j;
                    }
                }
                WordItem wi = null;
                while (j <= atoms.size()) {
                    int totalFreq = 0;
                    wi = dict.getMaxMatch(word);
                    if (wi == null) continue block7;
                    if (word.equals(wi.getWord())) {
                        SegNode g2;
                        ArrayList<WordItem> wis = dict.getHandle(word);
                        for (WordItem w : wis) {
                            totalFreq += w.getFreq();
                        }
                        if (word.length() == 2 && segGraph.getSize() > 0 && (Utility.isAllNum((g2 = segGraph.getLast()).getWord()) || Utility.isAllChinese(g2.getWord()) && (g2.getWord().indexOf("\u5e74") == 0 || g2.getWord().indexOf("\u6708") == 0)) && "\u672b\u5185\u4e2d\u5e95\u524d\u95f4\u521d".indexOf(word.substring(1)) != -1) continue block7;
                        SegNode sg = null;
                        sg = wis.size() == 1 ? new SegNode(i, j, wis.get(0).getHandle(), totalFreq, word) : new SegNode(i, j, 0, totalFreq, word);
                        segGraph.insert(sg, true);
                    }
                    if (flag) {
                        ++i;
                    }
                    if (j >= atoms.size()) continue block7;
                    String word2 = atoms.get(j).getWord();
                    word = word + word2;
                    ++j;
                }
            }
        }
        return segGraph;
    }

    public static SegGraph biGenerate(SegGraph seg, Dictionary dict, Dictionary biDict) {
        SegGraph segGraph = null;
        double smoothParam = 0.1;
        if (seg != null && dict != null && biDict != null) {
            segGraph = new SegGraph();
            ArrayList<SegNode> sgs = seg.getSnList();
            SegGraph.NextElementIndex nextEleIndex = new SegGraph.NextElementIndex(seg);
            for (int i = 0; sgs != null && i < sgs.size(); ++i) {
                SegNode sg = sgs.get(i);
                double curFreq = sg.getPos() >= 0 ? sg.getValue() : (double)dict.getFreq(sg.getWord(), 2);
                ArrayList<SegNode> nextSgs = nextEleIndex.getNextElements(i);
                for (SegNode graph : nextSgs) {
                    String twoWords = sg.getWord();
                    twoWords = twoWords + "@";
                    twoWords = twoWords + graph.getWord();
                    int twoFreq = biDict.getFreq(twoWords, 3);
                    double temp = 4.807699241873907E-7;
                    double value = 0.1 * (1.0 + curFreq) / 2159997.0;
                    value += 0.9 * ((1.0 - temp) * (double)twoFreq / (1.0 + curFreq) + temp);
                    if ((value = -Math.log(value)) < 0.0) {
                        value += sg.getValue();
                    }
                    SegNode sg2 = new SegNode();
                    int wordIndex = GraphGenerate.getWordIndex(sgs, sg);
                    sg2.setRow(wordIndex);
                    wordIndex = GraphGenerate.getWordIndex(sgs, graph);
                    sg2.setCol(wordIndex);
                    sg2.setWord(twoWords);
                    sg2.setPos(sg.getPos());
                    sg2.setValue(value);
                    segGraph.insert(sg2, false);
                }
            }
        }
        return segGraph;
    }

    private static int getWordIndex(ArrayList<SegNode> sgs, SegNode graph) {
        if (sgs != null && graph != null) {
            for (int i = 0; i < sgs.size(); ++i) {
                if (sgs.get(i) != graph) continue;
                return i;
            }
        }
        return -1;
    }
}

