/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.uml1_4.tools;

import ch.ehi.basics.types.NlsString;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Feature;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.implementation.UmlModel;

public class ModelElementUtility {
    private ModelElementUtility() {
    }

    public static String getUmlPath(ModelElement element, String language) {
        if (language == null) {
            language = NlsString.getDefaultLanguage();
        }
        Namespace parent = null;
        if (element instanceof Feature) {
            if (!((Feature)element).containsOwner()) {
                throw new IllegalStateException(element.getDefLangName() + " not inside an Owner");
            }
            parent = ((Feature)element).getOwner();
        } else {
            if (element instanceof AssociationEnd) {
                if (!((AssociationEnd)element).containsAssociation()) {
                    throw new IllegalStateException(element.getDefLangName() + " not inside an Association");
                }
                return ModelElementUtility.getUmlPath(((AssociationEnd)element).getAssociation(), language);
            }
            if (!element.containsNamespace()) {
                throw new IllegalStateException(element.getDefLangName() + " not inside a Namespace");
            }
            parent = element.getNamespace();
        }
        if (parent instanceof UmlModel) {
            return "";
        }
        StringBuffer ret = new StringBuffer(parent.getName().getValue(language));
        while (parent.containsNamespace() && !((parent = parent.getNamespace()) instanceof UmlModel)) {
            ret.insert(0, parent.getName().getValue(language) + ".");
        }
        return ret.toString();
    }
}

