/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getSupportTokens", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "isNegated", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "EnumEqualsIntrinsic", "EqualsIntrinsic", "kotlin-compiler"})
public final class EqualsBOIF
implements BinaryOperationIntrinsicFactory {
    public static final EqualsBOIF INSTANCE;

    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        return OperatorConventions.EQUALS_OPERATIONS;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return DescriptorUtils.isEnumClass(descriptor2.getContainingDeclaration()) ? (BinaryOperationIntrinsic)EnumEqualsIntrinsic.INSTANCE : (JsDescriptorUtils.isBuiltin(descriptor2) || TopLevelFIF.EQUALS_IN_ANY.apply(descriptor2) ? (BinaryOperationIntrinsic)EqualsIntrinsic.INSTANCE : (BinaryOperationIntrinsic)null);
    }

    private final boolean isNegated(@NotNull KtBinaryExpression $receiver) {
        return Intrinsics.areEqual(PsiUtils.getOperationToken($receiver), KtTokens.EXCLEQ);
    }

    private EqualsBOIF() {
        INSTANCE = this;
    }

    static {
        new EqualsBOIF();
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "canUseSimpleEquals", "", "kotlin-compiler"})
    private static final class EqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final EqualsIntrinsic INSTANCE;

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            isNegated = EqualsBOIF.access$isNegated(EqualsBOIF.INSTANCE, expression);
            if (Intrinsics.areEqual(right, JsLiteral.NULL) || Intrinsics.areEqual(left, JsLiteral.NULL)) {
                v0 = TranslationUtils.nullCheck(Intrinsics.areEqual(right, JsLiteral.NULL) != false ? left : right, isNegated);
                Intrinsics.checkExpressionValueIsNotNull(v0, "TranslationUtils.nullChe\u2026ft else right, isNegated)");
                return v0;
            }
            if (this.canUseSimpleEquals(expression, context)) {
                return new JsBinaryOperation(isNegated != false ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ, left, right);
            }
            v1 = expression;
            v2 = context.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(v2, "context.bindingContext()");
            resolvedCall = CallUtilKt.getResolvedCall(v1, v2);
            if (resolvedCall == null) ** GOTO lbl-1000
            var7_7 = resolvedCall.getDispatchReceiver();
            var8_8 = var7_7;
            if ($receiver != null ? DynamicTypesKt.isDynamic($receiver.getType()) : false) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = appliedToDynamic = false;
            }
            if (appliedToDynamic) {
                return new JsBinaryOperation(isNegated != false ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ, left, right);
            }
            result = TopLevelFIF.KOTLIN_EQUALS.apply(left, Arrays.asList(new JsExpression[]{right}), context);
            if (isNegated) {
                v4 = JsAstUtils.negated(result);
                v5 = v4;
                Intrinsics.checkExpressionValueIsNotNull(v4, "JsAstUtils.negated(result)");
            } else {
                v6 = result;
                v5 = v6;
                Intrinsics.checkExpressionValueIsNotNull(v6, "result");
            }
            return v5;
        }

        private final boolean canUseSimpleEquals(KtBinaryExpression expression, TranslationContext context) {
            Name typeName;
            KtExpression left = expression.getLeft();
            boolean bl = left != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "No left-hand side: " + expression.getText();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtExpression ktExpression = left;
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return (typeName = JsDescriptorUtils.getNameIfStandardType(ktExpression, context)) != null && NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName);
        }

        private EqualsIntrinsic() {
            INSTANCE = this;
        }

        static {
            new EqualsIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EnumEqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
    public static final class EnumEqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final EnumEqualsIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsBinaryOperation apply(@NotNull KtBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = INSTANCE.isNegated(expression) ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ;
            return new JsBinaryOperation(operator, left, right);
        }

        private EnumEqualsIntrinsic() {
            INSTANCE = this;
        }

        static {
            new EnumEqualsIntrinsic();
        }
    }
}

